/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.Objects;
import org.gedcomx.common.URI;
import org.gedcomx.rt.json.HasJsonKey;
import org.gedcomx.types.IdentifierType;

@XmlType(name="Identifier")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class Identifier
implements HasJsonKey {
    private boolean hasUniqueKey = false;
    private URI value;
    private URI type;

    public Identifier() {
    }

    @JsonCreator
    public Identifier(URI value) {
        this.value = value;
    }

    public Identifier(URI value, IdentifierType knownType) {
        this.value = value;
        this.setKnownType(knownType);
    }

    @XmlValue
    @JsonValue
    public URI getValue() {
        return this.value;
    }

    @JsonValue
    public void setValue(URI value) {
        this.value = value;
    }

    public Identifier value(URI value) {
        this.setValue(value);
        return this;
    }

    @XmlAttribute
    @JsonIgnore
    @XmlQNameEnumRef(value=IdentifierType.class)
    public URI getType() {
        return this.type;
    }

    @JsonIgnore
    public void setType(URI type) {
        this.type = type;
    }

    public Identifier type(URI type) {
        this.setType(type);
        return this;
    }

    public Identifier type(IdentifierType type) {
        this.setKnownType(type);
        return this;
    }

    public void setType(URI type, boolean unique) {
        this.type = type;
        this.hasUniqueKey = unique;
    }

    @XmlTransient
    @JsonIgnore
    public IdentifierType getKnownType() {
        return this.getType() == null ? null : IdentifierType.fromQNameURI(this.getType());
    }

    @JsonIgnore
    public void setKnownType(IdentifierType knownType) {
        this.setType(knownType == null ? null : knownType.toQNameURI());
    }

    @XmlTransient
    @JsonIgnore
    public boolean isHasUniqueKey() {
        return this.hasUniqueKey;
    }

    @XmlTransient
    @JsonIgnore
    public String getJsonKey() {
        return this.type == null ? null : this.type.toString();
    }

    @JsonIgnore
    public void setJsonKey(String jsonKey) {
        this.type = new URI(jsonKey);
    }

    public String toString() {
        return this.value == null ? "" : this.value.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Identifier that = (Identifier)o;
        return this.hasUniqueKey == that.hasUniqueKey && Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.hasUniqueKey, this.type, this.value);
    }
}

