/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.gedcomx.common.ExtensibleData;
import org.gedcomx.conclusion.NamePart;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.types.NamePartType;

@XmlType(name="NameForm", propOrder={"fullText", "parts", "fields"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class NameForm
extends ExtensibleData
implements HasFields {
    private String lang;
    private String fullText;
    private List<NamePart> parts;
    private List<Field> fields;

    public NameForm() {
    }

    public NameForm(String fullText, NamePart ... parts) {
        this.fullText = fullText;
        for (NamePart part : parts) {
            this.addPart(part);
        }
    }

    @Override
    public NameForm id(String id) {
        return (NameForm)super.id(id);
    }

    @Override
    public NameForm extensionElement(Object element) {
        return (NameForm)super.extensionElement(element);
    }

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public NameForm lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String fullText) {
        this.fullText = fullText;
    }

    public NameForm fullText(String fullText) {
        this.setFullText(fullText);
        return this;
    }

    public Stream<NamePart> parts() {
        return this.parts == null ? Stream.empty() : this.parts.stream();
    }

    @XmlElement(name="part")
    @JsonProperty(value="parts")
    public List<NamePart> getParts() {
        return this.parts;
    }

    @JsonProperty(value="parts")
    public void setParts(List<NamePart> parts) {
        this.parts = parts;
    }

    public NameForm part(NamePart part) {
        this.addPart(part);
        return this;
    }

    public NameForm part(NamePartType partType, String value) {
        this.addPart(new NamePart(partType, value));
        return this;
    }

    public void addPart(NamePart part) {
        if (part != null) {
            if (this.parts == null) {
                this.parts = new LinkedList<NamePart>();
            }
            this.parts.add(part);
        }
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @Facet(value="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public NameForm field(Field field) {
        this.addField(field);
        return this;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitNameForm(this);
    }
}

