/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.rt;

import jakarta.xml.bind.annotation.XmlTransient;
import java.util.LinkedList;
import java.util.List;
import org.gedcomx.Gedcomx;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.EvidenceReference;
import org.gedcomx.common.Note;
import org.gedcomx.conclusion.Conclusion;
import org.gedcomx.conclusion.Date;
import org.gedcomx.conclusion.Document;
import org.gedcomx.conclusion.Event;
import org.gedcomx.conclusion.EventRole;
import org.gedcomx.conclusion.Fact;
import org.gedcomx.conclusion.Gender;
import org.gedcomx.conclusion.Name;
import org.gedcomx.conclusion.NameForm;
import org.gedcomx.conclusion.NamePart;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.PlaceDescription;
import org.gedcomx.conclusion.PlaceReference;
import org.gedcomx.conclusion.Relationship;
import org.gedcomx.conclusion.Subject;
import org.gedcomx.records.Collection;
import org.gedcomx.records.Field;
import org.gedcomx.records.FieldValue;
import org.gedcomx.records.RecordDescriptor;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.source.SourceCitation;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;

@XmlTransient
public class GedcomxModelVisitorBase
implements GedcomxModelVisitor {
    protected final LinkedList<Object> contextStack = new LinkedList();

    @Override
    public void visitGedcomx(Gedcomx gx) {
        List<Collection> list;
        List<RecordDescriptor> list2;
        List<Field> list3;
        List<Document> list4;
        List<PlaceDescription> list5;
        List<Event> list6;
        List<Agent> list7;
        List<SourceDescription> list8;
        List<Relationship> relationships;
        this.contextStack.push(gx);
        List<Person> persons = gx.getPersons();
        if (persons != null) {
            for (Person person : persons) {
                if (person == null) continue;
                person.accept(this);
            }
        }
        if ((relationships = gx.getRelationships()) != null) {
            for (Relationship relationship : relationships) {
                if (relationship == null) continue;
                relationship.accept(this);
            }
        }
        if ((list8 = gx.getSourceDescriptions()) != null) {
            for (SourceDescription sourceDescription : list8) {
                if (sourceDescription == null) continue;
                sourceDescription.accept(this);
            }
        }
        if ((list7 = gx.getAgents()) != null) {
            for (Agent agent : list7) {
                if (agent == null) continue;
                agent.accept(this);
            }
        }
        if ((list6 = gx.getEvents()) != null) {
            for (Event event : list6) {
                if (event == null) continue;
                event.accept(this);
            }
        }
        if ((list5 = gx.getPlaces()) != null) {
            for (PlaceDescription placeDescription : list5) {
                if (placeDescription == null) continue;
                placeDescription.accept(this);
            }
        }
        if ((list4 = gx.getDocuments()) != null) {
            for (Document document : list4) {
                if (document == null) continue;
                document.accept(this);
            }
        }
        if ((list3 = gx.getFields()) != null) {
            for (Field field : list3) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        if ((list2 = gx.getRecordDescriptors()) != null) {
            for (RecordDescriptor rd : list2) {
                if (rd == null) continue;
                rd.accept(this);
            }
        }
        if ((list = gx.getCollections()) != null) {
            for (Collection collection : list) {
                if (collection == null) continue;
                collection.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitDocument(Document document) {
        this.contextStack.push(document);
        this.visitConclusion(document);
        this.contextStack.pop();
    }

    @Override
    public void visitPlaceDescription(PlaceDescription place) {
        this.contextStack.push(place);
        this.visitSubject(place);
        this.contextStack.pop();
    }

    @Override
    public void visitEvent(Event event) {
        List<EventRole> roles;
        PlaceReference place;
        this.contextStack.push(event);
        this.visitSubject(event);
        Date date = event.getDate();
        if (date != null) {
            date.accept(this);
        }
        if ((place = event.getPlace()) != null) {
            place.accept(this);
        }
        if ((roles = event.getRoles()) != null) {
            for (EventRole role : roles) {
                if (role == null) continue;
                role.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitEventRole(EventRole role) {
        this.contextStack.push(role);
        this.visitConclusion(role);
        this.contextStack.pop();
    }

    @Override
    public void visitAgent(Agent agent) {
    }

    @Override
    public void visitSourceDescription(SourceDescription sourceDescription) {
        List<Field> list;
        List<SourceCitation> list2;
        List<Note> notes;
        this.contextStack.push(sourceDescription);
        List<SourceReference> sources = sourceDescription.getSources();
        if (sources != null) {
            for (SourceReference sourceReference : sources) {
                if (sourceReference == null) continue;
                sourceReference.accept(this);
            }
        }
        if ((notes = sourceDescription.getNotes()) != null) {
            for (Note note : notes) {
                if (note == null) continue;
                note.accept(this);
            }
        }
        if ((list2 = sourceDescription.getCitations()) != null) {
            for (SourceCitation citation : list2) {
                if (citation == null) continue;
                citation.accept(this);
            }
        }
        if ((list = sourceDescription.getFields()) != null) {
            for (Field field : list) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitSourceCitation(SourceCitation citation) {
    }

    @Override
    public void visitCollection(Collection collection) {
    }

    @Override
    public void visitRecordDescriptor(RecordDescriptor recordDescriptor) {
    }

    @Override
    public void visitField(Field field) {
        this.contextStack.push(field);
        this.visitConclusion(field);
        List<FieldValue> values = field.getValues();
        if (values != null) {
            for (FieldValue value : values) {
                if (value == null) continue;
                value.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitFieldValue(FieldValue fieldValue) {
        this.contextStack.push(fieldValue);
        this.visitConclusion(fieldValue);
        this.contextStack.pop();
    }

    @Override
    public void visitRelationship(Relationship relationship) {
        List<Field> fields;
        this.contextStack.push(relationship);
        this.visitSubject(relationship);
        List<Fact> facts = relationship.getFacts();
        if (facts != null) {
            for (Fact fact : facts) {
                if (fact == null) continue;
                fact.accept(this);
            }
        }
        if ((fields = relationship.getFields()) != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    protected void visitConclusion(Conclusion conclusion) {
        List<Note> notes;
        List<SourceReference> sourceReferences = conclusion.getSources();
        if (sourceReferences != null) {
            for (SourceReference sourceReference : sourceReferences) {
                if (sourceReference == null) continue;
                sourceReference.accept(this);
            }
        }
        if ((notes = conclusion.getNotes()) != null) {
            for (Note note : notes) {
                if (note == null) continue;
                note.accept(this);
            }
        }
    }

    protected void visitSubject(Subject subject) {
        List<EvidenceReference> evidence;
        this.visitConclusion(subject);
        List<SourceReference> media = subject.getMedia();
        if (media != null) {
            for (SourceReference reference : media) {
                if (reference == null) continue;
                reference.accept(this);
            }
        }
        if ((evidence = subject.getEvidence()) != null) {
            for (EvidenceReference evidenceReference : evidence) {
                if (evidenceReference == null) continue;
                evidenceReference.accept(this);
            }
        }
    }

    @Override
    public void visitPerson(Person person) {
        List<Field> list;
        List<Fact> facts;
        List<Name> names;
        this.contextStack.push(person);
        this.visitSubject(person);
        if (person.getGender() != null) {
            person.getGender().accept(this);
        }
        if ((names = person.getNames()) != null) {
            for (Name name : names) {
                if (name == null) continue;
                name.accept(this);
            }
        }
        if ((facts = person.getFacts()) != null) {
            for (Fact fact : facts) {
                if (fact == null) continue;
                fact.accept(this);
            }
        }
        if ((list = person.getFields()) != null) {
            for (Field field : list) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitFact(Fact fact) {
        List<Field> fields;
        PlaceReference place;
        this.contextStack.push(fact);
        this.visitConclusion(fact);
        Date date = fact.getDate();
        if (date != null) {
            date.accept(this);
        }
        if ((place = fact.getPlace()) != null) {
            place.accept(this);
        }
        if ((fields = fact.getFields()) != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitPlaceReference(PlaceReference place) {
        this.contextStack.push(place);
        List<Field> fields = place.getFields();
        if (fields != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitDate(Date date) {
        this.contextStack.push(date);
        List<Field> fields = date.getFields();
        if (fields != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitName(Name name) {
        this.contextStack.push(name);
        this.visitConclusion(name);
        List<NameForm> forms = name.getNameForms();
        if (forms != null) {
            for (NameForm form : forms) {
                if (form == null) continue;
                form.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitNameForm(NameForm form) {
        List<Field> fields;
        this.contextStack.push(form);
        List<NamePart> parts = form.getParts();
        if (parts != null) {
            for (NamePart part : parts) {
                if (part == null) continue;
                part.accept(this);
            }
        }
        if ((fields = form.getFields()) != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitNamePart(NamePart part) {
        this.contextStack.push(part);
        List<Field> fields = part.getFields();
        if (fields != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitGender(Gender gender) {
        this.contextStack.push(gender);
        this.visitConclusion(gender);
        List<Field> fields = gender.getFields();
        if (fields != null) {
            for (Field field : fields) {
                if (field == null) continue;
                field.accept(this);
            }
        }
        this.contextStack.pop();
    }

    @Override
    public void visitSourceReference(SourceReference sourceReference) {
    }

    @Override
    public void visitNote(Note note) {
    }

    @Override
    public void visitEvidenceReference(EvidenceReference evidenceReference) {
    }

    public LinkedList<Object> getContextStack() {
        return this.contextStack;
    }
}

