/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.types;

import com.webcohesion.enunciate.metadata.qname.XmlQNameEnum;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.gedcomx.common.URI;
import org.gedcomx.rt.ControlledVocabulary;
import org.gedcomx.rt.EnumURIMap;

@XmlQNameEnum(base=XmlQNameEnum.BaseType.URI)
public enum FactType implements ControlledVocabulary
{
    Adoption,
    AdultChristening,
    Amnesty,
    Apprenticeship,
    Arrest,
    Award,
    Baptism,
    BarMitzvah,
    BatMitzvah,
    Birth,
    BirthNotice,
    Blessing,
    Branch,
    Burial,
    Caste,
    Census,
    Christening,
    Circumcision,
    Clan,
    Confirmation,
    Court,
    Cremation,
    Death,
    Education,
    EducationEnrollment,
    Emigration,
    Enslavement,
    Ethnicity,
    Excommunication,
    FirstCommunion,
    Funeral,
    GenderChange,
    Graduation,
    Heimat,
    Immigration,
    Imprisonment,
    Inquest,
    LandTransaction,
    Language,
    Living,
    MaritalStatus,
    Medical,
    MilitaryAward,
    MilitaryDischarge,
    MilitaryDraftRegistration,
    MilitaryInduction,
    MilitaryService,
    Mission,
    MoveFrom,
    MoveTo,
    MultipleBirth,
    NationalId,
    Nationality,
    Naturalization,
    NumberOfMarriages,
    Obituary,
    Occupation,
    Ordination,
    Pardon,
    PhysicalDescription,
    Probate,
    Property,
    Race,
    Religion,
    Residence,
    Retirement,
    Stillbirth,
    TaxAssessment,
    Tribe,
    Will,
    Visit,
    Yahrzeit,
    Annulment,
    CommonLawMarriage,
    CivilUnion,
    Divorce,
    DivorceFiling,
    DomesticPartnership,
    Engagement,
    Marriage,
    MarriageBanns,
    MarriageContract,
    MarriageLicense,
    MarriageNotice,
    NumberOfChildren,
    Separation,
    AdoptiveParent,
    BiologicalParent,
    FosterParent,
    GuardianParent,
    StepParent,
    SociologicalParent,
    SurrogateParent,
    OTHER;

    public static final Set<FactType> BIRTHLIKE_FACT_TYPES;
    public static final Set<FactType> DEATHLIKE_FACT_TYPES;
    public static final Set<FactType> MARRIAGELIKE_FACT_TYPES;
    public static final Set<FactType> DIVORCELIKE_FACT_TYPES;
    public static final Set<FactType> MIGRATIONLIKE_FACT_TYPES;
    private static final EnumURIMap<FactType> URI_MAP;

    public boolean isBirthLike() {
        return BIRTHLIKE_FACT_TYPES.contains(this);
    }

    public boolean isDeathLike() {
        return DEATHLIKE_FACT_TYPES.contains(this);
    }

    public boolean isMarriageLike() {
        return MARRIAGELIKE_FACT_TYPES.contains(this);
    }

    public boolean isDivorceLike() {
        return DIVORCELIKE_FACT_TYPES.contains(this);
    }

    public boolean isMigrationLike() {
        return MIGRATIONLIKE_FACT_TYPES.contains(this);
    }

    @Override
    public URI toQNameURI() {
        return URI_MAP.toURIValue(this);
    }

    public static FactType fromQNameURI(URI qname) {
        return URI_MAP.fromURIValue(qname);
    }

    static {
        BIRTHLIKE_FACT_TYPES = Collections.unmodifiableSet(EnumSet.of(Baptism, new FactType[]{Birth, BirthNotice, Christening, Blessing, Circumcision, Adoption}));
        DEATHLIKE_FACT_TYPES = Collections.unmodifiableSet(EnumSet.of(Death, new FactType[]{Burial, Cremation, Funeral, Obituary, Probate, Will}));
        MARRIAGELIKE_FACT_TYPES = Collections.unmodifiableSet(EnumSet.of(Marriage, new FactType[]{Engagement, MarriageBanns, MarriageContract, MarriageLicense, MarriageNotice}));
        DIVORCELIKE_FACT_TYPES = Collections.unmodifiableSet(EnumSet.of(Divorce, DivorceFiling, Annulment, Separation));
        MIGRATIONLIKE_FACT_TYPES = Collections.unmodifiableSet(EnumSet.of(Immigration, Emigration, Naturalization, MoveTo, MoveFrom));
        URI_MAP = new EnumURIMap<FactType>(FactType.class, "http://gedcomx.org/");
    }

    @XmlTransient
    public static final class ParentChild {
        private static final EnumSet<FactType> PARENT_CHILD_FACT_TYPES = EnumSet.noneOf(FactType.class);
        public static final FactType AdoptiveParent = ParentChild.include(AdoptiveParent);
        public static final FactType BiologicalParent = ParentChild.include(BiologicalParent);
        public static final FactType FosterParent = ParentChild.include(FosterParent);
        public static final FactType GuardianParent = ParentChild.include(GuardianParent);
        public static final FactType StepParent = ParentChild.include(StepParent);
        public static final FactType SociologicalParent = ParentChild.include(SociologicalParent);
        public static final FactType SurrogateParent = ParentChild.include(SurrogateParent);

        private ParentChild() {
        }

        private static FactType include(FactType type) {
            PARENT_CHILD_FACT_TYPES.add(type);
            return type;
        }

        public static boolean isApplicable(FactType type) {
            return PARENT_CHILD_FACT_TYPES.contains(type);
        }
    }

    @XmlTransient
    public static final class Couple {
        private static final EnumSet<FactType> COUPLE_FACT_TYPES = EnumSet.noneOf(FactType.class);
        public static final FactType Annulment = Couple.include(Annulment);
        public static final FactType CommonLawMarriage = Couple.include(CommonLawMarriage);
        public static final FactType CivilUnion = Couple.include(CivilUnion);
        public static final FactType DomesticPartnership = Couple.include(DomesticPartnership);
        public static final FactType Divorce = Couple.include(Divorce);
        public static final FactType DivorceFiling = Couple.include(DivorceFiling);
        public static final FactType Engagement = Couple.include(Engagement);
        public static final FactType Marriage = Couple.include(Marriage);
        public static final FactType MarriageBanns = Couple.include(MarriageBanns);
        public static final FactType MarriageContract = Couple.include(MarriageContract);
        public static final FactType MarriageLicense = Couple.include(MarriageLicense);
        public static final FactType MarriageNotice = Couple.include(MarriageNotice);
        public static final FactType NumberOfChildren = Couple.include(NumberOfChildren);
        public static final FactType Separation = Couple.include(Separation);

        private Couple() {
        }

        private static FactType include(FactType type) {
            COUPLE_FACT_TYPES.add(type);
            return type;
        }

        public static boolean isApplicable(FactType type) {
            return COUPLE_FACT_TYPES.contains(type);
        }
    }

    @XmlTransient
    public static final class Person {
        private static final EnumSet<FactType> PERSON_FACT_TYPES = EnumSet.noneOf(FactType.class);
        public static final FactType Adoption = Person.include(Adoption);
        public static final FactType AdultChristening = Person.include(AdultChristening);
        public static final FactType Amnesty = Person.include(Amnesty);
        public static final FactType Apprenticeship = Person.include(Apprenticeship);
        public static final FactType Arrest = Person.include(Arrest);
        public static final FactType Award = Person.include(Award);
        public static final FactType Baptism = Person.include(Baptism);
        public static final FactType BarMitzvah = Person.include(BarMitzvah);
        public static final FactType BatMitzvah = Person.include(BatMitzvah);
        public static final FactType Birth = Person.include(Birth);
        public static final FactType BirthNotice = Person.include(BirthNotice);
        public static final FactType Blessing = Person.include(Blessing);
        public static final FactType Burial = Person.include(Burial);
        public static final FactType Caste = Person.include(Caste);
        public static final FactType Census = Person.include(Census);
        public static final FactType Christening = Person.include(Christening);
        public static final FactType Circumcision = Person.include(Circumcision);
        public static final FactType Clan = Person.include(Clan);
        public static final FactType Branch = Person.include(Branch);
        public static final FactType Confirmation = Person.include(Confirmation);
        public static final FactType Court = Person.include(Court);
        public static final FactType Cremation = Person.include(Cremation);
        public static final FactType Death = Person.include(Death);
        public static final FactType Education = Person.include(Education);
        public static final FactType EducationEnrollment = Person.include(EducationEnrollment);
        public static final FactType Emigration = Person.include(Emigration);
        public static final FactType Ethnicity = Person.include(Ethnicity);
        public static final FactType Excommunication = Person.include(Excommunication);
        public static final FactType FirstCommunion = Person.include(FirstCommunion);
        public static final FactType Funeral = Person.include(Funeral);
        public static final FactType GenderChange = Person.include(GenderChange);
        public static final FactType Graduation = Person.include(Graduation);
        public static final FactType Heimat = Person.include(Heimat);
        public static final FactType Immigration = Person.include(Immigration);
        public static final FactType Imprisonment = Person.include(Imprisonment);
        public static final FactType Inquest = Person.include(Inquest);
        public static final FactType LandTransaction = Person.include(LandTransaction);
        public static final FactType Language = Person.include(Language);
        public static final FactType Living = Person.include(Living);
        public static final FactType MaritalStatus = Person.include(MaritalStatus);
        public static final FactType Medical = Person.include(Medical);
        public static final FactType MilitaryAward = Person.include(MilitaryAward);
        public static final FactType MilitaryDischarge = Person.include(MilitaryDischarge);
        public static final FactType MilitaryDraftRegistration = Person.include(MilitaryDraftRegistration);
        public static final FactType MilitaryInduction = Person.include(MilitaryInduction);
        public static final FactType MilitaryService = Person.include(MilitaryService);
        public static final FactType Mission = Person.include(Mission);
        public static final FactType MoveFrom = Person.include(MoveFrom);
        public static final FactType MoveTo = Person.include(MoveTo);
        public static final FactType MultipleBirth = Person.include(MultipleBirth);
        public static final FactType NationalId = Person.include(NationalId);
        public static final FactType Nationality = Person.include(Nationality);
        public static final FactType Naturalization = Person.include(Naturalization);
        public static final FactType NumberOfChildren = Person.include(NumberOfChildren);
        public static final FactType NumberOfMarriages = Person.include(NumberOfMarriages);
        public static final FactType Obituary = Person.include(Obituary);
        public static final FactType Occupation = Person.include(Occupation);
        public static final FactType Ordination = Person.include(Ordination);
        public static final FactType Pardon = Person.include(Pardon);
        public static final FactType PhysicalDescription = Person.include(PhysicalDescription);
        public static final FactType Probate = Person.include(Probate);
        public static final FactType Property = Person.include(Property);
        public static final FactType Race = Person.include(Race);
        public static final FactType Religion = Person.include(Religion);
        public static final FactType Residence = Person.include(Residence);
        public static final FactType Retirement = Person.include(Retirement);
        public static final FactType Stillbirth = Person.include(Stillbirth);
        public static final FactType TaxAssessment = Person.include(TaxAssessment);
        public static final FactType Tribe = Person.include(Tribe);
        public static final FactType Will = Person.include(Will);
        public static final FactType Visit = Person.include(Visit);
        public static final FactType Yahrzeit = Person.include(Yahrzeit);

        private Person() {
        }

        private static FactType include(FactType type) {
            PERSON_FACT_TYPES.add(type);
            return type;
        }

        public static boolean isApplicable(FactType type) {
            return PERSON_FACT_TYPES.contains(type);
        }
    }
}

