/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import java.util.HashMap;
import java.util.Map;
import org.gedcomx.Gedcomx;
import org.gedcomx.agent.Agent;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.conclusion.Person;
import org.gedcomx.conclusion.PlaceDescription;
import org.gedcomx.conclusion.PlaceReference;
import org.gedcomx.records.RecordDescriptor;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;

public class DocMap {
    private Gedcomx doc;
    private SourceDescription mainSourceDescription;
    private Map<String, SourceDescription> sourceDescriptionMap;
    private Map<String, Person> personMap;
    private Map<String, RecordDescriptor> recordDescriptorMap;
    private Map<String, Agent> agentMap;
    private Map<String, PlaceDescription> placeMap;

    public DocMap(Gedcomx doc) {
        this.update(doc);
    }

    public void update(Gedcomx doc) {
        this.doc = doc;
        this.sourceDescriptionMap = DocMap.getSourceDescriptionMap(doc);
        this.personMap = DocMap.getPersonMap(doc);
        this.recordDescriptorMap = DocMap.getRecordDescriptorMap(doc);
        this.agentMap = DocMap.getAgentMap(doc);
        this.placeMap = DocMap.getPlaceMap(doc);
        this.mainSourceDescription = this.getSourceDescription(doc.getDescriptionRef());
    }

    public Gedcomx getDocument() {
        return this.doc;
    }

    public SourceDescription getMainSourceDescription() {
        return this.mainSourceDescription;
    }

    public Person getMainPerson() {
        return this.mainSourceDescription == null ? null : this.getPerson(this.mainSourceDescription.getAbout());
    }

    public Person getPerson(String idOrUrl) {
        return this.personMap.get(idOrUrl);
    }

    public Person getPerson(URI uri) {
        return uri == null ? null : this.getPerson(uri.toString());
    }

    public Person getPerson(ResourceReference resourceReference) {
        return resourceReference == null ? null : this.getPerson(resourceReference.getResource());
    }

    public SourceDescription getSourceDescription(String idOrUrl) {
        return this.sourceDescriptionMap.get(idOrUrl);
    }

    public SourceDescription getSourceDescription(URI uri) {
        return uri == null ? null : this.getSourceDescription(uri.toString());
    }

    public SourceDescription getSourceDescription(SourceReference sourceReference) {
        return sourceReference == null ? null : this.getSourceDescription(sourceReference.getDescriptionRef());
    }

    public RecordDescriptor getRecordDescriptor(String recordDescriptorIdOrUrl) {
        if (recordDescriptorIdOrUrl == null) {
            return null;
        }
        if (recordDescriptorIdOrUrl.contains("#")) {
            recordDescriptorIdOrUrl = recordDescriptorIdOrUrl.substring(recordDescriptorIdOrUrl.indexOf("#") + 1);
        }
        return this.recordDescriptorMap.get(recordDescriptorIdOrUrl);
    }

    public RecordDescriptor getRecordDescriptor(URI recordDescriptorId) {
        return recordDescriptorId == null ? null : this.getRecordDescriptor(recordDescriptorId.toString());
    }

    public Agent getAgent(String agentId) {
        return this.agentMap.get(agentId);
    }

    public Agent getAgent(URI agentId) {
        return agentId == null ? null : this.getAgent(agentId.toString());
    }

    public PlaceDescription getPlaceDescription(String idOrUri) {
        return idOrUri == null ? null : this.placeMap.get(idOrUri);
    }

    public PlaceDescription getPlaceDescription(URI placeDescriptionUri) {
        return placeDescriptionUri == null ? null : this.getPlaceDescription(placeDescriptionUri.toString());
    }

    public PlaceDescription getPlaceDescription(PlaceReference placeReference) {
        return placeReference == null ? null : this.getPlaceDescription(placeReference.getDescriptionRef());
    }

    public static Map<String, SourceDescription> getSourceDescriptionMap(Gedcomx doc) {
        HashMap<String, SourceDescription> map = new HashMap<String, SourceDescription>();
        if (doc.getSourceDescriptions() != null) {
            for (SourceDescription sourceDescription : doc.getSourceDescriptions()) {
                map.put(sourceDescription.getId(), sourceDescription);
                map.put("#" + sourceDescription.getId(), sourceDescription);
                if (sourceDescription.getIdentifiers() == null) continue;
                for (Identifier identifier : sourceDescription.getIdentifiers()) {
                    if (identifier.getValue() == null) continue;
                    map.put(identifier.getValue().toString(), sourceDescription);
                }
            }
        }
        return map;
    }

    public static Map<String, Person> getPersonMap(Gedcomx doc) {
        HashMap<String, Person> map = new HashMap<String, Person>();
        if (doc.getPersons() != null) {
            for (Person person : doc.getPersons()) {
                if (person.getId() != null) {
                    map.put(person.getId(), person);
                    map.put("#" + person.getId(), person);
                }
                if (person.getIdentifiers() == null) continue;
                for (Identifier identifier : person.getIdentifiers()) {
                    if (identifier.getValue() == null) continue;
                    map.put(identifier.getValue().toString(), person);
                }
            }
        }
        return map;
    }

    public static Map<String, Agent> getAgentMap(Gedcomx doc) {
        HashMap<String, Agent> map = new HashMap<String, Agent>();
        if (doc.getAgents() != null) {
            for (Agent agent : doc.getAgents()) {
                map.put(agent.getId(), agent);
                map.put("#" + agent.getId(), agent);
            }
        }
        return map;
    }

    public static Map<String, RecordDescriptor> getRecordDescriptorMap(Gedcomx doc) {
        HashMap<String, RecordDescriptor> map = new HashMap<String, RecordDescriptor>();
        if (doc.getRecordDescriptors() != null) {
            for (RecordDescriptor recordDescriptor : doc.getRecordDescriptors()) {
                map.put(recordDescriptor.getId(), recordDescriptor);
                map.put("#" + recordDescriptor.getId(), recordDescriptor);
            }
        }
        return map;
    }

    public static Map<String, PlaceDescription> getPlaceMap(Gedcomx doc) {
        HashMap<String, PlaceDescription> map = new HashMap<String, PlaceDescription>();
        if (doc.getPlaces() != null) {
            for (PlaceDescription placeDescription : doc.getPlaces()) {
                map.put(placeDescription.getId(), placeDescription);
                map.put("#" + placeDescription.getId(), placeDescription);
                if (placeDescription.getIdentifiers() == null) continue;
                for (Identifier identifier : placeDescription.getIdentifiers()) {
                    if (identifier.getValue() == null) continue;
                    map.put(identifier.getValue().toString(), placeDescription);
                }
            }
        }
        return map;
    }
}

