/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.gedcomx.Gedcomx;
import org.gedcomx.records.RecordSet;
import org.gedcomx.util.RecordSetIterator;

public class XmlRecordSetIterator
implements RecordSetIterator {
    private static final QName recordName = new QName("http://gedcomx.org/v1/", "record");
    private static final QName metadataName = new QName("http://gedcomx.org/v1/", "metadata");
    private static JAXBContext jaxbContext = null;
    private BufferedReader reader;
    private XMLStreamReader xmlStreamReader;
    private Gedcomx nextRecord;
    private Unmarshaller unmarshaller;
    private Gedcomx metadata;

    public XmlRecordSetIterator(String filename) throws IOException {
        this(new FileInputStream(filename), filename.toLowerCase().endsWith(".gz"));
    }

    public XmlRecordSetIterator(InputStream inputStream, boolean isGzipped) throws IOException {
        this(isGzipped ? new GZIPInputStream(inputStream) : inputStream);
    }

    public XmlRecordSetIterator(InputStream inputStream) throws IOException {
        this(new BufferedReader(new InputStreamReader(inputStream, "UTF-8")));
    }

    public XmlRecordSetIterator(BufferedReader reader) throws IOException {
        try {
            this.reader = reader;
            this.xmlStreamReader = XMLInputFactory.newFactory().createXMLStreamReader(reader);
            this.unmarshaller = jaxbContext.createUnmarshaller();
            this.prepareNext();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized boolean hasNext() {
        return this.nextRecord != null;
    }

    private synchronized void prepareNext() throws XMLStreamException, JAXBException, IOException {
        this.nextRecord = null;
        while (this.xmlStreamReader.hasNext() && this.nextRecord == null) {
            if (this.xmlStreamReader.isStartElement() && this.xmlStreamReader.getName().equals(recordName)) {
                this.nextRecord = (Gedcomx)this.unmarshaller.unmarshal(this.xmlStreamReader, Gedcomx.class).getValue();
                continue;
            }
            if (this.xmlStreamReader.isStartElement() && this.xmlStreamReader.getName().equals(metadataName)) {
                if (this.metadata != null) {
                    throw new IllegalStateException("Cannot have two metadata elements in a RecordSet");
                }
                this.metadata = (Gedcomx)this.unmarshaller.unmarshal(this.xmlStreamReader, Gedcomx.class).getValue();
                continue;
            }
            this.xmlStreamReader.next();
        }
        if (this.nextRecord == null) {
            this.xmlStreamReader.close();
            this.xmlStreamReader = null;
            this.reader.close();
            this.reader = null;
        }
    }

    @Override
    public synchronized Gedcomx next() {
        try {
            if (this.nextRecord == null) {
                return null;
            }
            Gedcomx record = this.nextRecord;
            this.prepareNext();
            return record;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public synchronized Gedcomx getMetadata() {
        return this.metadata;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        try {
            if (this.xmlStreamReader != null) {
                this.xmlStreamReader.close();
                this.xmlStreamReader = null;
            }
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RecordSet.class, Gedcomx.class});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

