/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.webcohesion.enunciate.metadata.Facet;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.URI;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@XmlType(name="EvidenceReference")
@JsonElementWrapper(name="evidence")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class EvidenceReference
extends HypermediaEnabledData
implements Attributable {
    private URI resource;
    private String resourceId;
    private Attribution attribution;

    public EvidenceReference() {
    }

    public EvidenceReference(URI resource) {
        this.resource = resource;
    }

    public EvidenceReference(URI resource, String resourceId) {
        this.resource = resource;
        this.resourceId = resourceId;
    }

    public EvidenceReference(EvidenceReference copy) {
        super(copy);
        this.resource = copy.resource;
        this.resourceId = copy.resourceId;
        this.attribution = copy.attribution == null ? null : new Attribution(copy.attribution);
    }

    @Override
    public EvidenceReference link(Link link) {
        return (EvidenceReference)super.link(link);
    }

    @Override
    public EvidenceReference link(String rel, URI href) {
        return (EvidenceReference)super.link(rel, href);
    }

    @Override
    public EvidenceReference id(String id) {
        return (EvidenceReference)super.id(id);
    }

    @Override
    public EvidenceReference extensionElement(Object element) {
        return (EvidenceReference)super.extensionElement(element);
    }

    @XmlAttribute
    @Facet(value="http://rs.gedcomx.org/")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public EvidenceReference resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @XmlAttribute
    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getResource() {
        return this.resource;
    }

    public void setResource(URI resource) {
        this.resource = resource;
    }

    public EvidenceReference resource(URI resource) {
        this.resource = resource;
        return this;
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public EvidenceReference attribution(Attribution attribution) {
        this.attribution = attribution;
        return this;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitEvidenceReference(this);
    }

    @Override
    public String toString() {
        return this.resource == null ? "" : this.resource.toString();
    }
}

