/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.Facets;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import org.gedcomx.common.URI;
import org.gedcomx.rt.json.JsonElementWrapper;

@XmlRootElement
@XmlType(name="ResourceReference")
@JsonElementWrapper(name="resourceReference")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class ResourceReference {
    private URI resource;
    private String resourceId;

    public ResourceReference() {
    }

    public ResourceReference(URI resource) {
        this.resource = resource;
    }

    public ResourceReference(java.net.URI resource) {
        this.resource = URI.create(resource.toString());
    }

    public ResourceReference(URI resource, String resourceId) {
        this.resource = resource;
        this.resourceId = resourceId;
    }

    public ResourceReference(ResourceReference copy) {
        this.resource = copy.resource;
        this.resourceId = copy.resourceId;
    }

    @XmlAttribute
    @Facets(value={@Facet(value="http://rs.gedcomx.org/"), @Facet(value="https://familysearch.org/tree#READ_ONLY")})
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public ResourceReference resourceId(String resourceId) {
        this.setResourceId(resourceId);
        return this;
    }

    @XmlAttribute
    @XmlSchemaType(name="anyURI", namespace="http://www.w3.org/2001/XMLSchema")
    public URI getResource() {
        return this.resource;
    }

    public void setResource(URI resource) {
        this.resource = resource;
    }

    public ResourceReference resource(URI resource) {
        this.setResource(resource);
        return this;
    }

    public String toString() {
        return this.resource == null ? "" : this.resource.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceReference that = (ResourceReference)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.resourceId, that.resourceId);
    }

    public int hashCode() {
        return Objects.hash(this.resource, this.resourceId);
    }
}

