/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.HasNotes;
import org.gedcomx.common.Note;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Document;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.source.ReferencesSources;
import org.gedcomx.source.SourceDescription;
import org.gedcomx.source.SourceReference;
import org.gedcomx.types.ConfidenceLevel;

@XmlType(name="Conclusion", propOrder={"attribution", "sources", "analysis", "notes"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Conclusion
extends HypermediaEnabledData
implements Attributable,
ReferencesSources,
HasNotes {
    private String lang;
    private URI confidence;
    private List<SourceReference> sources;
    private List<Note> notes;
    private Attribution attribution;
    private ResourceReference analysis;
    private String sortKey;

    protected Conclusion() {
    }

    protected Conclusion(Conclusion copy) {
        super(copy);
        this.lang = copy.lang;
        this.confidence = copy.confidence;
        this.sources = copy.sources == null ? null : new ArrayList<SourceReference>(copy.sources.stream().map(SourceReference::new).toList());
        this.notes = copy.notes == null ? null : new ArrayList<Note>(copy.notes.stream().map(Note::new).toList());
        this.attribution = copy.attribution == null ? null : new Attribution(copy.attribution);
        this.analysis = copy.analysis == null ? null : new ResourceReference(copy.analysis);
        this.sortKey = copy.sortKey;
    }

    @Override
    public Conclusion id(String id) {
        return (Conclusion)super.id(id);
    }

    @Override
    public Conclusion extensionElement(Object element) {
        return (Conclusion)super.extensionElement(element);
    }

    @Override
    public Conclusion link(String rel, URI href) {
        return (Conclusion)super.link(rel, href);
    }

    @Override
    public Conclusion link(Link link) {
        return (Conclusion)super.link(link);
    }

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    @Facet(value="https://familysearch.org/tree#READ_ONLY")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Conclusion lang(String lang) {
        this.lang = lang;
        return this;
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=ConfidenceLevel.class)
    public URI getConfidence() {
        return this.confidence;
    }

    public void setConfidence(URI confidence) {
        this.confidence = confidence;
    }

    public Conclusion confidence(URI confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public Conclusion confidence(ConfidenceLevel confidence) {
        this.setKnownConfidenceLevel(confidence);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public ConfidenceLevel getKnownConfidenceLevel() {
        return this.getConfidence() == null ? null : ConfidenceLevel.fromQNameURI(this.getConfidence());
    }

    @JsonIgnore
    public void setKnownConfidenceLevel(ConfidenceLevel level) {
        this.setConfidence(level == null ? null : level.toQNameURI());
    }

    public Stream<SourceReference> sources() {
        return this.sources == null ? Stream.empty() : this.sources.stream();
    }

    @Override
    @XmlElement(name="source")
    @JsonProperty(value="sources")
    public List<SourceReference> getSources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="sources")
    public void setSources(List<SourceReference> sourceReferences) {
        this.sources = sourceReferences;
    }

    public Conclusion source(SourceReference sourceReference) {
        this.addSource(sourceReference);
        return this;
    }

    public Conclusion source(SourceDescription source) {
        return this.source(new SourceReference().description(source));
    }

    public void addSource(SourceReference source) {
        if (source != null) {
            if (this.sources == null) {
                this.sources = new ArrayList<SourceReference>();
            }
            this.sources.add(source);
        }
    }

    public Stream<Note> notes() {
        return this.notes == null ? Stream.empty() : this.notes.stream();
    }

    @Override
    @XmlElement(name="note")
    @JsonProperty(value="notes")
    public List<Note> getNotes() {
        return this.notes;
    }

    @Override
    @JsonProperty(value="notes")
    public void setNotes(List<Note> notes) {
        this.notes = notes;
    }

    public Conclusion note(Note note) {
        this.addNote(note);
        return this;
    }

    public void addNote(Note note) {
        if (note != null) {
            if (this.notes == null) {
                this.notes = new ArrayList<Note>();
            }
            this.notes.add(note);
        }
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public Conclusion attribution(Attribution attribution) {
        this.setAttribution(attribution);
        return this;
    }

    @Facet(value="https://familysearch.org/tree#UNSUPPORTED")
    public ResourceReference getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(ResourceReference analysis) {
        this.analysis = analysis;
    }

    public Conclusion analysis(ResourceReference analysis) {
        this.setAnalysis(analysis);
        return this;
    }

    public Conclusion analysis(URI analysis) {
        return this.analysis(new ResourceReference(analysis));
    }

    public Conclusion analysis(Document analysis) {
        if (analysis.getId() == null) {
            throw new IllegalArgumentException("Cannot reference analysis: no id.");
        }
        return this.analysis(URI.create("#" + analysis.getId()));
    }

    @XmlAttribute
    @Facet(value="http://rs.gedcomx.org/")
    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public Conclusion sortKey(String sortKey) {
        this.setSortKey(sortKey);
        return this;
    }

    @Override
    public String toString() {
        return this.getId() == null ? "" : this.getId();
    }

    public void embed(Conclusion conclusion) {
        this.lang = this.lang == null ? conclusion.lang : this.lang;
        this.confidence = this.confidence == null ? conclusion.confidence : this.confidence;
        this.attribution = this.attribution == null ? conclusion.attribution : this.attribution;
        this.analysis = this.analysis == null ? conclusion.analysis : this.analysis;
        String string = this.sortKey = this.sortKey == null ? conclusion.sortKey : this.sortKey;
        if (conclusion.notes != null) {
            this.notes = this.notes == null ? new ArrayList() : this.notes;
            this.notes.addAll(conclusion.notes);
        }
        if (conclusion.sources != null) {
            this.sources = this.sources == null ? new ArrayList() : this.sources;
            this.sources.addAll(conclusion.sources);
        }
        super.embed(conclusion);
    }
}

