/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.conclusion;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.gedcomx.common.ExtensibleData;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.PlaceDescription;
import org.gedcomx.records.Field;
import org.gedcomx.records.HasFields;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.RDFRange;
import org.gedcomx.types.ConfidenceLevel;

@XmlType(name="PlaceReference", propOrder={"original", "normalizedExtensions", "fields"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PlaceReference
extends ExtensibleData
implements HasFields {
    private String original;
    private URI descriptionRef;
    private URI confidence;
    private List<Field> fields;
    private List<TextValue> normalized;

    public PlaceReference() {
    }

    public PlaceReference(PlaceReference copy) {
        super(copy);
        this.original = copy.original;
        this.descriptionRef = copy.descriptionRef;
        this.confidence = copy.confidence;
        this.fields = copy.fields == null ? null : new ArrayList<Field>(copy.fields.stream().map(Field::new).toList());
        this.normalized = copy.normalized == null ? null : new ArrayList<TextValue>(copy.normalized.stream().map(TextValue::new).toList());
    }

    public String getOriginal() {
        return this.original;
    }

    public void setOriginal(String original) {
        this.original = original;
    }

    public PlaceReference original(String original) {
        this.setOriginal(original);
        return this;
    }

    @XmlAttribute(name="description")
    @JsonProperty(value="description")
    @RDFRange(value={PlaceDescription.class})
    public URI getDescriptionRef() {
        return this.descriptionRef;
    }

    @JsonProperty(value="description")
    public void setDescriptionRef(URI descriptionRef) {
        this.descriptionRef = descriptionRef;
    }

    public PlaceReference description(PlaceDescription description) {
        this.setDescriptionRef(URI.create("#" + description.getId()));
        return this;
    }

    public PlaceReference description(URI ref) {
        this.setDescriptionRef(ref);
        return this;
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=ConfidenceLevel.class)
    public URI getConfidence() {
        return this.confidence;
    }

    public void setConfidence(URI confidence) {
        this.confidence = confidence;
    }

    public PlaceReference confidence(URI confidence) {
        this.setConfidence(confidence);
        return this;
    }

    public PlaceReference confidence(ConfidenceLevel confidence) {
        this.setKnownConfidenceLevel(confidence);
        return this;
    }

    @XmlTransient
    @JsonIgnore
    public ConfidenceLevel getKnownConfidenceLevel() {
        return this.getConfidence() == null ? null : ConfidenceLevel.fromQNameURI(this.getConfidence());
    }

    @JsonIgnore
    public void setKnownConfidenceLevel(ConfidenceLevel level) {
        this.setConfidence(level == null ? null : level.toQNameURI());
    }

    public Stream<TextValue> normalizedExtensions() {
        return this.normalized == null ? Stream.empty() : this.normalized.stream();
    }

    @XmlElement(name="normalized")
    @JsonProperty(value="normalized")
    @Facet(value="http://rs.gedcomx.org/")
    public List<TextValue> getNormalizedExtensions() {
        return this.normalized;
    }

    @JsonProperty(value="normalized")
    public void setNormalizedExtensions(List<TextValue> normalized) {
        this.normalized = normalized;
    }

    public void addNormalizedExtension(TextValue normalized) {
        if (normalized != null) {
            if (this.normalized == null) {
                this.normalized = new LinkedList<TextValue>();
            }
            this.normalized.add(normalized);
        }
    }

    public PlaceReference normalized(String normalized) {
        this.addNormalizedExtension(new TextValue(normalized));
        return this;
    }

    @Override
    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @Facet(value="http://record.gedcomx.org/")
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty(value="fields")
    public void setFields(List<Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<Field>();
            }
            this.fields.add(field);
        }
    }

    public PlaceReference field(Field field) {
        this.addField(field);
        return this;
    }

    @Override
    public String toString() {
        return "PlaceReference{original='" + this.original + "', descriptionRef='" + this.descriptionRef + "'}";
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitPlaceReference(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlaceReference that = (PlaceReference)o;
        return Objects.equals(this.confidence, that.confidence) && Objects.equals(this.descriptionRef, that.descriptionRef) && Objects.equals(this.fields, that.fields) && Objects.equals(this.normalized, that.normalized) && Objects.equals(this.original, that.original);
    }

    public int hashCode() {
        return Objects.hash(this.confidence, this.descriptionRef, this.fields, this.normalized, this.original);
    }
}

