/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.rs.TypeHint;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.gedcomx.common.Attributable;
import org.gedcomx.common.Attribution;
import org.gedcomx.common.URI;
import org.gedcomx.conclusion.Identifier;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.records.CollectionContent;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.rt.json.JsonElementWrapper;
import org.gedcomx.util.JsonIdentifiers;

@XmlRootElement
@JsonElementWrapper(name="collections")
@XmlType(name="Collection", propOrder={"identifiers", "title", "size", "content", "attribution"})
@Facet(value="http://record.gedcomx.org/")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Collection
extends HypermediaEnabledData
implements Attributable {
    private String lang;
    private List<Identifier> identifiers;
    private List<CollectionContent> content;
    private String title;
    private Integer size;
    private Attribution attribution;

    public Collection() {
    }

    public Collection(Collection copy) {
        super(copy);
        this.lang = copy.lang;
        this.identifiers = copy.identifiers == null ? null : new ArrayList<Identifier>(copy.identifiers.stream().map(Identifier::new).toList());
        this.content = copy.content == null ? null : new ArrayList<CollectionContent>(copy.content.stream().map(CollectionContent::new).toList());
        this.title = copy.title;
        this.size = copy.size;
        this.attribution = copy.attribution == null ? null : new Attribution(copy.attribution);
    }

    @Override
    public Collection id(String id) {
        return (Collection)super.id(id);
    }

    @Override
    public Collection extensionElement(Object element) {
        return (Collection)super.extensionElement(element);
    }

    @Override
    public Collection link(Link link) {
        return (Collection)super.link(link);
    }

    @Override
    public Collection link(String rel, URI href) {
        return (Collection)super.link(rel, href);
    }

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Collection lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Collection title(String title) {
        this.setTitle(title);
        return this;
    }

    public Stream<Identifier> identifiers() {
        return this.identifiers == null ? Stream.empty() : this.identifiers.stream();
    }

    @XmlElement(name="identifier")
    @JsonProperty(value="identifiers")
    @TypeHint(value=JsonIdentifiers.class)
    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    public Collection identifier(Identifier identifier) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifier);
        return this;
    }

    public List<CollectionContent> getContent() {
        return this.content;
    }

    public void setContent(List<CollectionContent> content) {
        this.content = content;
    }

    public Collection content(CollectionContent content) {
        this.addContent(content);
        return this;
    }

    public void addContent(CollectionContent content) {
        if (content != null) {
            if (this.content == null) {
                this.content = new LinkedList<CollectionContent>();
            }
            this.content.add(content);
        }
    }

    @Override
    public Attribution getAttribution() {
        return this.attribution;
    }

    @Override
    public void setAttribution(Attribution attribution) {
        this.attribution = attribution;
    }

    public Collection attribution(Attribution attribution) {
        this.setAttribution(attribution);
        return this;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Collection size(Integer size) {
        this.setSize(size);
        return this;
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitCollection(this);
    }

    public void embed(Collection collection) {
        this.lang = this.lang == null ? collection.lang : this.lang;
        this.title = this.title == null ? collection.title : this.title;
        this.size = this.size == null ? collection.size : this.size;
        this.attribution = this.attribution == null ? collection.attribution : this.attribution;
        Attribution attribution = this.attribution = this.attribution == null ? collection.attribution : this.attribution;
        if (collection.content != null) {
            this.content = this.content == null ? new ArrayList() : this.content;
            this.content.addAll(collection.content);
        }
        super.embed(collection);
    }
}

