/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.records.FieldValueDescriptor;

@XmlType(name="FieldDescriptor", propOrder={"originalLabel", "descriptions", "values"})
@Facet(value="http://record.gedcomx.org/")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FieldDescriptor
extends HypermediaEnabledData {
    private String originalLabel;
    private List<TextValue> descriptions;
    private List<FieldValueDescriptor> values;

    public FieldDescriptor() {
    }

    public FieldDescriptor(FieldDescriptor copy) {
        super(copy);
        this.originalLabel = copy.originalLabel;
        this.descriptions = copy.descriptions == null ? null : new ArrayList<TextValue>(copy.descriptions.stream().map(TextValue::new).toList());
        this.values = copy.values == null ? null : new ArrayList<FieldValueDescriptor>(copy.values.stream().map(FieldValueDescriptor::new).toList());
    }

    @Override
    public FieldDescriptor id(String id) {
        return (FieldDescriptor)super.id(id);
    }

    @Override
    public FieldDescriptor extensionElement(Object element) {
        return (FieldDescriptor)super.extensionElement(element);
    }

    @Override
    public FieldDescriptor link(Link link) {
        return (FieldDescriptor)super.link(link);
    }

    @Override
    public FieldDescriptor link(String rel, URI href) {
        return (FieldDescriptor)super.link(rel, href);
    }

    public String getOriginalLabel() {
        return this.originalLabel;
    }

    public void setOriginalLabel(String originalLabel) {
        this.originalLabel = originalLabel;
    }

    public FieldDescriptor originalLabel(String originalLabel) {
        this.setOriginalLabel(originalLabel);
        return this;
    }

    public Stream<TextValue> descriptions() {
        return this.descriptions == null ? Stream.empty() : this.descriptions.stream();
    }

    @XmlElement(name="description")
    @JsonProperty(value="descriptions")
    public List<TextValue> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<TextValue> descriptions) {
        this.descriptions = descriptions;
    }

    public FieldDescriptor description(TextValue description) {
        this.addDescription(description);
        return this;
    }

    public FieldDescriptor description(String description) {
        this.addDescription(new TextValue(description));
        return this;
    }

    public void addDescription(TextValue description) {
        if (description != null) {
            if (this.descriptions == null) {
                this.descriptions = new LinkedList<TextValue>();
            }
            this.descriptions.add(description);
        }
    }

    public Stream<FieldValueDescriptor> values() {
        return this.values == null ? Stream.empty() : this.values.stream();
    }

    @XmlElement(name="value")
    @JsonProperty(value="values")
    public List<FieldValueDescriptor> getValues() {
        return this.values;
    }

    @JsonProperty(value="values")
    public void setValues(List<FieldValueDescriptor> values) {
        this.values = values;
    }
}

