/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.records;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import com.webcohesion.enunciate.metadata.qname.XmlQNameEnumRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import org.gedcomx.common.TextValue;
import org.gedcomx.common.URI;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.types.FieldValueType;

@XmlType(name="FieldValueDescriptor")
@Facet(value="http://record.gedcomx.org/")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FieldValueDescriptor
extends HypermediaEnabledData {
    private String labelId;
    private URI type;
    private Boolean optional;
    private List<TextValue> displayLabels;
    private List<TextValue> entryLabels;
    private String displaySortKey;
    private String entrySortKey;
    private Boolean entryRequired;
    private Boolean editable;
    private String parentLabelId;

    public FieldValueDescriptor() {
    }

    public FieldValueDescriptor(FieldValueDescriptor copy) {
        super(copy);
        this.labelId = copy.labelId;
        this.type = copy.type;
        this.optional = copy.optional;
        this.displayLabels = copy.displayLabels == null ? null : new ArrayList<TextValue>(copy.displayLabels.stream().map(TextValue::new).toList());
        this.entryLabels = copy.entryLabels == null ? null : new ArrayList<TextValue>(copy.entryLabels.stream().map(TextValue::new).toList());
        this.displaySortKey = copy.displaySortKey;
        this.entrySortKey = copy.entrySortKey;
        this.entryRequired = copy.entryRequired;
        this.editable = copy.editable;
        this.parentLabelId = copy.parentLabelId;
    }

    @XmlAttribute
    public String getLabelId() {
        return this.labelId;
    }

    public void setLabelId(String labelId) {
        this.labelId = labelId;
    }

    @XmlAttribute
    @XmlQNameEnumRef(value=FieldValueType.class)
    public URI getType() {
        return this.type;
    }

    public void setType(URI type) {
        this.type = type;
    }

    @XmlTransient
    @JsonIgnore
    public FieldValueType getKnownType() {
        return this.getType() == null ? null : FieldValueType.fromQNameURI(this.getType());
    }

    @JsonIgnore
    public void setKnownType(FieldValueType type) {
        this.setType(type == null ? null : type.toQNameURI());
    }

    @XmlAttribute
    public Boolean getOptional() {
        return this.optional;
    }

    public void setOptional(Boolean optional) {
        this.optional = optional;
    }

    @XmlElement(name="label")
    @JsonProperty(value="labels")
    public List<TextValue> getDisplayLabels() {
        return this.displayLabels;
    }

    @JsonProperty(value="labels")
    public void setDisplayLabels(List<TextValue> displayLabels) {
        this.displayLabels = displayLabels;
    }

    @XmlElement(name="entryLabel")
    @JsonProperty(value="entryLabels")
    public List<TextValue> getEntryLabels() {
        return this.entryLabels;
    }

    @JsonProperty(value="entryLabels")
    public void setEntryLabels(List<TextValue> entryLabels) {
        this.entryLabels = entryLabels;
    }

    public String getDisplaySortKey() {
        return this.displaySortKey;
    }

    public void setDisplaySortKey(String displaySortKey) {
        this.displaySortKey = displaySortKey;
    }

    public String getEntrySortKey() {
        return this.entrySortKey;
    }

    public void setEntrySortKey(String entrySortKey) {
        this.entrySortKey = entrySortKey;
    }

    public Boolean getEntryRequired() {
        return this.entryRequired;
    }

    public void setEntryRequired(Boolean entryRequired) {
        this.entryRequired = entryRequired;
    }

    @XmlAttribute
    public Boolean getEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    public String getParentLabelId() {
        return this.parentLabelId;
    }

    public void setParentLabelId(String parentLabelId) {
        this.parentLabelId = parentLabelId;
    }
}

