/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.source;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.webcohesion.enunciate.metadata.Facet;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.gedcomx.common.ResourceReference;
import org.gedcomx.common.URI;
import org.gedcomx.links.HypermediaEnabledData;
import org.gedcomx.links.Link;
import org.gedcomx.rt.GedcomxModelVisitor;
import org.gedcomx.source.CitationField;

@XmlType(name="SourceCitation")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SourceCitation
extends HypermediaEnabledData {
    private String lang;
    private String value;
    private ResourceReference citationTemplate;
    private List<CitationField> fields;

    public SourceCitation() {
    }

    public SourceCitation(SourceCitation copy) {
        super(copy);
        this.lang = copy.lang;
        this.value = copy.value;
        this.citationTemplate = copy.citationTemplate == null ? null : new ResourceReference(copy.citationTemplate);
        this.fields = copy.fields == null ? null : new ArrayList<CitationField>(copy.fields.stream().map(CitationField::new).toList());
    }

    @Override
    public SourceCitation id(String id) {
        return (SourceCitation)super.id(id);
    }

    @Override
    public SourceCitation extensionElement(Object element) {
        return (SourceCitation)super.extensionElement(element);
    }

    @Override
    public SourceCitation link(Link link) {
        return (SourceCitation)super.link(link);
    }

    @Override
    public SourceCitation link(String rel, URI href) {
        return (SourceCitation)super.link(rel, href);
    }

    @XmlAttribute(namespace="http://www.w3.org/XML/1998/namespace")
    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public SourceCitation lang(String lang) {
        this.setLang(lang);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SourceCitation value(String value) {
        this.setValue(value);
        return this;
    }

    @Facet(value="http://citation.gedcomx.org/")
    public ResourceReference getCitationTemplate() {
        return this.citationTemplate;
    }

    public void setCitationTemplate(ResourceReference citationTemplate) {
        this.citationTemplate = citationTemplate;
    }

    public SourceCitation citationTemplate(ResourceReference citationTemplate) {
        this.setCitationTemplate(citationTemplate);
        return this;
    }

    @XmlElement(name="field")
    @JsonProperty(value="fields")
    @Facet(value="http://citation.gedcomx.org/")
    public List<CitationField> getFields() {
        return this.fields;
    }

    @JsonProperty(value="fields")
    public void setFields(List<CitationField> fields) {
        this.fields = fields;
    }

    public SourceCitation field(CitationField fields) {
        this.addField(fields);
        return this;
    }

    public void addField(CitationField field) {
        if (field != null) {
            if (this.fields == null) {
                this.fields = new LinkedList<CitationField>();
            }
            this.fields.add(field);
        }
    }

    public void accept(GedcomxModelVisitor visitor) {
        visitor.visitSourceCitation(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceCitation that = (SourceCitation)o;
        return Objects.equals(this.citationTemplate, that.citationTemplate) && Objects.equals(this.fields, that.fields) && Objects.equals(this.lang, that.lang) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.citationTemplate, this.fields, this.lang, this.value);
    }
}

