/*
 * Decompiled with CFR 0.152.
 */
package org.gedcomx.util;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gedcomx.common.TextValue;

public class LocaleUtil {
    private static final Pattern bcp47 = Pattern.compile("([A-Za-z]{2,3}(?:-[A-Za-z]{3}(?:-[A-Za-z]{3}){0,2})?|[A-Za-z]{4,8})(?:[-_]([A-Za-z]{4}))?(?:[-_]([A-Za-z]{2}|[0-9]{3}))?(?:[-_]([A-Za-z0-9]{5,8}|[0-9][A-Za-z0-9]{3}))*(?:[-_](?:[0-9A-WY-Za-wy-z](-[A-Za-z0-9]{2,8})+))*(?:[-_](?:x(-[A-Za-z0-9]{1,8})+))?");

    public static TextValue findClosestLocale(Collection<TextValue> textValues, Locale localeToMatch) {
        return LocaleUtil.findClosestLocale(textValues, localeToMatch, Locale.ENGLISH);
    }

    public static TextValue findClosestLocale(Collection<TextValue> textValues, Locale localeToMatch, Locale defaultLocale) {
        if (textValues != null) {
            TextValue bestTextValue = null;
            Locale bestLocale = null;
            for (TextValue textValue : textValues) {
                Locale locale = LocaleUtil.getSimpleLocale(textValue.getLang());
                if (bestTextValue != null && !LocaleUtil.isBetterLocaleMatch(localeToMatch, locale, bestLocale, defaultLocale)) continue;
                bestTextValue = textValue;
                bestLocale = locale;
            }
            return bestTextValue;
        }
        return null;
    }

    public static Locale findClosestLocale(Set<Locale> locales, Locale localeToMatch) {
        return LocaleUtil.findClosestLocale(locales, localeToMatch, Locale.ENGLISH);
    }

    public static Locale findClosestLocale(Set<Locale> locales, Locale localeToMatch, Locale defaultLocale) {
        if (locales == null) {
            return null;
        }
        if (defaultLocale == null) {
            defaultLocale = Locale.getDefault();
        }
        if (localeToMatch == null) {
            localeToMatch = defaultLocale;
        }
        Locale currentBest = null;
        for (Locale locale : locales) {
            if (locale.equals(localeToMatch)) {
                return locale;
            }
            if (!LocaleUtil.isBetterLocaleMatch(localeToMatch, locale, currentBest, defaultLocale)) continue;
            currentBest = locale;
        }
        return currentBest;
    }

    private static boolean isBetterLocaleMatch(Locale preferredLocale, Locale currentLocale, Locale bestLocale, Locale defaultLocale) {
        int bestMatch;
        if (bestLocale == null) {
            return true;
        }
        int currentMatch = LocaleUtil.matchCount(preferredLocale, currentLocale);
        if (currentMatch > (bestMatch = LocaleUtil.matchCount(preferredLocale, bestLocale))) {
            return true;
        }
        return bestMatch == 0 && !defaultLocale.equals(preferredLocale) && LocaleUtil.matchCount(defaultLocale, currentLocale) > LocaleUtil.matchCount(defaultLocale, bestLocale);
    }

    private static int matchCount(Locale locale1, Locale locale2) {
        String l2;
        int value = 0;
        String l1 = locale1.getLanguage();
        if (l1.equals(l2 = locale2.getLanguage())) {
            String c2;
            value += 10;
            String c1 = locale1.getCountry();
            if (c1.equals(c2 = locale2.getCountry())) {
                String v2;
                value += 10;
                String v1 = locale1.getVariant();
                if (v1.equals(v2 = locale2.getVariant())) {
                    value += 10;
                } else if (v1.equals("") || v2.equals("")) {
                    ++value;
                }
            } else if (c1.equals("") || c2.equals("")) {
                ++value;
            }
        }
        return value;
    }

    public static Locale getSimpleLocale(String languageString) {
        Matcher m = bcp47.matcher(languageString);
        if (m.matches()) {
            String language = m.group(1);
            String script = m.group(2);
            String region = m.group(3);
            String variant = m.group(4);
            if (region != null) {
                if (variant != null) {
                    return new Locale(language, region, variant);
                }
                return new Locale(language, region);
            }
            return new Locale(language);
        }
        throw new IllegalArgumentException();
    }
}

