package org.genesys.amphibian.client.api;

import org.genesys.amphibian.client.invoker.ApiClient;
import org.genesys.amphibian.client.model.DatasetTable;
import org.genesys.amphibian.client.model.HeatMapData;
import org.genesys.amphibian.client.model.IngestColumnRequest;
import org.genesys.amphibian.client.model.ObservationHistogram;
import org.genesys.amphibian.client.model.ObservationRegistration;
import org.genesys.amphibian.client.model.ResponsePage;
import org.genesys.amphibian.client.model.TraitDataFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
@Component("org.genesys.amphibian.client.api.DatasetsApi")
public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(new ApiClient());
    }

    @Autowired
    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param observationRegistration  (required)
     * @return ObservationRegistration
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ObservationRegistration addObservations(String tableKey, ObservationRegistration observationRegistration) throws RestClientException {
        return addObservationsWithHttpInfo(tableKey, observationRegistration).getBody();
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param observationRegistration  (required)
     * @return ResponseEntity&lt;ObservationRegistration&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ObservationRegistration> addObservationsWithHttpInfo(String tableKey, ObservationRegistration observationRegistration) throws RestClientException {
        Object localVarPostBody = observationRegistration;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling addObservations");
        }
        
        // verify the required parameter 'observationRegistration' is set
        if (observationRegistration == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'observationRegistration' when calling addObservations");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ObservationRegistration> localReturnType = new ParameterizedTypeReference<ObservationRegistration>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/add", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable createTable(DatasetTable datasetTable) throws RestClientException {
        return createTableWithHttpInfo(datasetTable).getBody();
    }

    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> createTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        Object localVarPostBody = datasetTable;
        
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling createTable");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/create", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable dropTable(DatasetTable datasetTable) throws RestClientException {
        return dropTableWithHttpInfo(datasetTable).getBody();
    }

    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> dropTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        Object localVarPostBody = datasetTable;
        
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling dropTable");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/drop", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * ...
     * Get dataset information
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable getDataset(String tableKey) throws RestClientException {
        return getDatasetWithHttpInfo(tableKey).getBody();
    }

    /**
     * ...
     * Get dataset information
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> getDatasetWithHttpInfo(String tableKey) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Calculate a heat map of observations for two selected categorical descriptors in DatasetTable
     * Get HeatMap of observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param xCategory X category field UUID (required)
     * @param yCategory Y category field UUID (required)
     * @param traitDataFilter  (optional)
     * @return HeatMapData
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public HeatMapData getHeatMapData(String tableKey, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws RestClientException {
        return getHeatMapDataWithHttpInfo(tableKey, xCategory, yCategory, traitDataFilter).getBody();
    }

    /**
     * Calculate a heat map of observations for two selected categorical descriptors in DatasetTable
     * Get HeatMap of observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param xCategory X category field UUID (required)
     * @param yCategory Y category field UUID (required)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;HeatMapData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<HeatMapData> getHeatMapDataWithHttpInfo(String tableKey, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getHeatMapData");
        }
        
        // verify the required parameter 'xCategory' is set
        if (xCategory == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xCategory' when calling getHeatMapData");
        }
        
        // verify the required parameter 'yCategory' is set
        if (yCategory == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'yCategory' when calling getHeatMapData");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "xCategory", xCategory));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "yCategory", yCategory));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<HeatMapData> localReturnType = new ParameterizedTypeReference<HeatMapData>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/heatmap", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param p Page number (optional, default to 0)
     * @param l Page size (length). (optional)
     * @param fields Specify fields to return (optional)
     * @param traitDataFilter  (optional)
     * @return ResponsePage
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponsePage getObservations(String tableKey, Integer p, Integer l, List<UUID> fields, TraitDataFilter traitDataFilter) throws RestClientException {
        return getObservationsWithHttpInfo(tableKey, p, l, fields, traitDataFilter).getBody();
    }

    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param p Page number (optional, default to 0)
     * @param l Page size (length). (optional)
     * @param fields Specify fields to return (optional)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;ResponsePage&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ResponsePage> getObservationsWithHttpInfo(String tableKey, Integer p, Integer l, List<UUID> fields, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getObservations");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ResponsePage> localReturnType = new ParameterizedTypeReference<ResponsePage>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/get", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get histogram of numerical observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param p Page number (optional, default to 0)
     * @param l Page size (length). (optional)
     * @param fields Specify fields to return (optional)
     * @param bins Number of bins (optional, default to 4)
     * @param traitDataFilter  (optional)
     * @return List&lt;ObservationHistogram&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ObservationHistogram> getObservationsHistogram(String tableKey, Integer p, Integer l, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws RestClientException {
        return getObservationsHistogramWithHttpInfo(tableKey, p, l, fields, bins, traitDataFilter).getBody();
    }

    /**
     * Get histogram of numerical observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param p Page number (optional, default to 0)
     * @param l Page size (length). (optional)
     * @param fields Specify fields to return (optional)
     * @param bins Number of bins (optional, default to 4)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;List&lt;ObservationHistogram&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ObservationHistogram>> getObservationsHistogramWithHttpInfo(String tableKey, Integer p, Integer l, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getObservationsHistogram");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "bins", bins));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<List<ObservationHistogram>> localReturnType = new ParameterizedTypeReference<List<ObservationHistogram>>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/histogram", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param descriptorUuid Descriptor UUID (required)
     * @param previewUuid Preview UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row in the Preview (required)
     * @param ingestColumnRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> ingestFromPreview(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws RestClientException {
        return ingestFromPreviewWithHttpInfo(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).getBody();
    }

    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param descriptorUuid Descriptor UUID (required)
     * @param previewUuid Preview UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row in the Preview (required)
     * @param ingestColumnRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> ingestFromPreviewWithHttpInfo(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws RestClientException {
        Object localVarPostBody = ingestColumnRequest;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'descriptorUuid' is set
        if (descriptorUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'descriptorUuid' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'previewUuid' is set
        if (previewUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'previewUuid' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'ingestColumnRequest' is set
        if (ingestColumnRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ingestColumnRequest' when calling ingestFromPreview");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "previewUuid", previewUuid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sheet", sheet));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/ingest", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable updateTable(DatasetTable datasetTable) throws RestClientException {
        return updateTableWithHttpInfo(datasetTable).getBody();
    }

    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> updateTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        Object localVarPostBody = datasetTable;
        
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling updateTable");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/update", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
