/*
 * Amphibian API
 * This is the description of the Amphibian APIs
 *
 * The version of the OpenAPI document: 3.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.amphibian.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.genesys.amphibian.client.model.DataSource;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * DatasetTableExtras
 */
@JsonPropertyOrder({
  DatasetTableExtras.JSON_PROPERTY_STATE,
  DatasetTableExtras.JSON_PROPERTY_SOURCES,
  DatasetTableExtras.JSON_PROPERTY_DESCRIPTOR_SOURCES
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DatasetTableExtras {
  /**
   * Gets or Sets state
   */
  public enum StateEnum {
    DRAFT("DRAFT"),
    
    READY("READY"),
    
    BUSY("BUSY");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_SOURCES = "sources";
  private Map<String, Map<String, DataSource>> sources = null;

  public static final String JSON_PROPERTY_DESCRIPTOR_SOURCES = "descriptorSources";
  private Map<String, Set<UUID>> descriptorSources = null;

  public DatasetTableExtras() {
  }

  public DatasetTableExtras state(StateEnum state) {
    
    this.state = state;
    return this;
  }

   /**
   * Get state
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }


  public DatasetTableExtras sources(Map<String, Map<String, DataSource>> sources) {
    
    this.sources = sources;
    return this;
  }

  public DatasetTableExtras putSourcesItem(String key, Map<String, DataSource> sourcesItem) {
    if (this.sources == null) {
      this.sources = new HashMap<>();
    }
    this.sources.put(key, sourcesItem);
    return this;
  }

   /**
   * Get sources
   * @return sources
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Map<String, DataSource>> getSources() {
    return sources;
  }


  @JsonProperty(JSON_PROPERTY_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSources(Map<String, Map<String, DataSource>> sources) {
    this.sources = sources;
  }


  public DatasetTableExtras descriptorSources(Map<String, Set<UUID>> descriptorSources) {
    
    this.descriptorSources = descriptorSources;
    return this;
  }

  public DatasetTableExtras putDescriptorSourcesItem(String key, Set<UUID> descriptorSourcesItem) {
    if (this.descriptorSources == null) {
      this.descriptorSources = new HashMap<>();
    }
    this.descriptorSources.put(key, descriptorSourcesItem);
    return this;
  }

   /**
   * Get descriptorSources
   * @return descriptorSources
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_DESCRIPTOR_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, Set<UUID>> getDescriptorSources() {
    return descriptorSources;
  }


  @JsonProperty(JSON_PROPERTY_DESCRIPTOR_SOURCES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDescriptorSources(Map<String, Set<UUID>> descriptorSources) {
    this.descriptorSources = descriptorSources;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DatasetTableExtras datasetTableExtras = (DatasetTableExtras) o;
    return Objects.equals(this.state, datasetTableExtras.state) &&
        Objects.equals(this.sources, datasetTableExtras.sources) &&
        Objects.equals(this.descriptorSources, datasetTableExtras.descriptorSources);
  }

  @Override
  public int hashCode() {
    return Objects.hash(state, sources, descriptorSources);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DatasetTableExtras {\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("    descriptorSources: ").append(toIndentedString(descriptorSources)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

