/*
 * Amphibian API
 * This is the description of the Amphibian APIs
 *
 * The version of the OpenAPI document: 3.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.genesys.amphibian.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.genesys.amphibian.client.model.FieldFilter;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Data filters
 */
@ApiModel(description = "Data filters")
@JsonPropertyOrder({
  TraitDataFilter.JSON_PROPERTY_ACCESSION,
  TraitDataFilter.JSON_PROPERTY_OBSERVATIONS
})
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class TraitDataFilter {
  public static final String JSON_PROPERTY_ACCESSION = "accession";
  private Set<UUID> accession = null;

  public static final String JSON_PROPERTY_OBSERVATIONS = "observations";
  private Map<String, FieldFilter> observations = null;

  public TraitDataFilter() {
  }

  public TraitDataFilter accession(Set<UUID> accession) {
    
    this.accession = accession;
    return this;
  }

  public TraitDataFilter addAccessionItem(UUID accessionItem) {
    if (this.accession == null) {
      this.accession = new LinkedHashSet<>();
    }
    this.accession.add(accessionItem);
    return this;
  }

   /**
   * Get accession
   * @return accession
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_ACCESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Set<UUID> getAccession() {
    return accession;
  }


  @JsonDeserialize(as = LinkedHashSet.class)
  @JsonProperty(JSON_PROPERTY_ACCESSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAccession(Set<UUID> accession) {
    this.accession = accession;
  }


  public TraitDataFilter observations(Map<String, FieldFilter> observations) {
    
    this.observations = observations;
    return this;
  }

  public TraitDataFilter putObservationsItem(String key, FieldFilter observationsItem) {
    if (this.observations == null) {
      this.observations = new HashMap<>();
    }
    this.observations.put(key, observationsItem);
    return this;
  }

   /**
   * Get observations
   * @return observations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")
  @JsonProperty(JSON_PROPERTY_OBSERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Map<String, FieldFilter> getObservations() {
    return observations;
  }


  @JsonProperty(JSON_PROPERTY_OBSERVATIONS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setObservations(Map<String, FieldFilter> observations) {
    this.observations = observations;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TraitDataFilter traitDataFilter = (TraitDataFilter) o;
    return Objects.equals(this.accession, traitDataFilter.accession) &&
        Objects.equals(this.observations, traitDataFilter.observations);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accession, observations);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TraitDataFilter {\n");
    sb.append("    accession: ").append(toIndentedString(accession)).append("\n");
    sb.append("    observations: ").append(toIndentedString(observations)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

