/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.genesys.amphibian.client.invoker.ApiClient;
import org.genesys.amphibian.client.model.DatasetTable;
import org.genesys.amphibian.client.model.HeatMapData;
import org.genesys.amphibian.client.model.IngestColumnRequest;
import org.genesys.amphibian.client.model.ObservationHistogram;
import org.genesys.amphibian.client.model.ObservationRegistration;
import org.genesys.amphibian.client.model.ResponsePage;
import org.genesys.amphibian.client.model.TraitDataFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.genesys.amphibian.client.api.DatasetsApi")
public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(new ApiClient());
    }

    @Autowired
    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ObservationRegistration addObservations(String tableKey, ObservationRegistration observationRegistration) throws RestClientException {
        return (ObservationRegistration)this.addObservationsWithHttpInfo(tableKey, observationRegistration).getBody();
    }

    public ResponseEntity<ObservationRegistration> addObservationsWithHttpInfo(String tableKey, ObservationRegistration observationRegistration) throws RestClientException {
        ObservationRegistration localVarPostBody = observationRegistration;
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling addObservations");
        }
        if (observationRegistration == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'observationRegistration' when calling addObservations");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ObservationRegistration> localReturnType = new ParameterizedTypeReference<ObservationRegistration>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/add", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public DatasetTable createTable(DatasetTable datasetTable) throws RestClientException {
        return (DatasetTable)this.createTableWithHttpInfo(datasetTable).getBody();
    }

    public ResponseEntity<DatasetTable> createTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        DatasetTable localVarPostBody = datasetTable;
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling createTable");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/create", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public DatasetTable dropTable(DatasetTable datasetTable) throws RestClientException {
        return (DatasetTable)this.dropTableWithHttpInfo(datasetTable).getBody();
    }

    public ResponseEntity<DatasetTable> dropTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        DatasetTable localVarPostBody = datasetTable;
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling dropTable");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/drop", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public DatasetTable getDataset(String tableKey) throws RestClientException {
        return (DatasetTable)this.getDatasetWithHttpInfo(tableKey).getBody();
    }

    public ResponseEntity<DatasetTable> getDatasetWithHttpInfo(String tableKey) throws RestClientException {
        Object localVarPostBody = null;
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getDataset");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public HeatMapData getHeatMapData(String tableKey, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws RestClientException {
        return (HeatMapData)this.getHeatMapDataWithHttpInfo(tableKey, xCategory, yCategory, traitDataFilter).getBody();
    }

    public ResponseEntity<HeatMapData> getHeatMapDataWithHttpInfo(String tableKey, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws RestClientException {
        TraitDataFilter localVarPostBody = traitDataFilter;
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getHeatMapData");
        }
        if (xCategory == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xCategory' when calling getHeatMapData");
        }
        if (yCategory == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'yCategory' when calling getHeatMapData");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "xCategory", xCategory));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "yCategory", yCategory));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<HeatMapData> localReturnType = new ParameterizedTypeReference<HeatMapData>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/heatmap", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public ResponsePage getObservations(String tableKey, Integer p, Integer l, List<UUID> fields, TraitDataFilter traitDataFilter) throws RestClientException {
        return (ResponsePage)((Object)this.getObservationsWithHttpInfo(tableKey, p, l, fields, traitDataFilter).getBody());
    }

    public ResponseEntity<ResponsePage> getObservationsWithHttpInfo(String tableKey, Integer p, Integer l, List<UUID> fields, TraitDataFilter traitDataFilter) throws RestClientException {
        TraitDataFilter localVarPostBody = traitDataFilter;
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getObservations");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "l", l));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ResponsePage> localReturnType = new ParameterizedTypeReference<ResponsePage>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/get", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<ObservationHistogram> getObservationsHistogram(String tableKey, Integer p, Integer l, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws RestClientException {
        return (List)this.getObservationsHistogramWithHttpInfo(tableKey, p, l, fields, bins, traitDataFilter).getBody();
    }

    public ResponseEntity<List<ObservationHistogram>> getObservationsHistogramWithHttpInfo(String tableKey, Integer p, Integer l, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws RestClientException {
        TraitDataFilter localVarPostBody = traitDataFilter;
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getObservationsHistogram");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "l", l));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bins", bins));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<List<ObservationHistogram>> localReturnType = new ParameterizedTypeReference<List<ObservationHistogram>>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/histogram", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Set<Object> ingestFromPreview(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws RestClientException {
        return (Set)this.ingestFromPreviewWithHttpInfo(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).getBody();
    }

    public ResponseEntity<Set<Object>> ingestFromPreviewWithHttpInfo(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws RestClientException {
        IngestColumnRequest localVarPostBody = ingestColumnRequest;
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling ingestFromPreview");
        }
        if (descriptorUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'descriptorUuid' when calling ingestFromPreview");
        }
        if (previewUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'previewUuid' when calling ingestFromPreview");
        }
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling ingestFromPreview");
        }
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling ingestFromPreview");
        }
        if (ingestColumnRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ingestColumnRequest' when calling ingestFromPreview");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "previewUuid", previewUuid));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sheet", sheet));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/ingest", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public DatasetTable updateTable(DatasetTable datasetTable) throws RestClientException {
        return (DatasetTable)this.updateTableWithHttpInfo(datasetTable).getBody();
    }

    public ResponseEntity<DatasetTable> updateTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        DatasetTable localVarPostBody = datasetTable;
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling updateTable");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/update", HttpMethod.POST, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

