/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.api;

import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.genesys.amphibian.client.invoker.ApiClient;
import org.genesys.amphibian.client.model.Preview;
import org.genesys.amphibian.client.model.PreviewDataFilter;
import org.genesys.amphibian.client.model.RowMetadata;
import org.genesys.amphibian.client.model.StatisticsData;
import org.genesys.amphibian.client.model.ValidateCategoricalRequest;
import org.genesys.amphibian.client.model.ValidateNumericRequest;
import org.genesys.amphibian.client.model.ValidateTextRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="org.genesys.amphibian.client.api.PreviewApi")
public class PreviewApi {
    private ApiClient apiClient;

    public PreviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public PreviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Long addMetadata(UUID uuid, List<RowMetadata> rowMetadata) throws RestClientException {
        return (Long)this.addMetadataWithHttpInfo(uuid, rowMetadata).getBody();
    }

    public ResponseEntity<Long> addMetadataWithHttpInfo(UUID uuid, List<RowMetadata> rowMetadata) throws RestClientException {
        List<RowMetadata> localVarPostBody = rowMetadata;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling addMetadata");
        }
        if (rowMetadata == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rowMetadata' when calling addMetadata");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Long> localReturnType = new ParameterizedTypeReference<Long>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/meta", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void deletePreview(UUID uuid) throws RestClientException {
        this.deletePreviewWithHttpInfo(uuid);
    }

    public ResponseEntity<Void> deletePreviewWithHttpInfo(UUID uuid) throws RestClientException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling deletePreview");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.DELETE, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public void generateDescriptors(UUID uuid) throws RestClientException {
        this.generateDescriptorsWithHttpInfo(uuid);
    }

    public ResponseEntity<Void> generateDescriptorsWithHttpInfo(UUID uuid) throws RestClientException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling generateDescriptors");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/generate-descriptors", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<Object> getData(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws RestClientException {
        return (List)this.getDataWithHttpInfo(uuid, sheet, startRow, limit, fields, previewDataFilter).getBody();
    }

    public ResponseEntity<List<Object>> getDataWithHttpInfo(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws RestClientException {
        PreviewDataFilter localVarPostBody = previewDataFilter;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling getData");
        }
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling getData");
        }
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling getData");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        uriVariables.put("startRow", startRow);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<List<Object>> localReturnType = new ParameterizedTypeReference<List<Object>>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/{sheet}/{startRow}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Preview getPreview(UUID uuid) throws RestClientException {
        return (Preview)this.getPreviewWithHttpInfo(uuid).getBody();
    }

    public ResponseEntity<Preview> getPreviewWithHttpInfo(UUID uuid) throws RestClientException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling getPreview");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Preview> localReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public List<StatisticsData> getStatisticsData(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws RestClientException {
        return (List)this.getStatisticsDataWithHttpInfo(uuid, sheet, fields, startRow, limit).getBody();
    }

    public ResponseEntity<List<StatisticsData>> getStatisticsDataWithHttpInfo(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling getStatisticsData");
        }
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling getStatisticsData");
        }
        if (fields == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fields' when calling getStatisticsData");
        }
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling getStatisticsData");
        }
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling getStatisticsData");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        uriVariables.put("startRow", startRow);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<List<StatisticsData>> localReturnType = new ParameterizedTypeReference<List<StatisticsData>>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/stats/{uuid}/{sheet}/{startRow}", HttpMethod.GET, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Preview ingest(UUID uuid, Date expires, String encoding, String contentType, File _file) throws RestClientException {
        return (Preview)this.ingestWithHttpInfo(uuid, expires, encoding, contentType, _file).getBody();
    }

    public ResponseEntity<Preview> ingestWithHttpInfo(UUID uuid, Date expires, String encoding, String contentType, File _file) throws RestClientException {
        Object localVarPostBody = null;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling ingest");
        }
        if (_file == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling ingest");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (expires != null) {
            localVarFormParams.add((Object)"expires", (Object)expires);
        }
        if (encoding != null) {
            localVarFormParams.add((Object)"encoding", (Object)encoding);
        }
        if (contentType != null) {
            localVarFormParams.add((Object)"contentType", (Object)contentType);
        }
        if (_file != null) {
            localVarFormParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Preview> localReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/ingest/{uuid}", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Set<Object> validateCategorical(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws RestClientException {
        return (Set)this.validateCategoricalWithHttpInfo(uuid, sheet, startRow, validateCategoricalRequest).getBody();
    }

    public ResponseEntity<Set<Object>> validateCategoricalWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws RestClientException {
        ValidateCategoricalRequest localVarPostBody = validateCategoricalRequest;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateCategorical");
        }
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateCategorical");
        }
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateCategorical");
        }
        if (validateCategoricalRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateCategoricalRequest' when calling validateCategorical");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/categorical", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Set<Object> validateNumeric(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws RestClientException {
        return (Set)this.validateNumericWithHttpInfo(uuid, sheet, startRow, validateNumericRequest).getBody();
    }

    public ResponseEntity<Set<Object>> validateNumericWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws RestClientException {
        ValidateNumericRequest localVarPostBody = validateNumericRequest;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateNumeric");
        }
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateNumeric");
        }
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateNumeric");
        }
        if (validateNumericRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateNumericRequest' when calling validateNumeric");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/numeric", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public Set<Object> validateText(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws RestClientException {
        return (Set)this.validateTextWithHttpInfo(uuid, sheet, startRow, validateTextRequest).getBody();
    }

    public ResponseEntity<Set<Object>> validateTextWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws RestClientException {
        ValidateTextRequest localVarPostBody = validateTextRequest;
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateText");
        }
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateText");
        }
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateText");
        }
        if (validateTextRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateTextRequest' when calling validateText");
        }
        HashMap<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/text", HttpMethod.POST, uriVariables, (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

