/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.File;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"expires", "encoding", "contentType", "file"})
@JsonTypeName(value="ingest_request")
public class IngestRequest {
    public static final String JSON_PROPERTY_EXPIRES = "expires";
    private Date expires;
    public static final String JSON_PROPERTY_ENCODING = "encoding";
    private String encoding;
    public static final String JSON_PROPERTY_CONTENT_TYPE = "contentType";
    private String contentType;
    public static final String JSON_PROPERTY_FILE = "file";
    private File _file;

    public IngestRequest expires(Date expires) {
        this.expires = expires;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Set the date after the ingested file may be removed from the database (defaults to default expiration period)")
    @JsonProperty(value="expires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Date getExpires() {
        return this.expires;
    }

    @JsonProperty(value="expires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpires(Date expires) {
        this.expires = expires;
    }

    public IngestRequest encoding(String encoding) {
        this.encoding = encoding;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optionally provide character encoding")
    @JsonProperty(value="encoding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEncoding() {
        return this.encoding;
    }

    @JsonProperty(value="encoding")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public IngestRequest contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optionally provide file content type")
    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getContentType() {
        return this.contentType;
    }

    @JsonProperty(value="contentType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public IngestRequest _file(File _file) {
        this._file = _file;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The file to ingest into the database")
    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public File getFile() {
        return this._file;
    }

    @JsonProperty(value="file")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFile(File _file) {
        this._file = _file;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestRequest ingestRequest = (IngestRequest)o;
        return Objects.equals(this.expires, ingestRequest.expires) && Objects.equals(this.encoding, ingestRequest.encoding) && Objects.equals(this.contentType, ingestRequest.contentType) && Objects.equals(this._file, ingestRequest._file);
    }

    public int hashCode() {
        return Objects.hash(this.expires, this.encoding, this.contentType, this._file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IngestRequest {\n");
        sb.append("    expires: ").append(this.toIndentedString(this.expires)).append("\n");
        sb.append("    encoding: ").append(this.toIndentedString(this.encoding)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    _file: ").append(this.toIndentedString(this._file)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

