package org.genesys.amphibian.client.api;

import org.genesys.amphibian.client.invoker.ApiClient;

import org.genesys.amphibian.client.model.ApiErrorException;
import org.genesys.amphibian.client.model.ChartData;
import org.genesys.amphibian.client.model.DatasetTable;
import org.genesys.amphibian.client.model.HeatMap;
import org.genesys.amphibian.client.model.IngestColumnRequest;
import org.genesys.amphibian.client.model.ObservationHistogram;
import org.genesys.amphibian.client.model.ObservationRegistration;
import org.genesys.amphibian.client.model.ObservationStreamResponse;
import org.genesys.amphibian.client.model.ResponsePageDTO;
import java.util.Set;
import org.genesys.amphibian.client.model.TraitDataFilter;
import java.util.UUID;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(new ApiClient());
    }

    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param observationRegistration  (required)
     * @return ObservationRegistration
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ObservationRegistration addObservations(String tableKey, ObservationRegistration observationRegistration) throws RestClientException {
        return addObservationsWithHttpInfo(tableKey, observationRegistration).getBody();
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param observationRegistration  (required)
     * @return ResponseEntity&lt;ObservationRegistration&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ObservationRegistration> addObservationsWithHttpInfo(String tableKey, ObservationRegistration observationRegistration) throws RestClientException {
        Object localVarPostBody = observationRegistration;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling addObservations");
        }
        
        // verify the required parameter 'observationRegistration' is set
        if (observationRegistration == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'observationRegistration' when calling addObservations");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ObservationRegistration> localReturnType = new ParameterizedTypeReference<ObservationRegistration>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/add", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable createTable(DatasetTable datasetTable) throws RestClientException {
        return createTableWithHttpInfo(datasetTable).getBody();
    }

    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> createTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        Object localVarPostBody = datasetTable;
        
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling createTable");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/create", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable dropTable(DatasetTable datasetTable) throws RestClientException {
        return dropTableWithHttpInfo(datasetTable).getBody();
    }

    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> dropTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        Object localVarPostBody = datasetTable;
        
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling dropTable");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/drop", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get accession observation charts from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param fields Specify fields to return (required)
     * @param traitDataFilter  (required)
     * @return List&lt;ChartData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ChartData> getAccessionCharts(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws RestClientException {
        return getAccessionChartsWithHttpInfo(tableKeys, fields, traitDataFilter).getBody();
    }

    /**
     * Get accession observation charts from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param fields Specify fields to return (required)
     * @param traitDataFilter  (required)
     * @return ResponseEntity&lt;List&lt;ChartData&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ChartData>> getAccessionChartsWithHttpInfo(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKeys' when calling getAccessionCharts");
        }
        
        // verify the required parameter 'fields' is set
        if (fields == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fields' when calling getAccessionCharts");
        }
        
        // verify the required parameter 'traitDataFilter' is set
        if (traitDataFilter == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'traitDataFilter' when calling getAccessionCharts");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<List<ChartData>> localReturnType = new ParameterizedTypeReference<List<ChartData>>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data/charts", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get accession observations from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param traitDataFilter  (required)
     * @param fields Specify fields to return (optional)
     * @param p Page you want to retrieve (0..N) (optional)
     * @param l Number of records per page. (optional)
     * @return ResponsePageDTO
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponsePageDTO getAccessionDatasetObservations(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws RestClientException {
        return getAccessionDatasetObservationsWithHttpInfo(tableKeys, traitDataFilter, fields, p, l).getBody();
    }

    /**
     * Get accession observations from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param traitDataFilter  (required)
     * @param fields Specify fields to return (optional)
     * @param p Page you want to retrieve (0..N) (optional)
     * @param l Number of records per page. (optional)
     * @return ResponseEntity&lt;ResponsePageDTO&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ResponsePageDTO> getAccessionDatasetObservationsWithHttpInfo(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKeys' when calling getAccessionDatasetObservations");
        }
        
        // verify the required parameter 'traitDataFilter' is set
        if (traitDataFilter == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'traitDataFilter' when calling getAccessionDatasetObservations");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ResponsePageDTO> localReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Generate a heat map
     * Calculate a heat map of observations for two selected categorical descriptors in selected DatasetTables
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param xCategory X category field UUID (required)
     * @param yCategory Y category field UUID (required)
     * @param traitDataFilter  (optional)
     * @return HeatMap
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public HeatMap getAccessionsHeatMapData(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws RestClientException {
        return getAccessionsHeatMapDataWithHttpInfo(tableKeys, xCategory, yCategory, traitDataFilter).getBody();
    }

    /**
     * Generate a heat map
     * Calculate a heat map of observations for two selected categorical descriptors in selected DatasetTables
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param xCategory X category field UUID (required)
     * @param yCategory Y category field UUID (required)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;HeatMap&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<HeatMap> getAccessionsHeatMapDataWithHttpInfo(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKeys' when calling getAccessionsHeatMapData");
        }
        
        // verify the required parameter 'xCategory' is set
        if (xCategory == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xCategory' when calling getAccessionsHeatMapData");
        }
        
        // verify the required parameter 'yCategory' is set
        if (yCategory == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'yCategory' when calling getAccessionsHeatMapData");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "xCategory", xCategory));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "yCategory", yCategory));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<HeatMap> localReturnType = new ParameterizedTypeReference<HeatMap>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data/heatmap", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get dataset information
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable getDataset(String tableKey) throws RestClientException {
        return getDatasetWithHttpInfo(tableKey).getBody();
    }

    /**
     * Get dataset information
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> getDatasetWithHttpInfo(String tableKey) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getDataset");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param requestBody  (required)
     * @return List&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<DatasetTable> getDatasets(List<String> requestBody) throws RestClientException {
        return getDatasetsWithHttpInfo(requestBody).getBody();
    }

    /**
     * Get datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param requestBody  (required)
     * @return ResponseEntity&lt;List&lt;DatasetTable&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<DatasetTable>> getDatasetsWithHttpInfo(List<String> requestBody) throws RestClientException {
        Object localVarPostBody = requestBody;
        
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'requestBody' when calling getDatasets");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<List<DatasetTable>> localReturnType = new ParameterizedTypeReference<List<DatasetTable>>() {};
        return apiClient.invokeAPI("/api/v0/datasets/list", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param fields Specify fields to return (optional)
     * @param p Page you want to retrieve (0..N) (optional)
     * @param l Number of records per page. (optional)
     * @param traitDataFilter  (optional)
     * @return ResponsePageDTO
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponsePageDTO getObservations(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws RestClientException {
        return getObservationsWithHttpInfo(tableKey, fields, p, l, traitDataFilter).getBody();
    }

    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param fields Specify fields to return (optional)
     * @param p Page you want to retrieve (0..N) (optional)
     * @param l Number of records per page. (optional)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;ResponsePageDTO&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ResponsePageDTO> getObservationsWithHttpInfo(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling getObservations");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ResponsePageDTO> localReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Generate histograms
     * Get histogram of numerical observations from this datasets
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param fields Specify fields to return (required)
     * @param bins Number of bins (optional, default to 4)
     * @param traitDataFilter  (optional)
     * @return List&lt;ObservationHistogram&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<ObservationHistogram> getObservationsHistograms(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws RestClientException {
        return getObservationsHistogramsWithHttpInfo(tableKeys, fields, bins, traitDataFilter).getBody();
    }

    /**
     * Generate histograms
     * Get histogram of numerical observations from this datasets
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables (required)
     * @param fields Specify fields to return (required)
     * @param bins Number of bins (optional, default to 4)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;List&lt;ObservationHistogram&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<ObservationHistogram>> getObservationsHistogramsWithHttpInfo(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKeys' when calling getObservationsHistograms");
        }
        
        // verify the required parameter 'fields' is set
        if (fields == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fields' when calling getObservationsHistograms");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "bins", bins));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<List<ObservationHistogram>> localReturnType = new ParameterizedTypeReference<List<ObservationHistogram>>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data/histograms", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param descriptorUuid Descriptor UUID (required)
     * @param previewUuid Preview UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row in the Preview (required)
     * @param ingestColumnRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> ingestFromPreview(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws RestClientException {
        return ingestFromPreviewWithHttpInfo(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).getBody();
    }

    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param descriptorUuid Descriptor UUID (required)
     * @param previewUuid Preview UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row in the Preview (required)
     * @param ingestColumnRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> ingestFromPreviewWithHttpInfo(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws RestClientException {
        Object localVarPostBody = ingestColumnRequest;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'descriptorUuid' is set
        if (descriptorUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'descriptorUuid' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'previewUuid' is set
        if (previewUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'previewUuid' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling ingestFromPreview");
        }
        
        // verify the required parameter 'ingestColumnRequest' is set
        if (ingestColumnRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'ingestColumnRequest' when calling ingestFromPreview");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "previewUuid", previewUuid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "sheet", sheet));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/ingest", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Remove descriptor data from table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param descriptorUuid Descriptor UUID (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable removeDescriptorData(String tableKey, UUID descriptorUuid) throws RestClientException {
        return removeDescriptorDataWithHttpInfo(tableKey, descriptorUuid).getBody();
    }

    /**
     * Remove descriptor data from table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param descriptorUuid Descriptor UUID (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> removeDescriptorDataWithHttpInfo(String tableKey, UUID descriptorUuid) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling removeDescriptorData");
        }
        
        // verify the required parameter 'descriptorUuid' is set
        if (descriptorUuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'descriptorUuid' when calling removeDescriptorData");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get accession observations from this dataset using cursor
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param batchSize Number of items to fetch (required)
     * @param streamUuid Stream UUID (optional)
     * @param fields Specify fields to return (optional)
     * @param p Page you want to retrieve (0..N) (optional)
     * @param l Number of records per page. (optional)
     * @param traitDataFilter  (optional)
     * @return ObservationStreamResponse
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ObservationStreamResponse streamObservations(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws RestClientException {
        return streamObservationsWithHttpInfo(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter).getBody();
    }

    /**
     * Get accession observations from this dataset using cursor
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key (required)
     * @param batchSize Number of items to fetch (required)
     * @param streamUuid Stream UUID (optional)
     * @param fields Specify fields to return (optional)
     * @param p Page you want to retrieve (0..N) (optional)
     * @param l Number of records per page. (optional)
     * @param traitDataFilter  (optional)
     * @return ResponseEntity&lt;ObservationStreamResponse&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<ObservationStreamResponse> streamObservationsWithHttpInfo(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws RestClientException {
        Object localVarPostBody = traitDataFilter;
        
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'tableKey' when calling streamObservations");
        }
        
        // verify the required parameter 'batchSize' is set
        if (batchSize == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'batchSize' when calling streamObservations");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("tableKey", tableKey);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "batchSize", batchSize));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "streamUuid", streamUuid));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ObservationStreamResponse> localReturnType = new ParameterizedTypeReference<ObservationStreamResponse>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data/stream", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return DatasetTable
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public DatasetTable updateTable(DatasetTable datasetTable) throws RestClientException {
        return updateTableWithHttpInfo(datasetTable).getBody();
    }

    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable  (required)
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<DatasetTable> updateTableWithHttpInfo(DatasetTable datasetTable) throws RestClientException {
        Object localVarPostBody = datasetTable;
        
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'datasetTable' when calling updateTable");
        }
        

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/update", HttpMethod.POST, Collections.<String, Object>emptyMap(), localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
