package org.genesys.amphibian.client.api;

import org.genesys.amphibian.client.invoker.ApiClient;

import org.genesys.amphibian.client.model.ApiErrorException;
import java.io.File;
import org.genesys.amphibian.client.model.LongToWide;
import java.time.OffsetDateTime;
import org.genesys.amphibian.client.model.Preview;
import org.genesys.amphibian.client.model.PreviewDataFilter;
import org.genesys.amphibian.client.model.RowMetadata;
import java.util.Set;
import org.genesys.amphibian.client.model.StatisticsData;
import java.util.UUID;
import org.genesys.amphibian.client.model.ValidateBoolRequest;
import org.genesys.amphibian.client.model.ValidateCategoricalRequest;
import org.genesys.amphibian.client.model.ValidateDateRequest;
import org.genesys.amphibian.client.model.ValidateNumericRequest;
import org.genesys.amphibian.client.model.ValidateTextRequest;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PreviewApi {
    private ApiClient apiClient;

    public PreviewApi() {
        this(new ApiClient());
    }

    public PreviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add metadata to ingested rows
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The number of Preview rows updated
     * @param uuid Your reference UUID by which you can refer back to the dataset (required)
     * @param rowMetadata  (required)
     * @return Long
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Long addMetadata(UUID uuid, List<RowMetadata> rowMetadata) throws RestClientException {
        return addMetadataWithHttpInfo(uuid, rowMetadata).getBody();
    }

    /**
     * Add metadata to ingested rows
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The number of Preview rows updated
     * @param uuid Your reference UUID by which you can refer back to the dataset (required)
     * @param rowMetadata  (required)
     * @return ResponseEntity&lt;Long&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Long> addMetadataWithHttpInfo(UUID uuid, List<RowMetadata> rowMetadata) throws RestClientException {
        Object localVarPostBody = rowMetadata;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling addMetadata");
        }
        
        // verify the required parameter 'rowMetadata' is set
        if (rowMetadata == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'rowMetadata' when calling addMetadata");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Long> localReturnType = new ParameterizedTypeReference<Long>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/meta", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Remove the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void deletePreview(UUID uuid) throws RestClientException {
        deletePreviewWithHttpInfo(uuid);
    }

    /**
     * Remove the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> deletePreviewWithHttpInfo(UUID uuid) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling deletePreview");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.DELETE, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Generate descriptors for all PreviewSheets of given Preview
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public void generateDescriptors(UUID uuid) throws RestClientException {
        generateDescriptorsWithHttpInfo(uuid);
    }

    /**
     * Generate descriptors for all PreviewSheets of given Preview
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @return ResponseEntity&lt;Void&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Void> generateDescriptorsWithHttpInfo(UUID uuid) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling generateDescriptors");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/generate-descriptors", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param limit Number of rows to return (optional)
     * @param fields Specify fields to return (optional)
     * @param previewDataFilter  (optional)
     * @return List&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<Object> getData(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws RestClientException {
        return getDataWithHttpInfo(uuid, sheet, startRow, limit, fields, previewDataFilter).getBody();
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param limit Number of rows to return (optional)
     * @param fields Specify fields to return (optional)
     * @param previewDataFilter  (optional)
     * @return ResponseEntity&lt;List&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<Object>> getDataWithHttpInfo(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws RestClientException {
        Object localVarPostBody = previewDataFilter;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling getData");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling getData");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling getData");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        uriVariables.put("startRow", startRow);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<List<Object>> localReturnType = new ParameterizedTypeReference<List<Object>>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/{sheet}/{startRow}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @return Preview
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Preview getPreview(UUID uuid) throws RestClientException {
        return getPreviewWithHttpInfo(uuid).getBody();
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @return ResponseEntity&lt;Preview&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Preview> getPreviewWithHttpInfo(UUID uuid) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling getPreview");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Preview> localReturnType = new ParameterizedTypeReference<Preview>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Get the statistics of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param fields Specify fields to analyze (required)
     * @param startRow Index of the first row (required)
     * @param limit Number of distinct values to return (required)
     * @return List&lt;StatisticsData&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public List<StatisticsData> getStatisticsData(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws RestClientException {
        return getStatisticsDataWithHttpInfo(uuid, sheet, fields, startRow, limit).getBody();
    }

    /**
     * Get the statistics of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param fields Specify fields to analyze (required)
     * @param startRow Index of the first row (required)
     * @param limit Number of distinct values to return (required)
     * @return ResponseEntity&lt;List&lt;StatisticsData&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<List<StatisticsData>> getStatisticsDataWithHttpInfo(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling getStatisticsData");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling getStatisticsData");
        }
        
        // verify the required parameter 'fields' is set
        if (fields == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'fields' when calling getStatisticsData");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling getStatisticsData");
        }
        
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'limit' when calling getStatisticsData");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);
        uriVariables.put("startRow", startRow);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = {  };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<List<StatisticsData>> localReturnType = new ParameterizedTypeReference<List<StatisticsData>>() {};
        return apiClient.invokeAPI("/api/v0/preview/stats/{uuid}/{sheet}/{startRow}", HttpMethod.GET, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Ingest a new dataset
     * Ingests Excel, CSV or TSV files for preview
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The overview of the parsed dataset
     * @param uuid Your reference UUID by which you can refer back to the dataset (required)
     * @param _file The file to ingest into the database (required)
     * @param expires Set the date after the ingested file may be removed from the database (defaults to default expiration period) (optional)
     * @param encoding Optionally provide character encoding (optional)
     * @param contentType Optionally provide file content type (optional)
     * @return Preview
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Preview ingest(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws RestClientException {
        return ingestWithHttpInfo(uuid, _file, expires, encoding, contentType).getBody();
    }

    /**
     * Ingest a new dataset
     * Ingests Excel, CSV or TSV files for preview
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The overview of the parsed dataset
     * @param uuid Your reference UUID by which you can refer back to the dataset (required)
     * @param _file The file to ingest into the database (required)
     * @param expires Set the date after the ingested file may be removed from the database (defaults to default expiration period) (optional)
     * @param encoding Optionally provide character encoding (optional)
     * @param contentType Optionally provide file content type (optional)
     * @return ResponseEntity&lt;Preview&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Preview> ingestWithHttpInfo(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws RestClientException {
        Object localVarPostBody = null;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling ingest");
        }
        
        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter '_file' when calling ingest");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        if (expires != null)
            localVarFormParams.add("expires", expires);
        if (encoding != null)
            localVarFormParams.add("encoding", encoding);
        if (contentType != null)
            localVarFormParams.add("contentType", contentType);
        if (_file != null)
            localVarFormParams.add("file", new FileSystemResource(_file));

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Preview> localReturnType = new ParameterizedTypeReference<Preview>() {};
        return apiClient.invokeAPI("/api/v0/preview/ingest/{uuid}", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Generate a sheet with wide data from long data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param longToWide  (required)
     * @return Preview
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Preview longToWide(UUID uuid, LongToWide longToWide) throws RestClientException {
        return longToWideWithHttpInfo(uuid, longToWide).getBody();
    }

    /**
     * Generate a sheet with wide data from long data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param longToWide  (required)
     * @return ResponseEntity&lt;Preview&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Preview> longToWideWithHttpInfo(UUID uuid, LongToWide longToWide) throws RestClientException {
        Object localVarPostBody = longToWide;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling longToWide");
        }
        
        // verify the required parameter 'longToWide' is set
        if (longToWide == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'longToWide' when calling longToWide");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Preview> localReturnType = new ParameterizedTypeReference<Preview>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/pivot", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Assert that field values correspond to booleans
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateBoolRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> validateBool(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws RestClientException {
        return validateBoolWithHttpInfo(uuid, sheet, startRow, validateBoolRequest).getBody();
    }

    /**
     * Assert that field values correspond to booleans
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateBoolRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> validateBoolWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws RestClientException {
        Object localVarPostBody = validateBoolRequest;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateBool");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateBool");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateBool");
        }
        
        // verify the required parameter 'validateBoolRequest' is set
        if (validateBoolRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateBoolRequest' when calling validateBool");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/bool", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Assert that field values correspond to constraints for CATEGORICAL data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateCategoricalRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> validateCategorical(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws RestClientException {
        return validateCategoricalWithHttpInfo(uuid, sheet, startRow, validateCategoricalRequest).getBody();
    }

    /**
     * Assert that field values correspond to constraints for CATEGORICAL data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateCategoricalRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> validateCategoricalWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws RestClientException {
        Object localVarPostBody = validateCategoricalRequest;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateCategorical");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateCategorical");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateCategorical");
        }
        
        // verify the required parameter 'validateCategoricalRequest' is set
        if (validateCategoricalRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateCategoricalRequest' when calling validateCategorical");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/categorical", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Assert that field values correspond to constraints for date
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateDateRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> validateDate(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws RestClientException {
        return validateDateWithHttpInfo(uuid, sheet, startRow, validateDateRequest).getBody();
    }

    /**
     * Assert that field values correspond to constraints for date
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateDateRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> validateDateWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws RestClientException {
        Object localVarPostBody = validateDateRequest;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateDate");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateDate");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateDate");
        }
        
        // verify the required parameter 'validateDateRequest' is set
        if (validateDateRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateDateRequest' when calling validateDate");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/date", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateNumericRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> validateNumeric(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws RestClientException {
        return validateNumericWithHttpInfo(uuid, sheet, startRow, validateNumericRequest).getBody();
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateNumericRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> validateNumericWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws RestClientException {
        Object localVarPostBody = validateNumericRequest;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateNumeric");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateNumeric");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateNumeric");
        }
        
        // verify the required parameter 'validateNumericRequest' is set
        if (validateNumericRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateNumericRequest' when calling validateNumeric");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/numeric", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateTextRequest  (required)
     * @return Set&lt;Object&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public Set<Object> validateText(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws RestClientException {
        return validateTextWithHttpInfo(uuid, sheet, startRow, validateTextRequest).getBody();
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID (required)
     * @param sheet Sheet index (required)
     * @param startRow Index of the first row (required)
     * @param validateTextRequest  (required)
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws RestClientException if an error occurs while attempting to invoke the API
     */
    public ResponseEntity<Set<Object>> validateTextWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws RestClientException {
        Object localVarPostBody = validateTextRequest;
        
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'uuid' when calling validateText");
        }
        
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'sheet' when calling validateText");
        }
        
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'startRow' when calling validateText");
        }
        
        // verify the required parameter 'validateTextRequest' is set
        if (validateTextRequest == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'validateTextRequest' when calling validateText");
        }
        
        // create path and map variables
        final Map<String, Object> uriVariables = new HashMap<String, Object>();
        uriVariables.put("uuid", uuid);
        uriVariables.put("sheet", sheet);

        final MultiValueMap<String, String> localVarQueryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders localVarHeaderParams = new HttpHeaders();
        final MultiValueMap<String, String> localVarCookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> localVarFormParams = new LinkedMultiValueMap<String, Object>();

        localVarQueryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));


        final String[] localVarAccepts = { 
            "*/*"
         };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
         };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Set<Object>> localReturnType = new ParameterizedTypeReference<Set<Object>>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/text", HttpMethod.POST, uriVariables, localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}
