package org.genesys.amphibian.client.api;

import org.genesys.amphibian.client.invoker.ApiClient;

import org.genesys.amphibian.client.model.ApiErrorException;
import org.genesys.amphibian.client.model.ChartData;
import org.genesys.amphibian.client.model.DatasetTable;
import org.genesys.amphibian.client.model.HeatMap;
import org.genesys.amphibian.client.model.IngestColumnRequest;
import org.genesys.amphibian.client.model.ObservationHistogram;
import org.genesys.amphibian.client.model.ObservationRegistration;
import org.genesys.amphibian.client.model.ObservationStreamResponse;
import org.genesys.amphibian.client.model.ResponsePageDTO;
import java.util.Set;
import org.genesys.amphibian.client.model.TraitDataFilter;
import java.util.UUID;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(new ApiClient());
    }

    @Autowired
    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param observationRegistration The observationRegistration parameter
     * @return ObservationRegistration
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addObservationsRequestCreation(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        Object postBody = observationRegistration;
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling addObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'observationRegistration' is set
        if (observationRegistration == null) {
            throw new WebClientResponseException("Missing the required parameter 'observationRegistration' when calling addObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("tableKey", tableKey);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ObservationRegistration> localVarReturnType = new ParameterizedTypeReference<ObservationRegistration>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/add", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param observationRegistration The observationRegistration parameter
     * @return ObservationRegistration
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ObservationRegistration> addObservations(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationRegistration> localVarReturnType = new ParameterizedTypeReference<ObservationRegistration>() {};
        return addObservationsRequestCreation(tableKey, observationRegistration).bodyToMono(localVarReturnType);
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param observationRegistration The observationRegistration parameter
     * @return ResponseEntity&lt;ObservationRegistration&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ObservationRegistration>> addObservationsWithHttpInfo(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationRegistration> localVarReturnType = new ParameterizedTypeReference<ObservationRegistration>() {};
        return addObservationsRequestCreation(tableKey, observationRegistration).toEntity(localVarReturnType);
    }

    /**
     * Add observations, returns result of update
     * Add accession observations
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param observationRegistration The observationRegistration parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addObservationsWithResponseSpec(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        return addObservationsRequestCreation(tableKey, observationRegistration);
    }
    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec createTableRequestCreation(DatasetTable datasetTable) throws WebClientResponseException {
        Object postBody = datasetTable;
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetTable' when calling createTable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/create", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DatasetTable> createTable(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return createTableRequestCreation(datasetTable).bodyToMono(localVarReturnType);
    }

    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DatasetTable>> createTableWithHttpInfo(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return createTableRequestCreation(datasetTable).toEntity(localVarReturnType);
    }

    /**
     * Create a new table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec createTableWithResponseSpec(DatasetTable datasetTable) throws WebClientResponseException {
        return createTableRequestCreation(datasetTable);
    }
    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec dropTableRequestCreation(DatasetTable datasetTable) throws WebClientResponseException {
        Object postBody = datasetTable;
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetTable' when calling dropTable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/drop", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DatasetTable> dropTable(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return dropTableRequestCreation(datasetTable).bodyToMono(localVarReturnType);
    }

    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DatasetTable>> dropTableWithHttpInfo(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return dropTableRequestCreation(datasetTable).toEntity(localVarReturnType);
    }

    /**
     * Drop a table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec dropTableWithResponseSpec(DatasetTable datasetTable) throws WebClientResponseException {
        return dropTableRequestCreation(datasetTable);
    }
    /**
     * Get accession observation charts from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param traitDataFilter The traitDataFilter parameter
     * @return List&lt;ChartData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getAccessionChartsRequestCreation(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        Object postBody = traitDataFilter;
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getAccessionCharts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'fields' is set
        if (fields == null) {
            throw new WebClientResponseException("Missing the required parameter 'fields' when calling getAccessionCharts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'traitDataFilter' is set
        if (traitDataFilter == null) {
            throw new WebClientResponseException("Missing the required parameter 'traitDataFilter' when calling getAccessionCharts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ChartData> localVarReturnType = new ParameterizedTypeReference<ChartData>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data/charts", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get accession observation charts from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param traitDataFilter The traitDataFilter parameter
     * @return List&lt;ChartData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ChartData> getAccessionCharts(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ChartData> localVarReturnType = new ParameterizedTypeReference<ChartData>() {};
        return getAccessionChartsRequestCreation(tableKeys, fields, traitDataFilter).bodyToFlux(localVarReturnType);
    }

    /**
     * Get accession observation charts from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseEntity&lt;List&lt;ChartData&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ChartData>>> getAccessionChartsWithHttpInfo(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ChartData> localVarReturnType = new ParameterizedTypeReference<ChartData>() {};
        return getAccessionChartsRequestCreation(tableKeys, fields, traitDataFilter).toEntityList(localVarReturnType);
    }

    /**
     * Get accession observation charts from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getAccessionChartsWithResponseSpec(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return getAccessionChartsRequestCreation(tableKeys, fields, traitDataFilter);
    }
    /**
     * Get accession observations from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param traitDataFilter The traitDataFilter parameter
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @return ResponsePageDTO
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getAccessionDatasetObservationsRequestCreation(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        Object postBody = traitDataFilter;
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getAccessionDatasetObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'traitDataFilter' is set
        if (traitDataFilter == null) {
            throw new WebClientResponseException("Missing the required parameter 'traitDataFilter' when calling getAccessionDatasetObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get accession observations from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param traitDataFilter The traitDataFilter parameter
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @return ResponsePageDTO
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponsePageDTO> getAccessionDatasetObservations(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return getAccessionDatasetObservationsRequestCreation(tableKeys, traitDataFilter, fields, p, l).bodyToMono(localVarReturnType);
    }

    /**
     * Get accession observations from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param traitDataFilter The traitDataFilter parameter
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @return ResponseEntity&lt;ResponsePageDTO&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ResponsePageDTO>> getAccessionDatasetObservationsWithHttpInfo(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return getAccessionDatasetObservationsRequestCreation(tableKeys, traitDataFilter, fields, p, l).toEntity(localVarReturnType);
    }

    /**
     * Get accession observations from datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param traitDataFilter The traitDataFilter parameter
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getAccessionDatasetObservationsWithResponseSpec(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        return getAccessionDatasetObservationsRequestCreation(tableKeys, traitDataFilter, fields, p, l);
    }
    /**
     * Generate a heat map
     * Calculate a heat map of observations for two selected categorical descriptors in selected DatasetTables
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param xCategory X category field UUID
     * @param yCategory Y category field UUID
     * @param traitDataFilter The traitDataFilter parameter
     * @return HeatMap
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getAccessionsHeatMapDataRequestCreation(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        Object postBody = traitDataFilter;
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getAccessionsHeatMapData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'xCategory' is set
        if (xCategory == null) {
            throw new WebClientResponseException("Missing the required parameter 'xCategory' when calling getAccessionsHeatMapData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'yCategory' is set
        if (yCategory == null) {
            throw new WebClientResponseException("Missing the required parameter 'yCategory' when calling getAccessionsHeatMapData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "xCategory", xCategory));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "yCategory", yCategory));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<HeatMap> localVarReturnType = new ParameterizedTypeReference<HeatMap>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data/heatmap", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a heat map
     * Calculate a heat map of observations for two selected categorical descriptors in selected DatasetTables
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param xCategory X category field UUID
     * @param yCategory Y category field UUID
     * @param traitDataFilter The traitDataFilter parameter
     * @return HeatMap
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<HeatMap> getAccessionsHeatMapData(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<HeatMap> localVarReturnType = new ParameterizedTypeReference<HeatMap>() {};
        return getAccessionsHeatMapDataRequestCreation(tableKeys, xCategory, yCategory, traitDataFilter).bodyToMono(localVarReturnType);
    }

    /**
     * Generate a heat map
     * Calculate a heat map of observations for two selected categorical descriptors in selected DatasetTables
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param xCategory X category field UUID
     * @param yCategory Y category field UUID
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseEntity&lt;HeatMap&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<HeatMap>> getAccessionsHeatMapDataWithHttpInfo(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<HeatMap> localVarReturnType = new ParameterizedTypeReference<HeatMap>() {};
        return getAccessionsHeatMapDataRequestCreation(tableKeys, xCategory, yCategory, traitDataFilter).toEntity(localVarReturnType);
    }

    /**
     * Generate a heat map
     * Calculate a heat map of observations for two selected categorical descriptors in selected DatasetTables
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param xCategory X category field UUID
     * @param yCategory Y category field UUID
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getAccessionsHeatMapDataWithResponseSpec(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return getAccessionsHeatMapDataRequestCreation(tableKeys, xCategory, yCategory, traitDataFilter);
    }
    /**
     * Get dataset information
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getDatasetRequestCreation(String tableKey) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling getDataset", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("tableKey", tableKey);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get dataset information
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DatasetTable> getDataset(String tableKey) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return getDatasetRequestCreation(tableKey).bodyToMono(localVarReturnType);
    }

    /**
     * Get dataset information
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DatasetTable>> getDatasetWithHttpInfo(String tableKey) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return getDatasetRequestCreation(tableKey).toEntity(localVarReturnType);
    }

    /**
     * Get dataset information
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getDatasetWithResponseSpec(String tableKey) throws WebClientResponseException {
        return getDatasetRequestCreation(tableKey);
    }
    /**
     * Get datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param requestBody The requestBody parameter
     * @return List&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getDatasetsRequestCreation(List<String> requestBody) throws WebClientResponseException {
        Object postBody = requestBody;
        // verify the required parameter 'requestBody' is set
        if (requestBody == null) {
            throw new WebClientResponseException("Missing the required parameter 'requestBody' when calling getDatasets", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/list", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param requestBody The requestBody parameter
     * @return List&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<DatasetTable> getDatasets(List<String> requestBody) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return getDatasetsRequestCreation(requestBody).bodyToFlux(localVarReturnType);
    }

    /**
     * Get datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param requestBody The requestBody parameter
     * @return ResponseEntity&lt;List&lt;DatasetTable&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<DatasetTable>>> getDatasetsWithHttpInfo(List<String> requestBody) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return getDatasetsRequestCreation(requestBody).toEntityList(localVarReturnType);
    }

    /**
     * Get datasets
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param requestBody The requestBody parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getDatasetsWithResponseSpec(List<String> requestBody) throws WebClientResponseException {
        return getDatasetsRequestCreation(requestBody);
    }
    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponsePageDTO
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getObservationsRequestCreation(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        Object postBody = traitDataFilter;
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling getObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("tableKey", tableKey);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponsePageDTO
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponsePageDTO> getObservations(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return getObservationsRequestCreation(tableKey, fields, p, l, traitDataFilter).bodyToMono(localVarReturnType);
    }

    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseEntity&lt;ResponsePageDTO&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ResponsePageDTO>> getObservationsWithHttpInfo(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>() {};
        return getObservationsRequestCreation(tableKey, fields, p, l, traitDataFilter).toEntity(localVarReturnType);
    }

    /**
     * Get accession observations from this dataset
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getObservationsWithResponseSpec(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return getObservationsRequestCreation(tableKey, fields, p, l, traitDataFilter);
    }
    /**
     * Generate histograms
     * Get histogram of numerical observations from this datasets
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param bins Number of bins
     * @param traitDataFilter The traitDataFilter parameter
     * @return List&lt;ObservationHistogram&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getObservationsHistogramsRequestCreation(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        Object postBody = traitDataFilter;
        // verify the required parameter 'tableKeys' is set
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getObservationsHistograms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'fields' is set
        if (fields == null) {
            throw new WebClientResponseException("Missing the required parameter 'fields' when calling getObservationsHistograms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "bins", bins));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ObservationHistogram> localVarReturnType = new ParameterizedTypeReference<ObservationHistogram>() {};
        return apiClient.invokeAPI("/api/v0/datasets/data/histograms", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate histograms
     * Get histogram of numerical observations from this datasets
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param bins Number of bins
     * @param traitDataFilter The traitDataFilter parameter
     * @return List&lt;ObservationHistogram&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<ObservationHistogram> getObservationsHistograms(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationHistogram> localVarReturnType = new ParameterizedTypeReference<ObservationHistogram>() {};
        return getObservationsHistogramsRequestCreation(tableKeys, fields, bins, traitDataFilter).bodyToFlux(localVarReturnType);
    }

    /**
     * Generate histograms
     * Get histogram of numerical observations from this datasets
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param bins Number of bins
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseEntity&lt;List&lt;ObservationHistogram&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<ObservationHistogram>>> getObservationsHistogramsWithHttpInfo(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationHistogram> localVarReturnType = new ParameterizedTypeReference<ObservationHistogram>() {};
        return getObservationsHistogramsRequestCreation(tableKeys, fields, bins, traitDataFilter).toEntityList(localVarReturnType);
    }

    /**
     * Generate histograms
     * Get histogram of numerical observations from this datasets
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKeys Keys of tables
     * @param fields Specify fields to return
     * @param bins Number of bins
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getObservationsHistogramsWithResponseSpec(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return getObservationsHistogramsRequestCreation(tableKeys, fields, bins, traitDataFilter);
    }
    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @param previewUuid Preview UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row in the Preview
     * @param ingestColumnRequest The ingestColumnRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec ingestFromPreviewRequestCreation(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        Object postBody = ingestColumnRequest;
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'descriptorUuid' is set
        if (descriptorUuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'descriptorUuid' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'previewUuid' is set
        if (previewUuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'previewUuid' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'ingestColumnRequest' is set
        if (ingestColumnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'ingestColumnRequest' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("tableKey", tableKey);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "previewUuid", previewUuid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "sheet", sheet));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/ingest", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @param previewUuid Preview UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row in the Preview
     * @param ingestColumnRequest The ingestColumnRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> ingestFromPreview(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return ingestFromPreviewRequestCreation(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).bodyToFlux(localVarReturnType);
    }

    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @param previewUuid Preview UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row in the Preview
     * @param ingestColumnRequest The ingestColumnRequest parameter
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> ingestFromPreviewWithHttpInfo(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return ingestFromPreviewRequestCreation(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).toEntityList(localVarReturnType);
    }

    /**
     * Ingest column values from Preview to Table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @param previewUuid Preview UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row in the Preview
     * @param ingestColumnRequest The ingestColumnRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec ingestFromPreviewWithResponseSpec(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        return ingestFromPreviewRequestCreation(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest);
    }
    /**
     * Remove descriptor data from table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec removeDescriptorDataRequestCreation(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling removeDescriptorData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'descriptorUuid' is set
        if (descriptorUuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'descriptorUuid' when calling removeDescriptorData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("tableKey", tableKey);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove descriptor data from table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DatasetTable> removeDescriptorData(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return removeDescriptorDataRequestCreation(tableKey, descriptorUuid).bodyToMono(localVarReturnType);
    }

    /**
     * Remove descriptor data from table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DatasetTable>> removeDescriptorDataWithHttpInfo(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return removeDescriptorDataRequestCreation(tableKey, descriptorUuid).toEntity(localVarReturnType);
    }

    /**
     * Remove descriptor data from table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param descriptorUuid Descriptor UUID
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec removeDescriptorDataWithResponseSpec(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        return removeDescriptorDataRequestCreation(tableKey, descriptorUuid);
    }
    /**
     * Get accession observations from this dataset using cursor
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param batchSize Number of items to fetch
     * @param streamUuid Stream UUID
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ObservationStreamResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec streamObservationsRequestCreation(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        Object postBody = traitDataFilter;
        // verify the required parameter 'tableKey' is set
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling streamObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'batchSize' is set
        if (batchSize == null) {
            throw new WebClientResponseException("Missing the required parameter 'batchSize' when calling streamObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("tableKey", tableKey);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "batchSize", batchSize));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "streamUuid", streamUuid));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "p", p));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "l", l));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<ObservationStreamResponse> localVarReturnType = new ParameterizedTypeReference<ObservationStreamResponse>() {};
        return apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data/stream", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get accession observations from this dataset using cursor
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param batchSize Number of items to fetch
     * @param streamUuid Stream UUID
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ObservationStreamResponse
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ObservationStreamResponse> streamObservations(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationStreamResponse> localVarReturnType = new ParameterizedTypeReference<ObservationStreamResponse>() {};
        return streamObservationsRequestCreation(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter).bodyToMono(localVarReturnType);
    }

    /**
     * Get accession observations from this dataset using cursor
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param batchSize Number of items to fetch
     * @param streamUuid Stream UUID
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseEntity&lt;ObservationStreamResponse&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<ObservationStreamResponse>> streamObservationsWithHttpInfo(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationStreamResponse> localVarReturnType = new ParameterizedTypeReference<ObservationStreamResponse>() {};
        return streamObservationsRequestCreation(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter).toEntity(localVarReturnType);
    }

    /**
     * Get accession observations from this dataset using cursor
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param tableKey Table key
     * @param batchSize Number of items to fetch
     * @param streamUuid Stream UUID
     * @param fields Specify fields to return
     * @param p Page you want to retrieve (0..N)
     * @param l Number of records per page.
     * @param traitDataFilter The traitDataFilter parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec streamObservationsWithResponseSpec(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return streamObservationsRequestCreation(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter);
    }
    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec updateTableRequestCreation(DatasetTable datasetTable) throws WebClientResponseException {
        Object postBody = datasetTable;
        // verify the required parameter 'datasetTable' is set
        if (datasetTable == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetTable' when calling updateTable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return apiClient.invokeAPI("/api/v0/datasets/update", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return DatasetTable
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<DatasetTable> updateTable(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return updateTableRequestCreation(datasetTable).bodyToMono(localVarReturnType);
    }

    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return ResponseEntity&lt;DatasetTable&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<DatasetTable>> updateTableWithHttpInfo(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>() {};
        return updateTableRequestCreation(datasetTable).toEntity(localVarReturnType);
    }

    /**
     * Update table
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param datasetTable The datasetTable parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec updateTableWithResponseSpec(DatasetTable datasetTable) throws WebClientResponseException {
        return updateTableRequestCreation(datasetTable);
    }
}
