package org.genesys.amphibian.client.api;

import org.genesys.amphibian.client.invoker.ApiClient;

import org.genesys.amphibian.client.model.ApiErrorException;
import java.io.File;
import org.genesys.amphibian.client.model.LongToWide;
import java.time.OffsetDateTime;
import org.genesys.amphibian.client.model.Preview;
import org.genesys.amphibian.client.model.PreviewDataFilter;
import org.genesys.amphibian.client.model.RowMetadata;
import java.util.Set;
import org.genesys.amphibian.client.model.StatisticsData;
import java.util.UUID;
import org.genesys.amphibian.client.model.ValidateBoolRequest;
import org.genesys.amphibian.client.model.ValidateCategoricalRequest;
import org.genesys.amphibian.client.model.ValidateDateRequest;
import org.genesys.amphibian.client.model.ValidateNumericRequest;
import org.genesys.amphibian.client.model.ValidateTextRequest;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.web.reactive.function.client.WebClient.ResponseSpec;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Flux;

@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PreviewApi {
    private ApiClient apiClient;

    public PreviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public PreviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Add metadata to ingested rows
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The number of Preview rows updated
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param rowMetadata The rowMetadata parameter
     * @return Long
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec addMetadataRequestCreation(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        Object postBody = rowMetadata;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling addMetadata", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'rowMetadata' is set
        if (rowMetadata == null) {
            throw new WebClientResponseException("Missing the required parameter 'rowMetadata' when calling addMetadata", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Long> localVarReturnType = new ParameterizedTypeReference<Long>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/meta", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Add metadata to ingested rows
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The number of Preview rows updated
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param rowMetadata The rowMetadata parameter
     * @return Long
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Long> addMetadata(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        ParameterizedTypeReference<Long> localVarReturnType = new ParameterizedTypeReference<Long>() {};
        return addMetadataRequestCreation(uuid, rowMetadata).bodyToMono(localVarReturnType);
    }

    /**
     * Add metadata to ingested rows
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The number of Preview rows updated
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param rowMetadata The rowMetadata parameter
     * @return ResponseEntity&lt;Long&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Long>> addMetadataWithHttpInfo(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        ParameterizedTypeReference<Long> localVarReturnType = new ParameterizedTypeReference<Long>() {};
        return addMetadataRequestCreation(uuid, rowMetadata).toEntity(localVarReturnType);
    }

    /**
     * Add metadata to ingested rows
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The number of Preview rows updated
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param rowMetadata The rowMetadata parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec addMetadataWithResponseSpec(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        return addMetadataRequestCreation(uuid, rowMetadata);
    }
    /**
     * Remove the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec deletePreviewRequestCreation(UUID uuid) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling deletePreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.DELETE, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Remove the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> deletePreview(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return deletePreviewRequestCreation(uuid).bodyToMono(localVarReturnType);
    }

    /**
     * Remove the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Void>> deletePreviewWithHttpInfo(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return deletePreviewRequestCreation(uuid).toEntity(localVarReturnType);
    }

    /**
     * Remove the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec deletePreviewWithResponseSpec(UUID uuid) throws WebClientResponseException {
        return deletePreviewRequestCreation(uuid);
    }
    /**
     * Generate descriptors for all PreviewSheets of given Preview
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec generateDescriptorsRequestCreation(UUID uuid) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling generateDescriptors", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/generate-descriptors", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate descriptors for all PreviewSheets of given Preview
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Void> generateDescriptors(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return generateDescriptorsRequestCreation(uuid).bodyToMono(localVarReturnType);
    }

    /**
     * Generate descriptors for all PreviewSheets of given Preview
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Void>> generateDescriptorsWithHttpInfo(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>() {};
        return generateDescriptorsRequestCreation(uuid).toEntity(localVarReturnType);
    }

    /**
     * Generate descriptors for all PreviewSheets of given Preview
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec generateDescriptorsWithResponseSpec(UUID uuid) throws WebClientResponseException {
        return generateDescriptorsRequestCreation(uuid);
    }
    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param limit Number of rows to return
     * @param fields Specify fields to return
     * @param previewDataFilter The previewDataFilter parameter
     * @return List&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getDataRequestCreation(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        Object postBody = previewDataFilter;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling getData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling getData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling getData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        pathParams.put("startRow", startRow);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/{sheet}/{startRow}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param limit Number of rows to return
     * @param fields Specify fields to return
     * @param previewDataFilter The previewDataFilter parameter
     * @return List&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> getData(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return getDataRequestCreation(uuid, sheet, startRow, limit, fields, previewDataFilter).bodyToFlux(localVarReturnType);
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param limit Number of rows to return
     * @param fields Specify fields to return
     * @param previewDataFilter The previewDataFilter parameter
     * @return ResponseEntity&lt;List&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> getDataWithHttpInfo(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return getDataRequestCreation(uuid, sheet, startRow, limit, fields, previewDataFilter).toEntityList(localVarReturnType);
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param limit Number of rows to return
     * @param fields Specify fields to return
     * @param previewDataFilter The previewDataFilter parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getDataWithResponseSpec(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        return getDataRequestCreation(uuid, sheet, startRow, limit, fields, previewDataFilter);
    }
    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @return Preview
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getPreviewRequestCreation(UUID uuid) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling getPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @return Preview
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Preview> getPreview(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return getPreviewRequestCreation(uuid).bodyToMono(localVarReturnType);
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @return ResponseEntity&lt;Preview&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Preview>> getPreviewWithHttpInfo(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return getPreviewRequestCreation(uuid).toEntity(localVarReturnType);
    }

    /**
     * Get the overview of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getPreviewWithResponseSpec(UUID uuid) throws WebClientResponseException {
        return getPreviewRequestCreation(uuid);
    }
    /**
     * Get the statistics of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param fields Specify fields to analyze
     * @param startRow Index of the first row
     * @param limit Number of distinct values to return
     * @return List&lt;StatisticsData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec getStatisticsDataRequestCreation(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'fields' is set
        if (fields == null) {
            throw new WebClientResponseException("Missing the required parameter 'fields' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'limit' is set
        if (limit == null) {
            throw new WebClientResponseException("Missing the required parameter 'limit' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        pathParams.put("startRow", startRow);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "limit", limit));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<StatisticsData> localVarReturnType = new ParameterizedTypeReference<StatisticsData>() {};
        return apiClient.invokeAPI("/api/v0/preview/stats/{uuid}/{sheet}/{startRow}", HttpMethod.GET, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Get the statistics of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param fields Specify fields to analyze
     * @param startRow Index of the first row
     * @param limit Number of distinct values to return
     * @return List&lt;StatisticsData&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<StatisticsData> getStatisticsData(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<StatisticsData> localVarReturnType = new ParameterizedTypeReference<StatisticsData>() {};
        return getStatisticsDataRequestCreation(uuid, sheet, fields, startRow, limit).bodyToFlux(localVarReturnType);
    }

    /**
     * Get the statistics of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param fields Specify fields to analyze
     * @param startRow Index of the first row
     * @param limit Number of distinct values to return
     * @return ResponseEntity&lt;List&lt;StatisticsData&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<StatisticsData>>> getStatisticsDataWithHttpInfo(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<StatisticsData> localVarReturnType = new ParameterizedTypeReference<StatisticsData>() {};
        return getStatisticsDataRequestCreation(uuid, sheet, fields, startRow, limit).toEntityList(localVarReturnType);
    }

    /**
     * Get the statistics of the parsed dataset
     * Use the same reference UUID as provided when ingesting a dataset
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param fields Specify fields to analyze
     * @param startRow Index of the first row
     * @param limit Number of distinct values to return
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec getStatisticsDataWithResponseSpec(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        return getStatisticsDataRequestCreation(uuid, sheet, fields, startRow, limit);
    }
    /**
     * Ingest a new dataset
     * Ingests Excel, CSV or TSV files for preview
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The overview of the parsed dataset
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param _file The file to ingest into the database
     * @param expires Set the date after the ingested file may be removed from the database (defaults to default expiration period)
     * @param encoding Optionally provide character encoding
     * @param contentType Optionally provide file content type
     * @return Preview
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec ingestRequestCreation(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        Object postBody = null;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling ingest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter '_file' is set
        if (_file == null) {
            throw new WebClientResponseException("Missing the required parameter '_file' when calling ingest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        if (expires != null)
            formParams.add("expires", expires);
        if (encoding != null)
            formParams.add("encoding", encoding);
        if (contentType != null)
            formParams.add("contentType", contentType);
        if (_file != null)
            formParams.add("file", new FileSystemResource(_file));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "multipart/form-data"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return apiClient.invokeAPI("/api/v0/preview/ingest/{uuid}", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Ingest a new dataset
     * Ingests Excel, CSV or TSV files for preview
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The overview of the parsed dataset
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param _file The file to ingest into the database
     * @param expires Set the date after the ingested file may be removed from the database (defaults to default expiration period)
     * @param encoding Optionally provide character encoding
     * @param contentType Optionally provide file content type
     * @return Preview
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Preview> ingest(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return ingestRequestCreation(uuid, _file, expires, encoding, contentType).bodyToMono(localVarReturnType);
    }

    /**
     * Ingest a new dataset
     * Ingests Excel, CSV or TSV files for preview
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The overview of the parsed dataset
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param _file The file to ingest into the database
     * @param expires Set the date after the ingested file may be removed from the database (defaults to default expiration period)
     * @param encoding Optionally provide character encoding
     * @param contentType Optionally provide file content type
     * @return ResponseEntity&lt;Preview&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Preview>> ingestWithHttpInfo(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return ingestRequestCreation(uuid, _file, expires, encoding, contentType).toEntity(localVarReturnType);
    }

    /**
     * Ingest a new dataset
     * Ingests Excel, CSV or TSV files for preview
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - The overview of the parsed dataset
     * @param uuid Your reference UUID by which you can refer back to the dataset
     * @param _file The file to ingest into the database
     * @param expires Set the date after the ingested file may be removed from the database (defaults to default expiration period)
     * @param encoding Optionally provide character encoding
     * @param contentType Optionally provide file content type
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec ingestWithResponseSpec(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        return ingestRequestCreation(uuid, _file, expires, encoding, contentType);
    }
    /**
     * Generate a sheet with wide data from long data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param longToWide The longToWide parameter
     * @return Preview
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec longToWideRequestCreation(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        Object postBody = longToWide;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling longToWide", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'longToWide' is set
        if (longToWide == null) {
            throw new WebClientResponseException("Missing the required parameter 'longToWide' when calling longToWide", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return apiClient.invokeAPI("/api/v0/preview/{uuid}/pivot", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Generate a sheet with wide data from long data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param longToWide The longToWide parameter
     * @return Preview
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<Preview> longToWide(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return longToWideRequestCreation(uuid, longToWide).bodyToMono(localVarReturnType);
    }

    /**
     * Generate a sheet with wide data from long data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param longToWide The longToWide parameter
     * @return ResponseEntity&lt;Preview&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<Preview>> longToWideWithHttpInfo(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>() {};
        return longToWideRequestCreation(uuid, longToWide).toEntity(localVarReturnType);
    }

    /**
     * Generate a sheet with wide data from long data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param longToWide The longToWide parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec longToWideWithResponseSpec(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        return longToWideRequestCreation(uuid, longToWide);
    }
    /**
     * Assert that field values correspond to booleans
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateBoolRequest The validateBoolRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateBoolRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        Object postBody = validateBoolRequest;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'validateBoolRequest' is set
        if (validateBoolRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateBoolRequest' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/bool", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Assert that field values correspond to booleans
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateBoolRequest The validateBoolRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> validateBool(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateBoolRequestCreation(uuid, sheet, startRow, validateBoolRequest).bodyToFlux(localVarReturnType);
    }

    /**
     * Assert that field values correspond to booleans
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateBoolRequest The validateBoolRequest parameter
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> validateBoolWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateBoolRequestCreation(uuid, sheet, startRow, validateBoolRequest).toEntityList(localVarReturnType);
    }

    /**
     * Assert that field values correspond to booleans
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateBoolRequest The validateBoolRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec validateBoolWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        return validateBoolRequestCreation(uuid, sheet, startRow, validateBoolRequest);
    }
    /**
     * Assert that field values correspond to constraints for CATEGORICAL data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateCategoricalRequest The validateCategoricalRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateCategoricalRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        Object postBody = validateCategoricalRequest;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'validateCategoricalRequest' is set
        if (validateCategoricalRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateCategoricalRequest' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/categorical", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for CATEGORICAL data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateCategoricalRequest The validateCategoricalRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> validateCategorical(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateCategoricalRequestCreation(uuid, sheet, startRow, validateCategoricalRequest).bodyToFlux(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for CATEGORICAL data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateCategoricalRequest The validateCategoricalRequest parameter
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> validateCategoricalWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateCategoricalRequestCreation(uuid, sheet, startRow, validateCategoricalRequest).toEntityList(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for CATEGORICAL data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateCategoricalRequest The validateCategoricalRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec validateCategoricalWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        return validateCategoricalRequestCreation(uuid, sheet, startRow, validateCategoricalRequest);
    }
    /**
     * Assert that field values correspond to constraints for date
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateDateRequest The validateDateRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateDateRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        Object postBody = validateDateRequest;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'validateDateRequest' is set
        if (validateDateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateDateRequest' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/date", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for date
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateDateRequest The validateDateRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> validateDate(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateDateRequestCreation(uuid, sheet, startRow, validateDateRequest).bodyToFlux(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for date
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateDateRequest The validateDateRequest parameter
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> validateDateWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateDateRequestCreation(uuid, sheet, startRow, validateDateRequest).toEntityList(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for date
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateDateRequest The validateDateRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec validateDateWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        return validateDateRequestCreation(uuid, sheet, startRow, validateDateRequest);
    }
    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateNumericRequest The validateNumericRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateNumericRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        Object postBody = validateNumericRequest;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'validateNumericRequest' is set
        if (validateNumericRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateNumericRequest' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/numeric", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateNumericRequest The validateNumericRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> validateNumeric(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateNumericRequestCreation(uuid, sheet, startRow, validateNumericRequest).bodyToFlux(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateNumericRequest The validateNumericRequest parameter
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> validateNumericWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateNumericRequestCreation(uuid, sheet, startRow, validateNumericRequest).toEntityList(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateNumericRequest The validateNumericRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec validateNumericWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        return validateNumericRequestCreation(uuid, sheet, startRow, validateNumericRequest);
    }
    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateTextRequest The validateTextRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    private ResponseSpec validateTextRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        Object postBody = validateTextRequest;
        // verify the required parameter 'uuid' is set
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'sheet' is set
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'startRow' is set
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // verify the required parameter 'validateTextRequest' is set
        if (validateTextRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateTextRequest' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        // create path and map variables
        final Map<String, Object> pathParams = new HashMap<String, Object>();

        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);

        final MultiValueMap<String, String> queryParams = new LinkedMultiValueMap<String, String>();
        final HttpHeaders headerParams = new HttpHeaders();
        final MultiValueMap<String, String> cookieParams = new LinkedMultiValueMap<String, String>();
        final MultiValueMap<String, Object> formParams = new LinkedMultiValueMap<String, Object>();

        queryParams.putAll(apiClient.parameterToMultiValueMap(null, "startRow", startRow));

        final String[] localVarAccepts = { 
            "*/*"
        };
        final List<MediaType> localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        final String[] localVarContentTypes = { 
            "application/json"
        };
        final MediaType localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

        String[] localVarAuthNames = new String[] {  };

        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/text", HttpMethod.POST, pathParams, queryParams, postBody, headerParams, cookieParams, formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateTextRequest The validateTextRequest parameter
     * @return Set&lt;Object&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Flux<Object> validateText(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateTextRequestCreation(uuid, sheet, startRow, validateTextRequest).bodyToFlux(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateTextRequest The validateTextRequest parameter
     * @return ResponseEntity&lt;Set&lt;Object&gt;&gt;
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public Mono<ResponseEntity<List<Object>>> validateTextWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>() {};
        return validateTextRequestCreation(uuid, sheet, startRow, validateTextRequest).toEntityList(localVarReturnType);
    }

    /**
     * Assert that field values correspond to constraints for TEXT data
     * 
     * <p><b>404</b> - Not Found
     * <p><b>401</b> - Unauthorized
     * <p><b>400</b> - Bad Request
     * <p><b>405</b> - Method Not Allowed
     * <p><b>500</b> - Internal Server Error
     * <p><b>200</b> - OK
     * @param uuid Your reference UUID
     * @param sheet Sheet index
     * @param startRow Index of the first row
     * @param validateTextRequest The validateTextRequest parameter
     * @return ResponseSpec
     * @throws WebClientResponseException if an error occurs while attempting to invoke the API
     */
    public ResponseSpec validateTextWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        return validateTextRequestCreation(uuid, sheet, startRow, validateTextRequest);
    }
}
