/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.api;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.genesys.amphibian.client.invoker.ApiClient;
import org.genesys.amphibian.client.model.ChartData;
import org.genesys.amphibian.client.model.DatasetTable;
import org.genesys.amphibian.client.model.HeatMap;
import org.genesys.amphibian.client.model.IngestColumnRequest;
import org.genesys.amphibian.client.model.ObservationHistogram;
import org.genesys.amphibian.client.model.ObservationRegistration;
import org.genesys.amphibian.client.model.ObservationStreamResponse;
import org.genesys.amphibian.client.model.ResponsePageDTO;
import org.genesys.amphibian.client.model.TraitDataFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DatasetsApi {
    private ApiClient apiClient;

    public DatasetsApi() {
        this(new ApiClient());
    }

    @Autowired
    public DatasetsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addObservationsRequestCreation(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        ObservationRegistration postBody = observationRegistration;
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling addObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (observationRegistration == null) {
            throw new WebClientResponseException("Missing the required parameter 'observationRegistration' when calling addObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("tableKey", tableKey);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ObservationRegistration> localVarReturnType = new ParameterizedTypeReference<ObservationRegistration>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/add", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ObservationRegistration> addObservations(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationRegistration> localVarReturnType = new ParameterizedTypeReference<ObservationRegistration>(){};
        return this.addObservationsRequestCreation(tableKey, observationRegistration).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ObservationRegistration>> addObservationsWithHttpInfo(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationRegistration> localVarReturnType = new ParameterizedTypeReference<ObservationRegistration>(){};
        return this.addObservationsRequestCreation(tableKey, observationRegistration).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addObservationsWithResponseSpec(String tableKey, ObservationRegistration observationRegistration) throws WebClientResponseException {
        return this.addObservationsRequestCreation(tableKey, observationRegistration);
    }

    private WebClient.ResponseSpec createTableRequestCreation(DatasetTable datasetTable) throws WebClientResponseException {
        DatasetTable postBody = datasetTable;
        if (datasetTable == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetTable' when calling createTable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/create", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DatasetTable> createTable(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.createTableRequestCreation(datasetTable).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DatasetTable>> createTableWithHttpInfo(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.createTableRequestCreation(datasetTable).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec createTableWithResponseSpec(DatasetTable datasetTable) throws WebClientResponseException {
        return this.createTableRequestCreation(datasetTable);
    }

    private WebClient.ResponseSpec dropTableRequestCreation(DatasetTable datasetTable) throws WebClientResponseException {
        DatasetTable postBody = datasetTable;
        if (datasetTable == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetTable' when calling dropTable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/drop", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DatasetTable> dropTable(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.dropTableRequestCreation(datasetTable).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DatasetTable>> dropTableWithHttpInfo(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.dropTableRequestCreation(datasetTable).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec dropTableWithResponseSpec(DatasetTable datasetTable) throws WebClientResponseException {
        return this.dropTableRequestCreation(datasetTable);
    }

    private WebClient.ResponseSpec getAccessionChartsRequestCreation(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        TraitDataFilter postBody = traitDataFilter;
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getAccessionCharts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (fields == null) {
            throw new WebClientResponseException("Missing the required parameter 'fields' when calling getAccessionCharts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (traitDataFilter == null) {
            throw new WebClientResponseException("Missing the required parameter 'traitDataFilter' when calling getAccessionCharts", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ChartData> localVarReturnType = new ParameterizedTypeReference<ChartData>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/data/charts", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ChartData> getAccessionCharts(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ChartData> localVarReturnType = new ParameterizedTypeReference<ChartData>(){};
        return this.getAccessionChartsRequestCreation(tableKeys, fields, traitDataFilter).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ChartData>>> getAccessionChartsWithHttpInfo(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ChartData> localVarReturnType = new ParameterizedTypeReference<ChartData>(){};
        return this.getAccessionChartsRequestCreation(tableKeys, fields, traitDataFilter).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAccessionChartsWithResponseSpec(List<String> tableKeys, List<UUID> fields, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return this.getAccessionChartsRequestCreation(tableKeys, fields, traitDataFilter);
    }

    private WebClient.ResponseSpec getAccessionDatasetObservationsRequestCreation(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        TraitDataFilter postBody = traitDataFilter;
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getAccessionDatasetObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (traitDataFilter == null) {
            throw new WebClientResponseException("Missing the required parameter 'traitDataFilter' when calling getAccessionDatasetObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "p", p));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "l", l));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/data", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ResponsePageDTO> getAccessionDatasetObservations(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>(){};
        return this.getAccessionDatasetObservationsRequestCreation(tableKeys, traitDataFilter, fields, p, l).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ResponsePageDTO>> getAccessionDatasetObservationsWithHttpInfo(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>(){};
        return this.getAccessionDatasetObservationsRequestCreation(tableKeys, traitDataFilter, fields, p, l).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAccessionDatasetObservationsWithResponseSpec(List<String> tableKeys, TraitDataFilter traitDataFilter, List<UUID> fields, Integer p, Integer l) throws WebClientResponseException {
        return this.getAccessionDatasetObservationsRequestCreation(tableKeys, traitDataFilter, fields, p, l);
    }

    private WebClient.ResponseSpec getAccessionsHeatMapDataRequestCreation(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        TraitDataFilter postBody = traitDataFilter;
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getAccessionsHeatMapData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (xCategory == null) {
            throw new WebClientResponseException("Missing the required parameter 'xCategory' when calling getAccessionsHeatMapData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (yCategory == null) {
            throw new WebClientResponseException("Missing the required parameter 'yCategory' when calling getAccessionsHeatMapData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "xCategory", xCategory));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "yCategory", yCategory));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<HeatMap> localVarReturnType = new ParameterizedTypeReference<HeatMap>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/data/heatmap", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<HeatMap> getAccessionsHeatMapData(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<HeatMap> localVarReturnType = new ParameterizedTypeReference<HeatMap>(){};
        return this.getAccessionsHeatMapDataRequestCreation(tableKeys, xCategory, yCategory, traitDataFilter).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<HeatMap>> getAccessionsHeatMapDataWithHttpInfo(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<HeatMap> localVarReturnType = new ParameterizedTypeReference<HeatMap>(){};
        return this.getAccessionsHeatMapDataRequestCreation(tableKeys, xCategory, yCategory, traitDataFilter).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getAccessionsHeatMapDataWithResponseSpec(List<String> tableKeys, UUID xCategory, UUID yCategory, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return this.getAccessionsHeatMapDataRequestCreation(tableKeys, xCategory, yCategory, traitDataFilter);
    }

    private WebClient.ResponseSpec getDatasetRequestCreation(String tableKey) throws WebClientResponseException {
        Object postBody = null;
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling getDataset", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("tableKey", tableKey);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DatasetTable> getDataset(String tableKey) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.getDatasetRequestCreation(tableKey).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DatasetTable>> getDatasetWithHttpInfo(String tableKey) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.getDatasetRequestCreation(tableKey).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getDatasetWithResponseSpec(String tableKey) throws WebClientResponseException {
        return this.getDatasetRequestCreation(tableKey);
    }

    private WebClient.ResponseSpec getDatasetsRequestCreation(List<String> requestBody) throws WebClientResponseException {
        List<String> postBody = requestBody;
        if (requestBody == null) {
            throw new WebClientResponseException("Missing the required parameter 'requestBody' when calling getDatasets", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/list", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<DatasetTable> getDatasets(List<String> requestBody) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.getDatasetsRequestCreation(requestBody).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<DatasetTable>>> getDatasetsWithHttpInfo(List<String> requestBody) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.getDatasetsRequestCreation(requestBody).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getDatasetsWithResponseSpec(List<String> requestBody) throws WebClientResponseException {
        return this.getDatasetsRequestCreation(requestBody);
    }

    private WebClient.ResponseSpec getObservationsRequestCreation(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        TraitDataFilter postBody = traitDataFilter;
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling getObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("tableKey", tableKey);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "p", p));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "l", l));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ResponsePageDTO> getObservations(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>(){};
        return this.getObservationsRequestCreation(tableKey, fields, p, l, traitDataFilter).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ResponsePageDTO>> getObservationsWithHttpInfo(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ResponsePageDTO> localVarReturnType = new ParameterizedTypeReference<ResponsePageDTO>(){};
        return this.getObservationsRequestCreation(tableKey, fields, p, l, traitDataFilter).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getObservationsWithResponseSpec(String tableKey, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return this.getObservationsRequestCreation(tableKey, fields, p, l, traitDataFilter);
    }

    private WebClient.ResponseSpec getObservationsHistogramsRequestCreation(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        TraitDataFilter postBody = traitDataFilter;
        if (tableKeys == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKeys' when calling getObservationsHistograms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (fields == null) {
            throw new WebClientResponseException("Missing the required parameter 'fields' when calling getObservationsHistograms", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "tableKeys", tableKeys));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bins", bins));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ObservationHistogram> localVarReturnType = new ParameterizedTypeReference<ObservationHistogram>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/data/histograms", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<ObservationHistogram> getObservationsHistograms(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationHistogram> localVarReturnType = new ParameterizedTypeReference<ObservationHistogram>(){};
        return this.getObservationsHistogramsRequestCreation(tableKeys, fields, bins, traitDataFilter).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<ObservationHistogram>>> getObservationsHistogramsWithHttpInfo(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationHistogram> localVarReturnType = new ParameterizedTypeReference<ObservationHistogram>(){};
        return this.getObservationsHistogramsRequestCreation(tableKeys, fields, bins, traitDataFilter).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getObservationsHistogramsWithResponseSpec(List<String> tableKeys, List<UUID> fields, Integer bins, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return this.getObservationsHistogramsRequestCreation(tableKeys, fields, bins, traitDataFilter);
    }

    private WebClient.ResponseSpec ingestFromPreviewRequestCreation(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        IngestColumnRequest postBody = ingestColumnRequest;
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (descriptorUuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'descriptorUuid' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (previewUuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'previewUuid' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (ingestColumnRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'ingestColumnRequest' when calling ingestFromPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("tableKey", tableKey);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "previewUuid", previewUuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "sheet", sheet));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/ingest", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> ingestFromPreview(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.ingestFromPreviewRequestCreation(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> ingestFromPreviewWithHttpInfo(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.ingestFromPreviewRequestCreation(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec ingestFromPreviewWithResponseSpec(String tableKey, UUID descriptorUuid, UUID previewUuid, Integer sheet, Long startRow, IngestColumnRequest ingestColumnRequest) throws WebClientResponseException {
        return this.ingestFromPreviewRequestCreation(tableKey, descriptorUuid, previewUuid, sheet, startRow, ingestColumnRequest);
    }

    private WebClient.ResponseSpec removeDescriptorDataRequestCreation(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        Object postBody = null;
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling removeDescriptorData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (descriptorUuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'descriptorUuid' when calling removeDescriptorData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("tableKey", tableKey);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "descriptorUuid", descriptorUuid));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DatasetTable> removeDescriptorData(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.removeDescriptorDataRequestCreation(tableKey, descriptorUuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DatasetTable>> removeDescriptorDataWithHttpInfo(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.removeDescriptorDataRequestCreation(tableKey, descriptorUuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec removeDescriptorDataWithResponseSpec(String tableKey, UUID descriptorUuid) throws WebClientResponseException {
        return this.removeDescriptorDataRequestCreation(tableKey, descriptorUuid);
    }

    private WebClient.ResponseSpec streamObservationsRequestCreation(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        TraitDataFilter postBody = traitDataFilter;
        if (tableKey == null) {
            throw new WebClientResponseException("Missing the required parameter 'tableKey' when calling streamObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (batchSize == null) {
            throw new WebClientResponseException("Missing the required parameter 'batchSize' when calling streamObservations", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("tableKey", tableKey);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "batchSize", batchSize));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "streamUuid", streamUuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "p", p));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "l", l));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<ObservationStreamResponse> localVarReturnType = new ParameterizedTypeReference<ObservationStreamResponse>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/{tableKey}/data/stream", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<ObservationStreamResponse> streamObservations(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationStreamResponse> localVarReturnType = new ParameterizedTypeReference<ObservationStreamResponse>(){};
        return this.streamObservationsRequestCreation(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<ObservationStreamResponse>> streamObservationsWithHttpInfo(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<ObservationStreamResponse> localVarReturnType = new ParameterizedTypeReference<ObservationStreamResponse>(){};
        return this.streamObservationsRequestCreation(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec streamObservationsWithResponseSpec(String tableKey, Integer batchSize, UUID streamUuid, List<UUID> fields, Integer p, Integer l, TraitDataFilter traitDataFilter) throws WebClientResponseException {
        return this.streamObservationsRequestCreation(tableKey, batchSize, streamUuid, fields, p, l, traitDataFilter);
    }

    private WebClient.ResponseSpec updateTableRequestCreation(DatasetTable datasetTable) throws WebClientResponseException {
        DatasetTable postBody = datasetTable;
        if (datasetTable == null) {
            throw new WebClientResponseException("Missing the required parameter 'datasetTable' when calling updateTable", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.apiClient.invokeAPI("/api/v0/datasets/update", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<DatasetTable> updateTable(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.updateTableRequestCreation(datasetTable).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<DatasetTable>> updateTableWithHttpInfo(DatasetTable datasetTable) throws WebClientResponseException {
        ParameterizedTypeReference<DatasetTable> localVarReturnType = new ParameterizedTypeReference<DatasetTable>(){};
        return this.updateTableRequestCreation(datasetTable).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec updateTableWithResponseSpec(DatasetTable datasetTable) throws WebClientResponseException {
        return this.updateTableRequestCreation(datasetTable);
    }
}

