/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.api;

import java.io.File;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.genesys.amphibian.client.invoker.ApiClient;
import org.genesys.amphibian.client.model.LongToWide;
import org.genesys.amphibian.client.model.Preview;
import org.genesys.amphibian.client.model.PreviewDataFilter;
import org.genesys.amphibian.client.model.RowMetadata;
import org.genesys.amphibian.client.model.StatisticsData;
import org.genesys.amphibian.client.model.ValidateBoolRequest;
import org.genesys.amphibian.client.model.ValidateCategoricalRequest;
import org.genesys.amphibian.client.model.ValidateDateRequest;
import org.genesys.amphibian.client.model.ValidateNumericRequest;
import org.genesys.amphibian.client.model.ValidateTextRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PreviewApi {
    private ApiClient apiClient;

    public PreviewApi() {
        this(new ApiClient());
    }

    @Autowired
    public PreviewApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec addMetadataRequestCreation(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        List<RowMetadata> postBody = rowMetadata;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling addMetadata", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (rowMetadata == null) {
            throw new WebClientResponseException("Missing the required parameter 'rowMetadata' when calling addMetadata", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Long> localVarReturnType = new ParameterizedTypeReference<Long>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/meta", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Long> addMetadata(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        ParameterizedTypeReference<Long> localVarReturnType = new ParameterizedTypeReference<Long>(){};
        return this.addMetadataRequestCreation(uuid, rowMetadata).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Long>> addMetadataWithHttpInfo(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        ParameterizedTypeReference<Long> localVarReturnType = new ParameterizedTypeReference<Long>(){};
        return this.addMetadataRequestCreation(uuid, rowMetadata).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec addMetadataWithResponseSpec(UUID uuid, List<RowMetadata> rowMetadata) throws WebClientResponseException {
        return this.addMetadataRequestCreation(uuid, rowMetadata);
    }

    private WebClient.ResponseSpec deletePreviewRequestCreation(UUID uuid) throws WebClientResponseException {
        Object postBody = null;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling deletePreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.DELETE, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> deletePreview(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.deletePreviewRequestCreation(uuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> deletePreviewWithHttpInfo(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.deletePreviewRequestCreation(uuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec deletePreviewWithResponseSpec(UUID uuid) throws WebClientResponseException {
        return this.deletePreviewRequestCreation(uuid);
    }

    private WebClient.ResponseSpec generateDescriptorsRequestCreation(UUID uuid) throws WebClientResponseException {
        Object postBody = null;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling generateDescriptors", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/generate-descriptors", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Void> generateDescriptors(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.generateDescriptorsRequestCreation(uuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Void>> generateDescriptorsWithHttpInfo(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Void> localVarReturnType = new ParameterizedTypeReference<Void>(){};
        return this.generateDescriptorsRequestCreation(uuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec generateDescriptorsWithResponseSpec(UUID uuid) throws WebClientResponseException {
        return this.generateDescriptorsRequestCreation(uuid);
    }

    private WebClient.ResponseSpec getDataRequestCreation(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        PreviewDataFilter postBody = previewDataFilter;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling getData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling getData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling getData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        pathParams.put("startRow", startRow);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/{sheet}/{startRow}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> getData(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.getDataRequestCreation(uuid, sheet, startRow, limit, fields, previewDataFilter).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> getDataWithHttpInfo(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.getDataRequestCreation(uuid, sheet, startRow, limit, fields, previewDataFilter).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getDataWithResponseSpec(UUID uuid, Integer sheet, Long startRow, Integer limit, List<String> fields, PreviewDataFilter previewDataFilter) throws WebClientResponseException {
        return this.getDataRequestCreation(uuid, sheet, startRow, limit, fields, previewDataFilter);
    }

    private WebClient.ResponseSpec getPreviewRequestCreation(UUID uuid) throws WebClientResponseException {
        Object postBody = null;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling getPreview", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Preview> getPreview(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.getPreviewRequestCreation(uuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Preview>> getPreviewWithHttpInfo(UUID uuid) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.getPreviewRequestCreation(uuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getPreviewWithResponseSpec(UUID uuid) throws WebClientResponseException {
        return this.getPreviewRequestCreation(uuid);
    }

    private WebClient.ResponseSpec getStatisticsDataRequestCreation(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        Object postBody = null;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (fields == null) {
            throw new WebClientResponseException("Missing the required parameter 'fields' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (limit == null) {
            throw new WebClientResponseException("Missing the required parameter 'limit' when calling getStatisticsData", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        pathParams.put("startRow", startRow);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(ApiClient.CollectionFormat.valueOf("multi".toUpperCase(Locale.ROOT)), "fields", fields));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "limit", limit));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<StatisticsData> localVarReturnType = new ParameterizedTypeReference<StatisticsData>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/stats/{uuid}/{sheet}/{startRow}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<StatisticsData> getStatisticsData(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<StatisticsData> localVarReturnType = new ParameterizedTypeReference<StatisticsData>(){};
        return this.getStatisticsDataRequestCreation(uuid, sheet, fields, startRow, limit).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<StatisticsData>>> getStatisticsDataWithHttpInfo(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        ParameterizedTypeReference<StatisticsData> localVarReturnType = new ParameterizedTypeReference<StatisticsData>(){};
        return this.getStatisticsDataRequestCreation(uuid, sheet, fields, startRow, limit).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec getStatisticsDataWithResponseSpec(UUID uuid, Integer sheet, List<String> fields, Long startRow, Integer limit) throws WebClientResponseException {
        return this.getStatisticsDataRequestCreation(uuid, sheet, fields, startRow, limit);
    }

    private WebClient.ResponseSpec ingestRequestCreation(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        Object postBody = null;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling ingest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (_file == null) {
            throw new WebClientResponseException("Missing the required parameter '_file' when calling ingest", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        if (expires != null) {
            formParams.add((Object)"expires", (Object)expires);
        }
        if (encoding != null) {
            formParams.add((Object)"encoding", (Object)encoding);
        }
        if (contentType != null) {
            formParams.add((Object)"contentType", (Object)contentType);
        }
        if (_file != null) {
            formParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/ingest/{uuid}", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Preview> ingest(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.ingestRequestCreation(uuid, _file, expires, encoding, contentType).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Preview>> ingestWithHttpInfo(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.ingestRequestCreation(uuid, _file, expires, encoding, contentType).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec ingestWithResponseSpec(UUID uuid, File _file, OffsetDateTime expires, String encoding, String contentType) throws WebClientResponseException {
        return this.ingestRequestCreation(uuid, _file, expires, encoding, contentType);
    }

    private WebClient.ResponseSpec longToWideRequestCreation(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        LongToWide postBody = longToWide;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling longToWide", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (longToWide == null) {
            throw new WebClientResponseException("Missing the required parameter 'longToWide' when calling longToWide", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/{uuid}/pivot", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<Preview> longToWide(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.longToWideRequestCreation(uuid, longToWide).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<Preview>> longToWideWithHttpInfo(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        ParameterizedTypeReference<Preview> localVarReturnType = new ParameterizedTypeReference<Preview>(){};
        return this.longToWideRequestCreation(uuid, longToWide).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec longToWideWithResponseSpec(UUID uuid, LongToWide longToWide) throws WebClientResponseException {
        return this.longToWideRequestCreation(uuid, longToWide);
    }

    private WebClient.ResponseSpec validateBoolRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        ValidateBoolRequest postBody = validateBoolRequest;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (validateBoolRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateBoolRequest' when calling validateBool", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/bool", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> validateBool(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateBoolRequestCreation(uuid, sheet, startRow, validateBoolRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> validateBoolWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateBoolRequestCreation(uuid, sheet, startRow, validateBoolRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec validateBoolWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateBoolRequest validateBoolRequest) throws WebClientResponseException {
        return this.validateBoolRequestCreation(uuid, sheet, startRow, validateBoolRequest);
    }

    private WebClient.ResponseSpec validateCategoricalRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        ValidateCategoricalRequest postBody = validateCategoricalRequest;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (validateCategoricalRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateCategoricalRequest' when calling validateCategorical", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/categorical", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> validateCategorical(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateCategoricalRequestCreation(uuid, sheet, startRow, validateCategoricalRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> validateCategoricalWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateCategoricalRequestCreation(uuid, sheet, startRow, validateCategoricalRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec validateCategoricalWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateCategoricalRequest validateCategoricalRequest) throws WebClientResponseException {
        return this.validateCategoricalRequestCreation(uuid, sheet, startRow, validateCategoricalRequest);
    }

    private WebClient.ResponseSpec validateDateRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        ValidateDateRequest postBody = validateDateRequest;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (validateDateRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateDateRequest' when calling validateDate", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/date", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> validateDate(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateDateRequestCreation(uuid, sheet, startRow, validateDateRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> validateDateWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateDateRequestCreation(uuid, sheet, startRow, validateDateRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec validateDateWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateDateRequest validateDateRequest) throws WebClientResponseException {
        return this.validateDateRequestCreation(uuid, sheet, startRow, validateDateRequest);
    }

    private WebClient.ResponseSpec validateNumericRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        ValidateNumericRequest postBody = validateNumericRequest;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (validateNumericRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateNumericRequest' when calling validateNumeric", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/numeric", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> validateNumeric(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateNumericRequestCreation(uuid, sheet, startRow, validateNumericRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> validateNumericWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateNumericRequestCreation(uuid, sheet, startRow, validateNumericRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec validateNumericWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateNumericRequest validateNumericRequest) throws WebClientResponseException {
        return this.validateNumericRequestCreation(uuid, sheet, startRow, validateNumericRequest);
    }

    private WebClient.ResponseSpec validateTextRequestCreation(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        ValidateTextRequest postBody = validateTextRequest;
        if (uuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'uuid' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (sheet == null) {
            throw new WebClientResponseException("Missing the required parameter 'sheet' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (startRow == null) {
            throw new WebClientResponseException("Missing the required parameter 'startRow' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        if (validateTextRequest == null) {
            throw new WebClientResponseException("Missing the required parameter 'validateTextRequest' when calling validateText", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("uuid", uuid);
        pathParams.put("sheet", sheet);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "startRow", startRow));
        String[] localVarAccepts = new String[]{"*/*"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.apiClient.invokeAPI("/api/v0/preview/validate/{uuid}/{sheet}/text", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Flux<Object> validateText(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateTextRequestCreation(uuid, sheet, startRow, validateTextRequest).bodyToFlux((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<List<Object>>> validateTextWithHttpInfo(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        ParameterizedTypeReference<Object> localVarReturnType = new ParameterizedTypeReference<Object>(){};
        return this.validateTextRequestCreation(uuid, sheet, startRow, validateTextRequest).toEntityList((ParameterizedTypeReference)localVarReturnType);
    }

    public WebClient.ResponseSpec validateTextWithResponseSpec(UUID uuid, Integer sheet, Long startRow, ValidateTextRequest validateTextRequest) throws WebClientResponseException {
        return this.validateTextRequestCreation(uuid, sheet, startRow, validateTextRequest);
    }
}

