/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.genesys.amphibian.client.model.DataSource;

@JsonPropertyOrder(value={"state", "sources", "descriptorSources"})
public class DatasetTableExtras {
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_SOURCES = "sources";
    private Map<String, Map<String, DataSource>> sources = new HashMap<String, Map<String, DataSource>>();
    public static final String JSON_PROPERTY_DESCRIPTOR_SOURCES = "descriptorSources";
    private Map<String, Set<UUID>> descriptorSources = new HashMap<String, Set<UUID>>();

    public DatasetTableExtras state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public DatasetTableExtras sources(Map<String, Map<String, DataSource>> sources) {
        this.sources = sources;
        return this;
    }

    public DatasetTableExtras putSourcesItem(String key, Map<String, DataSource> sourcesItem) {
        if (this.sources == null) {
            this.sources = new HashMap<String, Map<String, DataSource>>();
        }
        this.sources.put(key, sourcesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Map<String, DataSource>> getSources() {
        return this.sources;
    }

    @JsonProperty(value="sources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSources(Map<String, Map<String, DataSource>> sources) {
        this.sources = sources;
    }

    public DatasetTableExtras descriptorSources(Map<String, Set<UUID>> descriptorSources) {
        this.descriptorSources = descriptorSources;
        return this;
    }

    public DatasetTableExtras putDescriptorSourcesItem(String key, Set<UUID> descriptorSourcesItem) {
        if (this.descriptorSources == null) {
            this.descriptorSources = new HashMap<String, Set<UUID>>();
        }
        this.descriptorSources.put(key, descriptorSourcesItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="descriptorSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Set<UUID>> getDescriptorSources() {
        return this.descriptorSources;
    }

    @JsonProperty(value="descriptorSources")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescriptorSources(Map<String, Set<UUID>> descriptorSources) {
        this.descriptorSources = descriptorSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatasetTableExtras datasetTableExtras = (DatasetTableExtras)o;
        return Objects.equals((Object)this.state, (Object)datasetTableExtras.state) && Objects.equals(this.sources, datasetTableExtras.sources) && Objects.equals(this.descriptorSources, datasetTableExtras.descriptorSources);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.state, this.sources, this.descriptorSources});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DatasetTableExtras {\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    sources: ").append(this.toIndentedString(this.sources)).append("\n");
        sb.append("    descriptorSources: ").append(this.toIndentedString(this.descriptorSources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        DRAFT("DRAFT"),
        READY("READY"),
        BUSY("BUSY");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

