/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.genesys.amphibian.client.model.ValueMapping;

@JsonPropertyOrder(value={"field", "arraySeparator", "valueMapping", "targetType"})
public class IngestColumnRequest {
    public static final String JSON_PROPERTY_FIELD = "field";
    private String field;
    public static final String JSON_PROPERTY_ARRAY_SEPARATOR = "arraySeparator";
    private String arraySeparator;
    public static final String JSON_PROPERTY_VALUE_MAPPING = "valueMapping";
    private List<ValueMapping> valueMapping;
    public static final String JSON_PROPERTY_TARGET_TYPE = "targetType";
    private TargetTypeEnum targetType;

    public IngestColumnRequest field(String field) {
        this.field = field;
        return this;
    }

    @Nonnull
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setField(String field) {
        this.field = field;
    }

    public IngestColumnRequest arraySeparator(String arraySeparator) {
        this.arraySeparator = arraySeparator;
        return this;
    }

    @Nullable
    @JsonProperty(value="arraySeparator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getArraySeparator() {
        return this.arraySeparator;
    }

    @JsonProperty(value="arraySeparator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setArraySeparator(String arraySeparator) {
        this.arraySeparator = arraySeparator;
    }

    public IngestColumnRequest valueMapping(List<ValueMapping> valueMapping) {
        this.valueMapping = valueMapping;
        return this;
    }

    public IngestColumnRequest addValueMappingItem(ValueMapping valueMappingItem) {
        if (this.valueMapping == null) {
            this.valueMapping = new ArrayList<ValueMapping>();
        }
        this.valueMapping.add(valueMappingItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="valueMapping")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ValueMapping> getValueMapping() {
        return this.valueMapping;
    }

    @JsonProperty(value="valueMapping")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValueMapping(List<ValueMapping> valueMapping) {
        this.valueMapping = valueMapping;
    }

    public IngestColumnRequest targetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
        return this;
    }

    @Nonnull
    @JsonProperty(value="targetType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TargetTypeEnum getTargetType() {
        return this.targetType;
    }

    @JsonProperty(value="targetType")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTargetType(TargetTypeEnum targetType) {
        this.targetType = targetType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IngestColumnRequest ingestColumnRequest = (IngestColumnRequest)o;
        return Objects.equals(this.field, ingestColumnRequest.field) && Objects.equals(this.arraySeparator, ingestColumnRequest.arraySeparator) && Objects.equals(this.valueMapping, ingestColumnRequest.valueMapping) && Objects.equals((Object)this.targetType, (Object)ingestColumnRequest.targetType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.arraySeparator, this.valueMapping, this.targetType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IngestColumnRequest {\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    arraySeparator: ").append(this.toIndentedString(this.arraySeparator)).append("\n");
        sb.append("    valueMapping: ").append(this.toIndentedString(this.valueMapping)).append("\n");
        sb.append("    targetType: ").append(this.toIndentedString((Object)this.targetType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TargetTypeEnum {
        STRING("STRING"),
        INTEGER("INTEGER"),
        DECIMAL("DECIMAL"),
        DATE("DATE"),
        BOOLEAN("BOOLEAN");

        private String value;

        private TargetTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TargetTypeEnum fromValue(String value) {
            for (TargetTypeEnum b : TargetTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

