/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.genesys.amphibian.client.model.PreviewSheet;

@JsonPropertyOrder(value={"id", "version", "state", "error", "name", "referenceUuid", "sheets", "contentLength", "expires", "createdDate", "modifiedDate"})
public class Preview {
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_VERSION = "version";
    private Long version;
    public static final String JSON_PROPERTY_STATE = "state";
    private StateEnum state;
    public static final String JSON_PROPERTY_ERROR = "error";
    private String error;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_REFERENCE_UUID = "referenceUuid";
    private UUID referenceUuid;
    public static final String JSON_PROPERTY_SHEETS = "sheets";
    private List<PreviewSheet> sheets;
    public static final String JSON_PROPERTY_CONTENT_LENGTH = "contentLength";
    private Long contentLength;
    public static final String JSON_PROPERTY_EXPIRES = "expires";
    private OffsetDateTime expires;
    public static final String JSON_PROPERTY_CREATED_DATE = "createdDate";
    private OffsetDateTime createdDate;
    public static final String JSON_PROPERTY_MODIFIED_DATE = "modifiedDate";
    private OffsetDateTime modifiedDate;

    public Preview id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public Preview version(Long version) {
        this.version = version;
        return this;
    }

    @Nullable
    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVersion(Long version) {
        this.version = version;
    }

    public Preview state(StateEnum state) {
        this.state = state;
        return this;
    }

    @Nullable
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public StateEnum getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(StateEnum state) {
        this.state = state;
    }

    public Preview error(String error) {
        this.error = error;
        return this;
    }

    @Nullable
    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getError() {
        return this.error;
    }

    @JsonProperty(value="error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setError(String error) {
        this.error = error;
    }

    public Preview name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public Preview referenceUuid(UUID referenceUuid) {
        this.referenceUuid = referenceUuid;
        return this;
    }

    @Nullable
    @JsonProperty(value="referenceUuid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UUID getReferenceUuid() {
        return this.referenceUuid;
    }

    @JsonProperty(value="referenceUuid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceUuid(UUID referenceUuid) {
        this.referenceUuid = referenceUuid;
    }

    public Preview sheets(List<PreviewSheet> sheets) {
        this.sheets = sheets;
        return this;
    }

    public Preview addSheetsItem(PreviewSheet sheetsItem) {
        if (this.sheets == null) {
            this.sheets = new ArrayList<PreviewSheet>();
        }
        this.sheets.add(sheetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="sheets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<PreviewSheet> getSheets() {
        return this.sheets;
    }

    @JsonProperty(value="sheets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSheets(List<PreviewSheet> sheets) {
        this.sheets = sheets;
    }

    public Preview contentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    @Nullable
    @JsonProperty(value="contentLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Long getContentLength() {
        return this.contentLength;
    }

    @JsonProperty(value="contentLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentLength(Long contentLength) {
        this.contentLength = contentLength;
    }

    public Preview expires(OffsetDateTime expires) {
        this.expires = expires;
        return this;
    }

    @Nullable
    @JsonProperty(value="expires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpires() {
        return this.expires;
    }

    @JsonProperty(value="expires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpires(OffsetDateTime expires) {
        this.expires = expires;
    }

    public Preview createdDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    @JsonProperty(value="createdDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Preview modifiedDate(OffsetDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
        return this;
    }

    @Nullable
    @JsonProperty(value="modifiedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getModifiedDate() {
        return this.modifiedDate;
    }

    @JsonProperty(value="modifiedDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModifiedDate(OffsetDateTime modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preview preview = (Preview)o;
        return Objects.equals(this.id, preview.id) && Objects.equals(this.version, preview.version) && Objects.equals((Object)this.state, (Object)preview.state) && Objects.equals(this.error, preview.error) && Objects.equals(this.name, preview.name) && Objects.equals(this.referenceUuid, preview.referenceUuid) && Objects.equals(this.sheets, preview.sheets) && Objects.equals(this.contentLength, preview.contentLength) && Objects.equals(this.expires, preview.expires) && Objects.equals(this.createdDate, preview.createdDate) && Objects.equals(this.modifiedDate, preview.modifiedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.version, this.state, this.error, this.name, this.referenceUuid, this.sheets, this.contentLength, this.expires, this.createdDate, this.modifiedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Preview {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    referenceUuid: ").append(this.toIndentedString(this.referenceUuid)).append("\n");
        sb.append("    sheets: ").append(this.toIndentedString(this.sheets)).append("\n");
        sb.append("    contentLength: ").append(this.toIndentedString(this.contentLength)).append("\n");
        sb.append("    expires: ").append(this.toIndentedString(this.expires)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    modifiedDate: ").append(this.toIndentedString(this.modifiedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum StateEnum {
        UPLOADED("UPLOADED"),
        READING("READING"),
        READY("READY"),
        FAILED("FAILED");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

