/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.amphibian.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import org.genesys.amphibian.client.model.FieldFilter;

@JsonPropertyOrder(value={"accession", "observations"})
public class TraitDataFilter {
    public static final String JSON_PROPERTY_ACCESSION = "accession";
    private List<UUID> accession;
    public static final String JSON_PROPERTY_OBSERVATIONS = "observations";
    private Map<String, FieldFilter> observations = new HashMap<String, FieldFilter>();

    public TraitDataFilter accession(List<UUID> accession) {
        this.accession = accession;
        return this;
    }

    public TraitDataFilter addAccessionItem(UUID accessionItem) {
        if (this.accession == null) {
            this.accession = new ArrayList<UUID>();
        }
        this.accession.add(accessionItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="accession")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<UUID> getAccession() {
        return this.accession;
    }

    @JsonProperty(value="accession")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccession(List<UUID> accession) {
        this.accession = accession;
    }

    public TraitDataFilter observations(Map<String, FieldFilter> observations) {
        this.observations = observations;
        return this;
    }

    public TraitDataFilter putObservationsItem(String key, FieldFilter observationsItem) {
        if (this.observations == null) {
            this.observations = new HashMap<String, FieldFilter>();
        }
        this.observations.put(key, observationsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="observations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, FieldFilter> getObservations() {
        return this.observations;
    }

    @JsonProperty(value="observations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObservations(Map<String, FieldFilter> observations) {
        this.observations = observations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraitDataFilter traitDataFilter = (TraitDataFilter)o;
        return Objects.equals(this.accession, traitDataFilter.accession) && Objects.equals(this.observations, traitDataFilter.observations);
    }

    public int hashCode() {
        return Objects.hash(this.accession, this.observations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TraitDataFilter {\n");
        sb.append("    accession: ").append(this.toIndentedString(this.accession)).append("\n");
        sb.append("    observations: ").append(this.toIndentedString(this.observations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

