/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.genesys.filerepository.InvalidRepositoryFileDataException;
import org.genesys.filerepository.InvalidRepositoryPathException;
import org.genesys.filerepository.NoSuchRepositoryFileException;
import org.genesys.filerepository.model.RepositoryFile;
import org.genesys.filerepository.service.RepositoryService;
import org.genesys.filerepository.service.ftp.CanBeAnythingFile;
import org.genesys.filerepository.service.ftp.RepositoryFtpDirectory;
import org.genesys.filerepository.service.ftp.RepositoryFtpFile;
import org.genesys.filerepository.service.ftp.TemporaryBytesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryFileSystemFactory
implements FileSystemFactory,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(RepositoryFileSystemFactory.class);
    @Autowired(required=true)
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private TemporaryBytesManager bytesManager;

    private RepositoryFtpFile file(final RepositoryFile repositoryFile) {
        LOG.trace("Making RepositoryFtpFile repositoryFile={}", (Object)repositoryFile);
        RepositoryFtpFile rff = new RepositoryFtpFile(repositoryFile){

            @Override
            public String getOwnerName() {
                return "root";
            }

            @Override
            public String getGroupName() {
                return "wheel";
            }

            @Override
            public boolean mkdir() {
                return false;
            }

            @Override
            public boolean delete() {
                LOG.info("Delete file={}", (Object)this.getAbsolutePath());
                try {
                    RepositoryFileSystemFactory.this.repositoryService.removeFile(repositoryFile);
                    return true;
                }
                catch (IOException | NoSuchRepositoryFileException e) {
                    LOG.warn(e.getMessage());
                    return false;
                }
            }

            @Override
            public boolean move(FtpFile destination) {
                LOG.info("Move file={} to dest={}", (Object)this.getAbsolutePath(), (Object)destination.getAbsolutePath());
                try {
                    RepositoryFileSystemFactory.this.repositoryService.moveAndRenameFile(repositoryFile, destination.getAbsolutePath());
                    return true;
                }
                catch (InvalidRepositoryFileDataException | InvalidRepositoryPathException e) {
                    LOG.warn("Error moving file: {}", (Object)e.getMessage());
                    return false;
                }
            }

            @Override
            public OutputStream createOutputStream(long offset) throws IOException {
                LOG.info("Creating output stream for file={} at offset={}", (Object)this.getAbsolutePath(), (Object)offset);
                return RepositoryFileSystemFactory.this.bytesManager.createOutputStream(repositoryFile, offset);
            }

            @Override
            public InputStream createInputStream(long offset) throws IOException {
                LOG.info("Creating input stream for file={} at offset={}", (Object)this.getAbsolutePath(), (Object)offset);
                return RepositoryFileSystemFactory.this.bytesManager.createInputStream(repositoryFile, offset);
            }
        };
        return rff;
    }

    private RepositoryFtpDirectory directory(String path, final RepositoryFileSystemView session) {
        LOG.trace("Making RepositoryFtpDirectory path={}", (Object)path);
        RepositoryFtpDirectory rfd = new RepositoryFtpDirectory(path){

            @Override
            public boolean move(FtpFile destination) {
                LOG.info("Move directory={} to dest={}", (Object)this.getAbsolutePath(), (Object)destination.getAbsolutePath());
                try {
                    RepositoryFileSystemFactory.this.repositoryService.renamePath(this.getAbsolutePath(), destination.getAbsolutePath());
                    return true;
                }
                catch (InvalidRepositoryPathException e) {
                    LOG.error("Failed to rename directory", (Throwable)e);
                    return false;
                }
            }

            @Override
            public boolean mkdir() {
                LOG.info("Mkdir directory={}", (Object)this.getAbsolutePath());
                return false;
            }

            @Override
            public List<? extends FtpFile> listFiles() {
                String currentPath = this.getAbsolutePath();
                LOG.debug("Listing files in path={}", (Object)currentPath);
                ArrayList all = new ArrayList();
                Path root = Paths.get(currentPath, new String[0]);
                all.addAll(RepositoryFileSystemFactory.this.repositoryService.getFiles(currentPath).stream().peek(rf -> {}).map(rf -> RepositoryFileSystemFactory.this.file(rf)).collect(Collectors.toList()));
                try {
                    all.addAll(RepositoryFileSystemFactory.this.repositoryService.listPaths(currentPath).stream().peek(path -> session2.temporaryDirs.remove(path)).filter(path -> !currentPath.equals(path)).map(path -> {
                        Path foo = Paths.get(path.substring(currentPath.length()), new String[0]);
                        LOG.trace("Sub cp=" + currentPath + " p=" + path + " x=" + foo.getName(0));
                        return foo.getName(0).toString();
                    }).distinct().map(path -> RepositoryFileSystemFactory.this.directory(path, session)).collect(Collectors.toList()));
                }
                catch (InvalidRepositoryPathException e) {
                    LOG.warn("Error listing paths for {}: {}", (Object)currentPath, (Object)e.getMessage());
                }
                all.addAll(session.temporaryDirs.stream().filter(path -> path.startsWith(currentPath) && !path.equals(currentPath)).map(path -> {
                    Path relativized = root.relativize(Paths.get(path, new String[0]));
                    LOG.trace("Rel={} rel[0]={} root.resolve={}", new Object[]{relativized.toString(), relativized.getName(0), root.resolve(relativized.getName(0)).normalize().toString()});
                    return root.resolve(relativized.getName(0)).normalize().toString();
                }).distinct().peek(p -> LOG.debug("Temporary folder={}", p)).map(path -> RepositoryFileSystemFactory.this.directory(path, session)).collect(Collectors.toList()));
                return Collections.unmodifiableList(all.stream().distinct().sorted((a, b) -> a.getName().compareTo(b.getName())).peek(path -> {}).collect(Collectors.toList()));
            }

            @Override
            public String getOwnerName() {
                return "root";
            }

            @Override
            public String getGroupName() {
                return "wheel";
            }

            @Override
            public boolean delete() {
                LOG.info("Delete this={}", (Object)this.getAbsolutePath());
                if (session.hasTempDir(this.getAbsolutePath())) {
                    session.removeTempDir(this.getAbsolutePath());
                    return true;
                }
                LOG.warn("Not deleting repository folder={}", (Object)this.getAbsolutePath());
                return false;
            }

            @Override
            public boolean changeWorkingDirectory(String dir) {
                String normalized = Paths.get(this.getAbsolutePath(), new String[0]).resolve(dir).normalize().toAbsolutePath().toString();
                LOG.info("CWD this={} dir={} normalized={}", new Object[]{this.getAbsolutePath(), dir, normalized});
                this.cwd(normalized);
                return true;
            }
        };
        return rfd;
    }

    public FileSystemView createFileSystemView(User user) throws FtpException {
        LOG.info("Creating new repository view for {}", (Object)user.getName());
        return new RepositoryFileSystemView(user){

            public FtpFile getFile(String file) throws FtpException {
                LOG.debug("getFile file={} for user={}", (Object)file, (Object)this.username);
                Path path = file.startsWith("/") ? Paths.get(file, new String[0]).normalize() : Paths.get(this.cwd.getAbsolutePath(), file).normalize();
                LOG.trace("Resolved normalized={}", (Object)path.toString());
                LOG.trace("Temporary dirs: {}", (Object)this.temporaryDirs);
                if (this.temporaryDirs.stream().filter(longpath -> longpath.startsWith(path.toString())).findFirst().isPresent()) {
                    LOG.trace("dir={} is a temporary session-bound directory", (Object)path);
                    return RepositoryFileSystemFactory.this.directory(path.toString(), this);
                }
                try {
                    return this.isDirectory(path) ? RepositoryFileSystemFactory.this.directory(path.toString(), this) : RepositoryFileSystemFactory.this.file(RepositoryFileSystemFactory.this.repositoryService.getFile(path.getParent().toString(), path.getFileName().toString()));
                }
                catch (NoSuchRepositoryFileException e) {
                    LOG.debug("Making new CanBeAnythingFile path={} name={}", (Object)path.getParent().toString(), (Object)path.getFileName().toString());
                    return new CanBeAnythingFile(path.getParent().toString(), path.getFileName().toString()){

                        @Override
                        public boolean mkdir() {
                            LOG.info("Mkdir path={}", (Object)this.getAbsolutePath());
                            temporaryDirs.add(this.getAbsolutePath());
                            return true;
                        }

                        @Override
                        public boolean delete() {
                            Set matches = temporaryDirs.stream().filter(longpath -> longpath.startsWith(this.getAbsolutePath())).collect(Collectors.toSet());
                            LOG.debug("Removing session-bound directories {}", matches);
                            temporaryDirs.removeAll(matches);
                            return true;
                        }

                        @Override
                        public OutputStream createOutputStream(long offset) throws IOException {
                            LOG.info("Creating output stream for new file={} at offset={}", (Object)this.getAbsolutePath(), (Object)offset);
                            assert (offset == 0L);
                            return RepositoryFileSystemFactory.this.bytesManager.newFile(Paths.get(this.getAbsolutePath(), new String[0]));
                        }
                    };
                }
            }

            private boolean isDirectory(Path path) {
                try {
                    return RepositoryFileSystemFactory.this.repositoryService.hasPath(path) || this.temporaryDirs.stream().filter(longpath -> longpath.equals(path.toString())).findFirst().isPresent();
                }
                catch (InvalidRepositoryPathException e) {
                    LOG.debug("Invalid repository path {}: {}", (Object)path, (Object)e.getMessage());
                    return this.temporaryDirs.stream().filter(longpath -> longpath.equals(path.toString())).findFirst().isPresent();
                }
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.repositoryService != null);
        LOG.warn("Initialized RFSF with service={}", (Object)this.repositoryService);
    }

    private abstract class RepositoryFileSystemView
    implements FileSystemView {
        protected User user;
        protected String username;
        protected RepositoryFtpDirectory cwd;
        protected RepositoryFtpDirectory homeDir;
        protected Set<String> temporaryDirs;

        public RepositoryFileSystemView(User user) {
            this.cwd = RepositoryFileSystemFactory.this.directory("/", this);
            this.homeDir = RepositoryFileSystemFactory.this.directory("/", this);
            this.temporaryDirs = new HashSet<String>();
            this.username = user.getName();
            this.user = user;
        }

        public void removeTempDir(String absolutePath) {
            Set matches = this.temporaryDirs.stream().filter(longpath -> longpath.startsWith(absolutePath)).collect(Collectors.toSet());
            LOG.debug("Removing session-bound directories {}", matches);
            this.temporaryDirs.removeAll(matches);
        }

        public boolean isRandomAccessible() throws FtpException {
            return false;
        }

        public FtpFile getWorkingDirectory() throws FtpException {
            LOG.debug("getWorkingDirectory for user={}", (Object)this.username);
            return this.cwd;
        }

        public FtpFile getHomeDirectory() throws FtpException {
            LOG.debug("getHomeDirectory for user={}", (Object)this.username);
            return this.homeDir;
        }

        public void dispose() {
            LOG.info("Disposing repository view for user={}", (Object)this.username);
        }

        public boolean changeWorkingDirectory(String dir) throws FtpException {
            LOG.debug("CWD dir={} for user={}", (Object)dir, (Object)this.username);
            return this.cwd.changeWorkingDirectory(dir);
        }

        public boolean hasTempDir(String absolutePath) {
            return this.temporaryDirs.stream().filter(longpath -> longpath.startsWith(absolutePath)).findFirst().isPresent();
        }
    }
}

