/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import org.genesys.filerepository.service.ftp.FtpUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class FtpRunAs {
    public static final Logger LOG = LoggerFactory.getLogger(FtpRunAs.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R, T extends Throwable> R asFtpUser(FtpUser ftpUser, NoArgMethod<R, T> runnable) throws T {
        Authentication prevAuth = SecurityContextHolder.getContext().getAuthentication();
        if (ftpUser != null && ftpUser.user != null) {
            LOG.trace("Switching to {}", (Object)ftpUser.user.getUsername());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken(ftpUser.user, (Object)ftpUser.getPassword(), ftpUser.user.getAuthorities()));
        }
        try {
            R r = runnable.run();
            return r;
        }
        finally {
            if (ftpUser != null && ftpUser.user != null) {
                LOG.trace("Switching back from {}", (Object)ftpUser.user.getUsername());
            }
            SecurityContextHolder.getContext().setAuthentication(prevAuth);
        }
    }

    public static interface NoArgMethod<R, T extends Throwable> {
        public R run() throws T;
    }
}

