/*
 * Copyright 2018 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.genesys.filerepository.service.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Date;
import java.util.List;

import org.apache.ftpserver.ftplet.FtpFile;

/**
 * The Class CanBeAnythingFile.
 */
public abstract class CanBeAnythingFile implements FtpFile {

	/** The parent. */
	private final Path path;
	private long date = new Date().getTime();
	
	/** The dir. */
	protected boolean dir = false;

	/**
	 * Instantiates a new can be anything file.
	 *
	 * @param parent the parent
	 * @param name the name
	 */
	public CanBeAnythingFile(final Path parent, final String name) {
		this.path = parent.resolve(name);
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getAbsolutePath()
	 */
	@Override
	public String getAbsolutePath() {
		return path.toAbsolutePath().toString();
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getName()
	 */
	@Override
	public String getName() {
		return path.getFileName().toString();
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#isHidden()
	 */
	@Override
	public boolean isHidden() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#isDirectory()
	 */
	@Override
	public boolean isDirectory() {
		return dir;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#isFile()
	 */
	@Override
	public boolean isFile() {
		return !dir;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#doesExist()
	 */
	@Override
	public boolean doesExist() {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#isReadable()
	 */
	@Override
	public boolean isReadable() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#isWritable()
	 */
	@Override
	public boolean isWritable() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#isRemovable()
	 */
	@Override
	public boolean isRemovable() {
		return true;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getOwnerName()
	 */
	@Override
	public String getOwnerName() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getGroupName()
	 */
	@Override
	public String getGroupName() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getLinkCount()
	 */
	@Override
	public int getLinkCount() {
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getLastModified()
	 */
	@Override
	public long getLastModified() {
		return date;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#setLastModified(long)
	 */
	@Override
	public boolean setLastModified(final long time) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getSize()
	 */
	@Override
	public long getSize() {
		return 0;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#getPhysicalFile()
	 */
	@Override
	public Object getPhysicalFile() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#mkdir()
	 */
	@Override
	public abstract boolean mkdir();

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#delete()
	 */
	@Override
	public abstract boolean delete();

	/*
	 * (non-Javadoc)
	 * @see
	 * org.apache.ftpserver.ftplet.FtpFile#move(org.apache.ftpserver.ftplet.FtpFile)
	 */
	@Override
	public boolean move(final FtpFile destination) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#listFiles()
	 */
	@Override
	public List<? extends FtpFile> listFiles() {
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#createOutputStream(long)
	 */
	@Override
	public abstract OutputStream createOutputStream(long offset) throws IOException;

	/*
	 * (non-Javadoc)
	 * @see org.apache.ftpserver.ftplet.FtpFile#createInputStream(long)
	 */
	@Override
	public InputStream createInputStream(final long offset) throws IOException {
		return null;
	}

}
