/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.util.Collections;
import java.util.List;
import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.ftplet.User;
import org.genesys.blocks.security.model.BasicUser;

public class FtpUser
implements User {
    private String name;
    private String password;
    private List<? extends Authority> authorities;
    private int maxIdleTime;
    private boolean enabled;
    private String homeDirectory;
    BasicUser<?> user;

    public FtpUser() {
    }

    public FtpUser(String username) {
        this.name = username;
    }

    public FtpUser(BasicUser<?> user) {
        this.user = user;
        this.setName(user.getUsername());
        this.setEnabled(user.isEnabled() && user.isAccountNonExpired() && user.isAccountNonLocked() && user.isCredentialsNonExpired());
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public List<? extends Authority> getAuthorities() {
        return Collections.unmodifiableList(this.authorities);
    }

    public List<? extends Authority> getAuthorities(Class<? extends Authority> clazz) {
        return null;
    }

    public AuthorizationRequest authorize(AuthorizationRequest request) {
        if (this.authorities == null) {
            return null;
        }
        boolean someoneCouldAuthorize = false;
        for (Authority authority : this.authorities) {
            if (!authority.canAuthorize(request)) continue;
            someoneCouldAuthorize = true;
            if ((request = authority.authorize(request)) != null) continue;
            return null;
        }
        if (someoneCouldAuthorize) {
            return request;
        }
        return null;
    }

    public int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setPassword(String password) {
        this.password = password;
    }

    public final void setAuthorities(List<? extends Authority> authorities) {
        this.authorities = authorities;
    }

    public final void setMaxIdleTime(int maxIdleTime) {
        this.maxIdleTime = maxIdleTime;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setHomeDirectory(String homeDirectory) {
        this.homeDirectory = homeDirectory;
    }
}

