/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ftpserver.ftplet.AuthenticationFailedException;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FileSystemView;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.User;
import org.genesys.filerepository.FileRepositoryException;
import org.genesys.filerepository.InvalidRepositoryFileDataException;
import org.genesys.filerepository.InvalidRepositoryPathException;
import org.genesys.filerepository.NoSuchRepositoryFileException;
import org.genesys.filerepository.model.RepositoryFile;
import org.genesys.filerepository.model.RepositoryFolder;
import org.genesys.filerepository.service.RepositoryService;
import org.genesys.filerepository.service.ftp.CanBeAnythingFile;
import org.genesys.filerepository.service.ftp.FtpRunAs;
import org.genesys.filerepository.service.ftp.FtpUser;
import org.genesys.filerepository.service.ftp.RepositoryFtpDirectory;
import org.genesys.filerepository.service.ftp.RepositoryFtpFile;
import org.genesys.filerepository.service.ftp.TemporaryBytesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.AuthenticationException;
import org.springframework.stereotype.Component;

@Component
public class RepositoryFileSystemFactory
implements FileSystemFactory,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RepositoryFileSystemFactory.class);
    @Autowired(required=true)
    private RepositoryService repositoryService;
    @Autowired(required=true)
    private TemporaryBytesManager bytesManager;

    private RepositoryFtpFile file(final RepositoryFile repositoryFile, final RepositoryFileSystemView session) {
        log.trace("Making RepositoryFtpFile repositoryFile={}", (Object)repositoryFile);
        return new RepositoryFtpFile(repositoryFile){

            @Override
            public String getOwnerName() {
                return "root";
            }

            @Override
            public String getGroupName() {
                return "wheel";
            }

            @Override
            public boolean mkdir() {
                log.debug("MKDIR on file not possible");
                return false;
            }

            @Override
            public boolean delete() {
                return FtpRunAs.asFtpUser(session.user, () -> {
                    log.info("Delete file={}", (Object)this.getAbsolutePath());
                    try {
                        RepositoryFileSystemFactory.this.repositoryService.removeFile(repositoryFile);
                        return true;
                    }
                    catch (IOException | NoSuchRepositoryFileException e) {
                        log.warn(e.getMessage());
                        return false;
                    }
                });
            }

            @Override
            public boolean move(FtpFile destination) {
                return FtpRunAs.asFtpUser(session.user, () -> {
                    log.info("Move file={} to dest={}", (Object)this.getAbsolutePath(), (Object)Paths.get(destination.getAbsolutePath(), new String[0]));
                    try {
                        RepositoryFileSystemFactory.this.repositoryService.moveAndRenameFile(repositoryFile, Paths.get(destination.getAbsolutePath(), new String[0]));
                        return true;
                    }
                    catch (InvalidRepositoryFileDataException | InvalidRepositoryPathException e) {
                        log.warn("Error moving file: {}", (Object)e.getMessage());
                        return false;
                    }
                });
            }

            @Override
            public OutputStream createOutputStream(long offset) throws IOException {
                return FtpRunAs.asFtpUser(session.user, () -> {
                    log.info("Creating output stream for file={} at offset={}", (Object)this.getAbsolutePath(), (Object)offset);
                    return RepositoryFileSystemFactory.this.bytesManager.createOutputStream(session2.user, repositoryFile, offset);
                });
            }

            @Override
            public InputStream createInputStream(long offset) throws IOException {
                return FtpRunAs.asFtpUser(session.user, () -> {
                    log.info("Creating input stream for file={} at offset={}", (Object)this.getAbsolutePath(), (Object)offset);
                    return RepositoryFileSystemFactory.this.bytesManager.createInputStream(repositoryFile, offset);
                });
            }
        };
    }

    private RepositoryFtpDirectory directory(final Path path, final RepositoryFileSystemView session) {
        log.trace("Viewing RepositoryFtpDirectory path={}", (Object)path);
        return new RepositoryFtpDirectory(path){

            @Override
            public boolean move(FtpFile destination) {
                return FtpRunAs.asFtpUser(session.user, () -> {
                    log.info("Move directory={} to dest={}", (Object)this.getAbsolutePath(), (Object)destination.getAbsolutePath());
                    try {
                        RepositoryFileSystemFactory.this.repositoryService.renamePath(Paths.get(this.getAbsolutePath(), new String[0]), Paths.get(destination.getAbsolutePath(), new String[0]));
                        return true;
                    }
                    catch (InvalidRepositoryPathException e) {
                        log.error("Failed to rename directory", (Throwable)e);
                        return false;
                    }
                });
            }

            @Override
            public boolean mkdir() {
                log.info("Mkdir directory={}", (Object)this.getAbsolutePath());
                try {
                    return FtpRunAs.asFtpUser(session.user, () -> {
                        RepositoryFileSystemFactory.this.repositoryService.ensureFolder(path);
                        return true;
                    });
                }
                catch (InvalidRepositoryPathException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    return false;
                }
            }

            @Override
            public List<? extends FtpFile> listFiles() {
                try {
                    return FtpRunAs.asFtpUser(session.user, this::_listFiles);
                }
                catch (FileRepositoryException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }

            private List<? extends FtpFile> _listFiles() throws InvalidRepositoryPathException {
                Path root = path.normalize().toAbsolutePath();
                log.debug("Listing files in path={}", (Object)root);
                ArrayList all = new ArrayList();
                all.addAll(RepositoryFileSystemFactory.this.repositoryService.getFolders(root, RepositoryFolder.DEFAULT_SORT).stream().peek(rf -> {}).map(rf -> RepositoryFileSystemFactory.this.directory(rf.getFolderPath(), session)).collect(Collectors.toList()));
                all.addAll(RepositoryFileSystemFactory.this.repositoryService.getFiles(root, RepositoryFile.DEFAULT_SORT).stream().peek(rf -> {}).map(rf -> RepositoryFileSystemFactory.this.file((RepositoryFile)rf, session)).collect(Collectors.toList()));
                return all.stream().distinct().sorted(Comparator.comparing(FtpFile::getName)).peek(path1 -> {}).collect(Collectors.toUnmodifiableList());
            }

            @Override
            public String getOwnerName() {
                return "root";
            }

            @Override
            public String getGroupName() {
                return "wheel";
            }

            @Override
            public boolean delete() {
                return FtpRunAs.asFtpUser(session.user, () -> {
                    log.info("Delete this={}", (Object)path);
                    try {
                        RepositoryFileSystemFactory.this.repositoryService.deleteFolder(path);
                        return true;
                    }
                    catch (FileRepositoryException e) {
                        return false;
                    }
                });
            }

            @Override
            public boolean changeWorkingDirectory(String dir) {
                Path normalized = Paths.get(this.getAbsolutePath(), new String[0]).resolve(dir).normalize().toAbsolutePath();
                log.info("CWD this={} dir={} normalized={}", new Object[]{this.getAbsolutePath(), dir, normalized});
                if ("/".equals(normalized.toString())) {
                    this.cwd(normalized);
                    return true;
                }
                try {
                    RepositoryFolder folder = RepositoryFileSystemFactory.this.repositoryService.getFolder(normalized);
                    if (folder != null) {
                        this.cwd(normalized);
                        return true;
                    }
                    log.warn("CWD to non-existent folder {} normalized={}", (Object)dir, (Object)normalized);
                    return false;
                }
                catch (InvalidRepositoryPathException e) {
                    log.warn("CWD to non-existent folder {} normalized={}", new Object[]{dir, normalized, e});
                    return false;
                }
            }
        };
    }

    public FileSystemView createFileSystemView(User user) {
        log.info("Creating new repository view for {}", (Object)user.getName());
        return new RepositoryFileSystemView((FtpUser)user){

            public FtpFile getFile(String file) throws FtpException {
                log.debug("getFile file={} for user={}", (Object)file, (Object)this.username);
                final Path path = file.startsWith("/") ? Paths.get(file, new String[0]).normalize() : Paths.get(this.cwd.getAbsolutePath(), file).normalize();
                log.trace("Resolved normalized={}", (Object)path);
                try {
                    return this.isDirectory(path) ? RepositoryFileSystemFactory.this.directory("/".equals(path.toString()) ? path : FtpRunAs.asFtpUser(this.user, () -> RepositoryFileSystemFactory.this.repositoryService.getFolder(path).getFolderPath()), this) : RepositoryFileSystemFactory.this.file(FtpRunAs.asFtpUser(this.user, () -> RepositoryFileSystemFactory.this.repositoryService.getFile(path.getParent(), path.getFileName().toString())), this);
                }
                catch (AuthenticationException e) {
                    log.warn("Authentication problem {}", (Object)e.getMessage(), (Object)e);
                    throw new AuthenticationFailedException(e.getMessage(), (Throwable)e);
                }
                catch (NoSuchRepositoryFileException e) {
                    log.debug("No such file {}: {}", (Object)file, (Object)e.getMessage());
                    assert (path.getFileName() != null);
                    return new CanBeAnythingFile(path.getParent(), path.getFileName().toString()){

                        @Override
                        public boolean mkdir() {
                            log.debug("MKDIR {}", (Object)path);
                            try {
                                RepositoryFolder repositoryFolder = FtpRunAs.asFtpUser(user, () -> RepositoryFileSystemFactory.this.repositoryService.ensureFolder(path));
                                return repositoryFolder != null;
                            }
                            catch (InvalidRepositoryPathException e) {
                                log.warn("{}", (Object)e.getMessage(), (Object)e);
                                return false;
                            }
                        }

                        @Override
                        public boolean delete() {
                            return true;
                        }

                        @Override
                        public OutputStream createOutputStream(long offset) throws IOException {
                            log.debug("STOR {}", (Object)path);
                            if (path.getParent() != null) {
                                log.debug("MKDIR {}", (Object)path.getParent());
                                try {
                                    RepositoryFolder repositoryFolder = FtpRunAs.asFtpUser(user, () -> RepositoryFileSystemFactory.this.repositoryService.ensureFolder(path.getParent()));
                                    if (repositoryFolder == null) {
                                        throw new InvalidRepositoryPathException("Folder not created " + path.getParent());
                                    }
                                    return RepositoryFileSystemFactory.this.bytesManager.newFile(user, path);
                                }
                                catch (InvalidRepositoryPathException e) {
                                    log.warn("{}", (Object)e.getMessage(), (Object)e);
                                    throw new IOException(e.getMessage(), e);
                                }
                            }
                            throw new IOException("Cannot store files to /");
                        }
                    };
                }
                catch (FileRepositoryException e) {
                    throw new FtpException(e.getMessage(), (Throwable)e);
                }
            }

            private boolean isDirectory(Path path) throws FtpException {
                if ("/".equals(path.toString())) {
                    return true;
                }
                try {
                    log.trace("isDirectory {}", (Object)path);
                    return RepositoryFileSystemFactory.this.repositoryService.hasPath(path);
                }
                catch (InvalidRepositoryPathException e) {
                    log.debug("Invalid repository path {}: {}", (Object)path, (Object)e.getMessage());
                    throw new FtpException(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
        assert (this.repositoryService != null);
        log.warn("Initialized RFSF with service={}", (Object)this.repositoryService);
    }

    private abstract class RepositoryFileSystemView
    implements FileSystemView {
        protected FtpUser user;
        protected String username;
        protected RepositoryFtpDirectory cwd;
        protected RepositoryFtpDirectory homeDir;

        public RepositoryFileSystemView(FtpUser user) {
            this.cwd = RepositoryFileSystemFactory.this.directory(Paths.get("/", new String[0]), this);
            this.homeDir = RepositoryFileSystemFactory.this.directory(Paths.get("/", new String[0]), this);
            this.user = user;
            this.username = user.getName();
        }

        public boolean isRandomAccessible() throws FtpException {
            return false;
        }

        public FtpFile getWorkingDirectory() throws FtpException {
            log.debug("getWorkingDirectory for user={}", (Object)this.username);
            return this.cwd;
        }

        public FtpFile getHomeDirectory() throws FtpException {
            log.debug("getHomeDirectory for user={}", (Object)this.username);
            return this.homeDir;
        }

        public void dispose() {
            log.info("Disposing repository view for user={}", (Object)this.username);
        }

        public boolean changeWorkingDirectory(String dir) throws FtpException {
            log.debug("CWD dir={} for user={}", (Object)dir, (Object)this.username);
            return this.cwd.changeWorkingDirectory(dir);
        }
    }
}

