/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;

public abstract class RepositoryFtpDirectory
implements FtpFile {
    protected Path path;

    public RepositoryFtpDirectory(Path path) {
        assert (path != null);
        this.cwd(path);
    }

    protected void cwd(Path path) {
        this.path = path.normalize().toAbsolutePath();
    }

    public String getAbsolutePath() {
        return this.path.normalize().toAbsolutePath().toString();
    }

    public String getName() {
        return this.path.getFileName().toString();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDirectory() {
        return true;
    }

    public boolean isFile() {
        return false;
    }

    public boolean doesExist() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isRemovable() {
        return true;
    }

    public abstract String getOwnerName();

    public abstract String getGroupName();

    public int getLinkCount() {
        return 0;
    }

    public long getLastModified() {
        return 0L;
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public long getSize() {
        return 0L;
    }

    public Object getPhysicalFile() {
        return null;
    }

    public abstract boolean mkdir();

    public abstract boolean delete();

    public abstract boolean move(FtpFile var1);

    public abstract List<? extends FtpFile> listFiles();

    public OutputStream createOutputStream(long offset) throws IOException {
        throw new IOException("Cannot outputstream the Directory");
    }

    public InputStream createInputStream(long offset) throws IOException {
        throw new IOException("Cannot inputstream the Directory");
    }

    public abstract boolean changeWorkingDirectory(String var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFtpDirectory other = (RepositoryFtpDirectory)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }
}

