/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.ftpserver.ftplet.FtpFile;
import org.genesys.filerepository.model.RepositoryFile;

public abstract class RepositoryFtpFile
implements FtpFile {
    private final RepositoryFile repositoryFile;

    public RepositoryFtpFile(RepositoryFile repositoryFile) {
        assert (repositoryFile != null);
        this.repositoryFile = repositoryFile;
    }

    public String getAbsolutePath() {
        return this.repositoryFile.getFolder().getPath() + this.repositoryFile.getOriginalFilename();
    }

    public String getName() {
        return this.repositoryFile.getOriginalFilename();
    }

    public boolean isHidden() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isFile() {
        return true;
    }

    public boolean doesExist() {
        return true;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isRemovable() {
        return true;
    }

    public abstract String getOwnerName();

    public abstract String getGroupName();

    public int getLinkCount() {
        return 0;
    }

    public long getLastModified() {
        return this.repositoryFile.getLastModifiedDate() != null ? this.repositoryFile.getLastModifiedDate().getEpochSecond() * 1000L : 0L;
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public long getSize() {
        return this.repositoryFile.getSize();
    }

    public Object getPhysicalFile() {
        System.err.println("getPhysicalFile??");
        return null;
    }

    public abstract boolean mkdir();

    public abstract boolean delete();

    public abstract boolean move(FtpFile var1);

    public List<? extends FtpFile> listFiles() {
        return null;
    }

    public abstract OutputStream createOutputStream(long var1) throws IOException;

    public abstract InputStream createInputStream(long var1) throws IOException;
}

