/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.io.File;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.ftpserver.ConnectionConfig;
import org.apache.ftpserver.DataConnectionConfigurationFactory;
import org.apache.ftpserver.FtpServer;
import org.apache.ftpserver.FtpServerFactory;
import org.apache.ftpserver.ftplet.DefaultFtplet;
import org.apache.ftpserver.ftplet.FileSystemFactory;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.Ftplet;
import org.apache.ftpserver.ftplet.UserManager;
import org.apache.ftpserver.listener.ListenerFactory;
import org.apache.ftpserver.message.MessageResource;
import org.apache.ftpserver.ssl.SslConfigurationFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RepositoryFtpServer
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(RepositoryFtpServer.class);
    @Autowired
    private UserManager userManager;
    @Autowired(required=false)
    private MessageResource messageResource;
    private int ftpPort;
    private int maxThreads = 20;
    private int maxLogins = 10;
    private int idleTimeout = 60;
    private String keystorePath;
    private String keystorePsw;
    private String passivePorts;
    private String externalAddress;
    private String passiveAddress;
    private FtpServer server = null;
    @Autowired
    private FileSystemFactory repositoryFileSystemFactory;

    public void setExternalAddress(String externalAddress) {
        this.externalAddress = externalAddress;
    }

    public void setPassivePorts(String passivePorts) {
        this.passivePorts = passivePorts;
    }

    public void setPassiveAddress(String passiveAddress) {
        this.passiveAddress = passiveAddress;
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setKeystorePsw(String keystorePsw) {
        this.keystorePsw = keystorePsw;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setMessageResource(MessageResource messageResource) {
        this.messageResource = messageResource;
    }

    public void setFtpPort(int ftpPort) {
        this.ftpPort = ftpPort;
    }

    public void setMaxLogins(int maxLogins) {
        this.maxLogins = maxLogins;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void afterPropertiesSet() throws FtpException, UnknownHostException {
        if (this.ftpPort < 1) {
            log.warn("FTP server not started, port={}", (Object)this.ftpPort);
            return;
        }
        FtpServerFactory serverFactory = new FtpServerFactory();
        serverFactory.setUserManager(this.userManager);
        if (this.messageResource != null) {
            serverFactory.setMessageResource(this.messageResource);
        }
        ListenerFactory factory = new ListenerFactory();
        factory.setPort(this.ftpPort);
        factory.setIdleTimeout(this.idleTimeout);
        SslConfigurationFactory ssl = new SslConfigurationFactory();
        ssl.setKeystoreFile(new File(this.keystorePath));
        ssl.setKeystorePassword(this.keystorePsw);
        factory.setSslConfiguration(ssl.createSslConfiguration());
        factory.setImplicitSsl(true);
        DataConnectionConfigurationFactory dccf = new DataConnectionConfigurationFactory();
        dccf.setPassivePorts(this.passivePorts);
        try {
            ArrayList<NetworkInterface> nets = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface net : nets) {
                ArrayList<InetAddress> netIps = Collections.list(net.getInetAddresses());
                log.warn("Network {}: {} {}", new Object[]{net.getName(), netIps, net.getInterfaceAddresses()});
            }
        }
        catch (SocketException e) {
            log.error("Error enumerating network interfaces: {}", (Object)e.getMessage(), (Object)e);
        }
        if (StringUtils.isNotBlank((CharSequence)this.passiveAddress)) {
            dccf.setPassiveAddress(this.passiveAddress);
            log.warn("Using {} for PASV data connections", (Object)this.passiveAddress);
            try {
                InetAddress ipAddress = InetAddress.getByName(this.passiveAddress);
                log.warn("Resolved {} to {} for PASV data connections", (Object)this.passiveAddress, (Object)ipAddress.getHostAddress());
            }
            catch (UnknownHostException e) {
                log.warn("Could not resolve {}: {}", (Object)this.passiveAddress, (Object)e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)dccf.getPassiveAddress())) {
            log.warn("Network interface for passive data connections not defined. Using 0.0.0.0");
            dccf.setPassiveAddress("0.0.0.0");
        }
        if (StringUtils.isNotBlank((CharSequence)this.externalAddress)) {
            dccf.setPassiveExternalAddress(this.externalAddress);
            log.warn("Using {} as external PASV address", (Object)this.externalAddress);
            try {
                InetAddress address = InetAddress.getByName(this.externalAddress);
                log.warn("Resolved {} to {} as external PASV address", (Object)this.externalAddress, (Object)address.getHostAddress());
            }
            catch (UnknownHostException e) {
                log.warn("Could not resolve {}: {}", (Object)this.externalAddress, (Object)e.getMessage());
            }
        }
        if (StringUtils.isBlank((CharSequence)dccf.getPassiveExternalAddress())) {
            log.warn("External address for passive data connections not defined.");
        }
        factory.setDataConnectionConfiguration(dccf.createDataConnectionConfiguration());
        serverFactory.addListener("default", factory.createListener());
        FileSystemFactory fileSystem = this.repositoryFileSystemFactory;
        serverFactory.setFileSystem(fileSystem);
        ConnectionConfig ftpConnectionConfig = new ConnectionConfig(){

            public boolean isAnonymousLoginEnabled() {
                return false;
            }

            public int getMaxThreads() {
                return RepositoryFtpServer.this.maxThreads;
            }

            public int getMaxLogins() {
                return RepositoryFtpServer.this.maxLogins;
            }

            public int getMaxLoginFailures() {
                return 3;
            }

            public int getMaxAnonymousLogins() {
                return 0;
            }

            public int getLoginFailureDelay() {
                return 30;
            }
        };
        serverFactory.setConnectionConfig(ftpConnectionConfig);
        HashMap<String, Ftplet> ftplets = new HashMap<String, Ftplet>();
        ftplets.put("default", this.repositoryFtplet());
        serverFactory.setFtplets(ftplets);
        this.server = serverFactory.createServer();
        log.info("Starting FTP server on port {}", (Object)this.ftpPort);
        this.server.start();
    }

    public void destroy() throws Exception {
        if (this.server != null) {
            log.info("Shutting down FTP server on port {}", (Object)this.ftpPort);
            this.server.stop();
        }
    }

    private Ftplet repositoryFtplet() {
        return new DefaultFtplet(){};
    }
}

