/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.filerepository.service.ftp;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RepositorySyncOutputStream
extends BufferedOutputStream {
    private final AtomicBoolean oneShot = new AtomicBoolean(true);

    public RepositorySyncOutputStream(OutputStream out) {
        super(out);
    }

    @Override
    public synchronized void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
            if (this.oneShot.getAndSet(false)) {
                this.synchronizeWithRepository();
            }
        }
        finally {
            this.cleanup();
        }
    }

    protected abstract void cleanup() throws IOException;

    protected abstract void synchronizeWithRepository() throws IOException;
}

