package org.genesys.client.util;

import com.google.common.util.concurrent.RateLimiter;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Aspect to control the rate of calls to Genesys
 */
@Aspect
public class GenesysRateLimiter {

	private static final Logger LOG = LoggerFactory.getLogger(GenesysRateLimiter.class);

	private RateLimiter limiter = RateLimiter.create(20);
	
	public GenesysRateLimiter(double permitsPerSecond) {
		setPermitsPerSecond(permitsPerSecond);
	}

	public void setPermitsPerSecond(double permitsPerSecond) {
		limiter = RateLimiter.create(permitsPerSecond);
	}

	@Before("execution(* org.genesys.client.api.*.*(..))")
	public void rateLimit(JoinPoint jp) {
		double delay = limiter.acquire();
		LOG.debug("Acquired rate limit permission ({} qps) in {} seconds for {}", limiter.getRate(), delay, jp.toLongString());
	}

}
