/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.client.util;

import com.google.common.util.concurrent.RateLimiter;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class GenesysRateLimiter {
    private static final Logger LOG = LoggerFactory.getLogger(GenesysRateLimiter.class);
    private RateLimiter limiter = RateLimiter.create((double)20.0);

    public GenesysRateLimiter(double permitsPerSecond) {
        this.setPermitsPerSecond(permitsPerSecond);
    }

    public void setPermitsPerSecond(double permitsPerSecond) {
        this.limiter = RateLimiter.create((double)permitsPerSecond);
    }

    @Before(value="execution(* org.genesys.client.api.*.*(..))")
    public void rateLimit(JoinPoint jp) {
        double delay = this.limiter.acquire();
        LOG.debug("Acquired rate limit permission ({} qps) in {} seconds for {}", new Object[]{this.limiter.getRate(), delay, jp.toLongString()});
    }
}

