/*
 * Copyright 2016 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.geotools.service;

/**
 * The Interface CountryOfOriginService.
 */
public interface CountryOfOriginService {

	/**
	 * Gets the countries.
	 *
	 * @param longitude the longitude
	 * @param latitude the latitude
	 * @param origCty the orig cty
	 * @param allowedDistanceMargin the allowed distance margin
	 * @return the countries
	 * @throws Exception the exception
	 */
	String getCountries(float longitude, float latitude, String origCty, int allowedDistanceMargin) throws Exception;

	/**
	 * Get distance from georeference to closest point on border of specified country
	 * 
	 * @param longitude the longitude
	 * @param latitude the latitude
	 * @param origCty the country ISO code
	 * @return distance to closest point on country border or -1 if not found
	 * @throws Exception the exception
	 */
	double distanceToBorder(float longitude, float latitude, String origCty) throws Exception;

}
