/*
 * Copyright 2016 Global Crop Diversity Trust
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.genesys.geotools.service;

/**
 * The Interface LandOrSeaService.
 */
public interface LandOrSeaService {

	/**
	 * Checks if is on land.
	 *
	 * @param longitude the longitude
	 * @param latitude the latitude
	 * @param allowedDistanceFromLand the allowed distance from land
	 * @return the boolean
	 * @throws Exception the exception
	 */
	public Boolean isOnLand(float longitude, float latitude, int allowedDistanceFromLand) throws Exception;

	/**
	 * Classifies location as one of Land, Coastal or Water
	 *
	 * @param longitude the longitude
	 * @param latitude the latitude
	 * @param allowedDistanceMargin the allowed distance from land
	 * @return Land, Coastal or Water
	 * @throws Exception the exception
	 */
	String classifyLocation(float longitude, float latitude, int allowedDistanceMargin) throws Exception;

}
