package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiException;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.invoker.Configuration;
import org.genesys.glis.v1.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.genesys.glis.v1.model.DOIArray;
import org.genesys.glis.v1.model.DOIHolder;
import org.genesys.glis.v1.model.PGRFA;
import org.genesys.glis.v1.model.RateLimitError;
import org.genesys.glis.v1.model.Relationship;
import org.genesys.glis.v1.model.Term;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-11T09:48:53.504Z")
public class QueryApi {
  private ApiClient apiClient;

  public QueryApi() {
    this(Configuration.getDefaultApiClient());
  }

  public QueryApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Query for holder of PGRFA by DOIs
   * Query GLIS for WIEWS code of the holder for each submitted DOI. At this time, the call has a limit of 1,000 DOIs.
   * @param dois  (optional)
   * @return List&lt;DOIHolder&gt;
   * @throws ApiException if fails to make API call
   */
  public List<DOIHolder> listHolders(DOIArray dois) throws ApiException {
    Object localVarPostBody = dois;
    
    // create path and map variables
    String localVarPath = "/glisapi/v1/holders";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "easySmta" };

    GenericType<List<DOIHolder>> localVarReturnType = new GenericType<List<DOIHolder>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Get PGRFA relationships
   * Multiple status values can be provided with comma separated strings
   * @param doi Digital Object Identifier (DOI) associated to the PGRFA for which relations are requested. Mandatory (required)
   * @param role Role of doi in the relationships. Optional, defaults to &#39;any&#39;. Role in the relationship * any - Any role, default. * subject - DOI provided is the subject in the relationship. * object - DOI provided is the object in the relationship. (optional)
   * @param oper Relational operator code to filter the relations. Optional; if specified, only the relations with the given operator will be returned. Relational code * acfr - Acquired from. The PGRFA was received from a Provider. The related DOI identifies the Provider&#39;s sample * crfr - Created from. The PGRFA was obtained through crossing parent PGRFAs. The related DOIs identify the parent samples * defr - Derived from. The PGRFA was obtained from another sample. The related DOI identifies such original sample (optional)
   * @return List&lt;Relationship&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Relationship> listRelationships(String doi, String role, String oper) throws ApiException {
    Object localVarPostBody = null;
    
    // verify the required parameter 'doi' is set
    if (doi == null) {
      throw new ApiException(400, "Missing the required parameter 'doi' when calling listRelationships");
    }
    
    // create path and map variables
    String localVarPath = "/glisapi/v1/rels";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "doi", doi));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "role", role));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "oper", oper));

    
    
    final String[] localVarAccepts = {
      "application/json", "application/xml"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "easySmta" };

    GenericType<List<Relationship>> localVarReturnType = new GenericType<List<Relationship>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * GLIS vocabularies
   * To describe the kind of information that will be found in the targets, GLIS adopts a simple controlled vocabulary.
   * @param acceptLanguage Tags to filter by (optional, default to en)
   * @return List&lt;Term&gt;
   * @throws ApiException if fails to make API call
   */
  public List<Term> listTerms(List<String> acceptLanguage) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/glisapi/v1/terms";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    if (acceptLanguage != null)
      localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));

    
    final String[] localVarAccepts = {
      "application/json", "application/xml"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "easySmta" };

    GenericType<List<Term>> localVarReturnType = new GenericType<List<Term>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
  /**
   * Find passport data on PGRFA in GLIS
   * 
   * @param page Request a particular page (optional, default to 1)
   * @param perPage The number of items returned in a single page (optional, default to 10)
   * @param acceptLanguage Tags to filter by (optional, default to en)
   * @param doi Digital Object Identifier (DOI) associated to the PGRFA (optional)
   * @param identifier Any identifier associated with the PGRFA, excluding the DOI (optional)
   * @param genus Genus of the PGRFA (optional)
   * @param species Species and other taxonomic elements (optional)
   * @param name Any name associated with the PGRFA (optional)
   * @param holdwiews FAO/WIEWS Institute code of the holding institution (optional)
   * @param holdpid Easy-SMTA PID of the holding institution or person (optional)
   * @param holdname Name and surname for persons or Organization name of the holding institution or person (optional)
   * @param holdcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the holding institution or person (optional)
   * @param methodcode Code of the method through which the PGRFA has been acquired. See Table 1 for the codes accepted by this element. TODO enum (optional)
   * @param provwiews FAO/WIEWS Institute code of the providing institution (optional)
   * @param provpid Easy-SMTA PID of the providing institution or person (optional)
   * @param provname Name and surname for persons or Organization name of the providing institution (optional)
   * @param provcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
   * @param provenance ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the providing institution or person (optional)
   * @param collwiews FAO/WIEWS Institute code of the collecting institution (optional)
   * @param collpid Easy-SMTA PID of the collecting institution or person (optional)
   * @param collname Name and surname for persons or Organization name of the collecting institution or person (optional)
   * @param collcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the collecting institution or person (optional)
   * @param bredwiews FAO/WIEWS Institute code of the breeding institution (optional)
   * @param bredpid Easy-SMTA PID of the breeding institution or person (optional)
   * @param bredname Name and surname for persons or Organization name of the breeding institution or person (optional)
   * @param bredcountry ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the breeding institution or person (optional)
   * @param biostatus Code of the biological status of sample (MCPD SAMPSTAT). (optional)
   * @param mlsstatus Code for the inclusion into the Multilateral System. (optional)
   * @param targetkw Code for the keyword for a target associated to the PGRFA. To obtain the list of keyword codes, please see \&quot;Controlled vocabulary query\&quot;. (optional)
   * @return List&lt;PGRFA&gt;
   * @throws ApiException if fails to make API call
   */
  public List<PGRFA> search(Integer page, Integer perPage, List<String> acceptLanguage, String doi, String identifier, String genus, String species, String name, String holdwiews, String holdpid, String holdname, String holdcountry, String methodcode, String provwiews, String provpid, String provname, String provcountry, String provenance, String collwiews, String collpid, String collname, String collcountry, String bredwiews, String bredpid, String bredname, String bredcountry, String biostatus, String mlsstatus, String targetkw) throws ApiException {
    Object localVarPostBody = null;
    
    // create path and map variables
    String localVarPath = "/glisapi/v1/pgrfas";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    localVarQueryParams.addAll(apiClient.parameterToPairs("", "page", page));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "per-page", perPage));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "doi", doi));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "identifier", identifier));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "genus", genus));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "species", species));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "name", name));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "holdwiews", holdwiews));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "holdpid", holdpid));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "holdname", holdname));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "holdcountry", holdcountry));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "methodcode", methodcode));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "provwiews", provwiews));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "provpid", provpid));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "provname", provname));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "provcountry", provcountry));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "provenance", provenance));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "collwiews", collwiews));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "collpid", collpid));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "collname", collname));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "collcountry", collcountry));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "bredwiews", bredwiews));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "bredpid", bredpid));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "bredname", bredname));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "bredcountry", bredcountry));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "biostatus", biostatus));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "mlsstatus", mlsstatus));
    localVarQueryParams.addAll(apiClient.parameterToPairs("", "targetkw", targetkw));

    if (acceptLanguage != null)
      localVarHeaderParams.put("Accept-Language", apiClient.parameterToString(acceptLanguage));

    
    final String[] localVarAccepts = {
      "application/json", "application/xml", "application/brapi", "application/zip", "application/ld+json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "easySmta" };

    GenericType<List<PGRFA>> localVarReturnType = new GenericType<List<PGRFA>>() {};
    return apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
