package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiException;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.invoker.Configuration;
import org.genesys.glis.v1.invoker.Pair;

import javax.ws.rs.core.GenericType;

import org.genesys.glis.v1.model.UpdateTargets;
import org.genesys.glis.v1.model.UpdatedTarget;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-10T16:52:17.658Z")
public class GenesysApi {
  private ApiClient apiClient;

  public GenesysApi() {
    this(Configuration.getDefaultApiClient());
  }

  public GenesysApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Add Genesys as target URL to specified DOIs
   * We&#39;ll have fun!
   * @param targets Registers Genesys as a target URL for specified DOIs (optional)
   * @return List&lt;UpdatedTarget&gt;
   * @throws ApiException if fails to make API call
   */
  public List<UpdatedTarget> registerGenesysAsTarget(UpdateTargets targets) throws ApiException {
    Object localVarPostBody = targets;
    
    // create path and map variables
    String localVarPath = "/glis/links/addtarget";

    // query params
    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    Map<String, String> localVarHeaderParams = new HashMap<String, String>();
    Map<String, Object> localVarFormParams = new HashMap<String, Object>();


    
    
    final String[] localVarAccepts = {
      "application/json"
    };
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);

    final String[] localVarContentTypes = {
      "application/json"
    };
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);

    String[] localVarAuthNames = new String[] { "easySmta" };

    GenericType<List<UpdatedTarget>> localVarReturnType = new GenericType<List<UpdatedTarget>>() {};
    return apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
      }
}
