/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.genesys.glis.v1.model.Actor;

/**
 * Acquisition
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2018-09-10T16:52:17.658Z")
public class Acquisition {
  @JsonProperty("provider")
  private Actor provider = null;

  @JsonProperty("sampleid")
  private String sampleid = null;

  @JsonProperty("provenance")
  private String provenance = null;

  public Acquisition provider(Actor provider) {
    this.provider = provider;
    return this;
  }

   /**
   * Get provider
   * @return provider
  **/
  @ApiModelProperty(required = true, value = "")
  public Actor getProvider() {
    return provider;
  }

  public void setProvider(Actor provider) {
    this.provider = provider;
  }

  public Acquisition sampleid(String sampleid) {
    this.sampleid = sampleid;
    return this;
  }

   /**
   * Get sampleid
   * @return sampleid
  **/
  @ApiModelProperty(value = "")
  public String getSampleid() {
    return sampleid;
  }

  public void setSampleid(String sampleid) {
    this.sampleid = sampleid;
  }

  public Acquisition provenance(String provenance) {
    this.provenance = provenance;
    return this;
  }

   /**
   * ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the country of provenance.
   * @return provenance
  **/
  @ApiModelProperty(example = "DEU", value = "ISO-3166 alpha-3 country code (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-3) of the country of provenance.")
  public String getProvenance() {
    return provenance;
  }

  public void setProvenance(String provenance) {
    this.provenance = provenance;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Acquisition acquisition = (Acquisition) o;
    return Objects.equals(this.provider, acquisition.provider) &&
        Objects.equals(this.sampleid, acquisition.sampleid) &&
        Objects.equals(this.provenance, acquisition.provenance);
  }

  @Override
  public int hashCode() {
    return Objects.hash(provider, sampleid, provenance);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Acquisition {\n");
    
    sb.append("    provider: ").append(toIndentedString(provider)).append("\n");
    sb.append("    sampleid: ").append(toIndentedString(sampleid)).append("\n");
    sb.append("    provenance: ").append(toIndentedString(provenance)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

