/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.genesys.glis.v1.model.Acquisition;
import org.genesys.glis.v1.model.Breeding;
import org.genesys.glis.v1.model.Collection;
import org.genesys.glis.v1.model.Location;
import org.genesys.glis.v1.model.Target;

public class BasePGRFA {
    @SerializedName(value="username")
    private String username = null;
    @SerializedName(value="password")
    private String password = null;
    @SerializedName(value="location")
    private Location location = null;
    @SerializedName(value="sampledoi")
    private String sampledoi = null;
    @SerializedName(value="sampleid")
    private String sampleid = null;
    @SerializedName(value="date")
    private String date = null;
    @SerializedName(value="method")
    private String method = null;
    @SerializedName(value="genus")
    private String genus = null;
    @SerializedName(value="cropnames")
    private List<String> cropnames = null;
    @SerializedName(value="targets")
    private List<Target> targets = null;
    @SerializedName(value="progdoi")
    private List<String> progdoi = null;
    @SerializedName(value="biostatus")
    private Integer biostatus = null;
    @SerializedName(value="species")
    private String species = null;
    @SerializedName(value="spauth")
    private String spauth = null;
    @SerializedName(value="subtaxa")
    private String subtaxa = null;
    @SerializedName(value="stauth")
    private String stauth = null;
    @SerializedName(value="names")
    private List<String> names = null;
    @SerializedName(value="ids")
    private List<String> ids = null;
    @SerializedName(value="mlsstatus")
    private Integer mlsstatus = null;
    @SerializedName(value="historical")
    private String historical = null;
    @SerializedName(value="acquisition")
    private Acquisition acquisition = null;
    @SerializedName(value="collection")
    private Collection collection = null;
    @SerializedName(value="breeding")
    private Breeding breeding = null;

    public BasePGRFA username(String username) {
        this.username = username;
        return this;
    }

    @ApiModelProperty(example="cgn", value="")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public BasePGRFA password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(example="Passw0rd", value="")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BasePGRFA location(Location location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(value="")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public BasePGRFA sampledoi(String sampledoi) {
        this.sampledoi = sampledoi;
        return this;
    }

    @ApiModelProperty(value="A Digital Object Identifier (DOI) obtained from a service other than GLIS and that is already assigned to the PGRFA.")
    public String getSampledoi() {
        return this.sampledoi;
    }

    public void setSampledoi(String sampledoi) {
        this.sampledoi = sampledoi;
    }

    public BasePGRFA sampleid(String sampleid) {
        this.sampleid = sampleid;
        return this;
    }

    @ApiModelProperty(example="CGN00001", value="A string that identifies the PGRFA that is being registered. This value will be returned by GLIS in the response message and is assumed to be used to associate the DOI to the corresponding material in the local database. You must provide <sampleid> even if <sampledoi> is provided. In case you use the DOI as unique identifier in your local database, you can repeat it in <sampleid>. Mandatory. Please read more details in the \u201cHTTPS reply\u201d chapter.")
    public String getSampleid() {
        return this.sampleid;
    }

    public void setSampleid(String sampleid) {
        this.sampleid = sampleid;
    }

    public BasePGRFA date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="1987-06-23", value="Date in which PGRFA became part of the collection. Date fragments (YYYY-MM and YYYY) are also accepted.")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public BasePGRFA method(String method) {
        this.method = method;
        return this;
    }

    @ApiModelProperty(example="acqu", value="Method through which the PGRFA has been acquired. Mandatory.")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public BasePGRFA genus(String genus) {
        this.genus = genus;
        return this;
    }

    @ApiModelProperty(example="Hordeum", value="The taxon of the genus for the PGRFA. At least one between <genus> and <cropname> must be provided.")
    public String getGenus() {
        return this.genus;
    }

    public void setGenus(String genus) {
        this.genus = genus;
    }

    public BasePGRFA cropnames(List<String> cropnames) {
        this.cropnames = cropnames;
        return this;
    }

    public BasePGRFA addCropnamesItem(String cropnamesItem) {
        if (this.cropnames == null) {
            this.cropnames = new ArrayList<String>();
        }
        this.cropnames.add(cropnamesItem);
        return this;
    }

    @ApiModelProperty(example="[\"Barley\",\"Wheat\"]", value="Common name of the crop. At least one between <genus> and one cropname must be provided. Multiple names are allowed.")
    public List<String> getCropnames() {
        return this.cropnames;
    }

    public void setCropnames(List<String> cropnames) {
        this.cropnames = cropnames;
    }

    public BasePGRFA targets(List<Target> targets) {
        this.targets = targets;
        return this;
    }

    public BasePGRFA addTargetsItem(Target targetsItem) {
        if (this.targets == null) {
            this.targets = new ArrayList<Target>();
        }
        this.targets.add(targetsItem);
        return this;
    }

    @ApiModelProperty(value="")
    public List<Target> getTargets() {
        return this.targets;
    }

    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    public BasePGRFA progdoi(List<String> progdoi) {
        this.progdoi = progdoi;
        return this;
    }

    public BasePGRFA addProgdoiItem(String progdoiItem) {
        if (this.progdoi == null) {
            this.progdoi = new ArrayList<String>();
        }
        this.progdoi.add(progdoiItem);
        return this;
    }

    @ApiModelProperty(example="[\"10.0155/11\",\"10.0155/12\"]", value="DOI of the progenitor PGRFA as registered in GLIS. Please note that the number of allowed DOIs depends on the method as follows   * Acquisition - 1 DOI  * In-house copy - 1 DOI  * In-house variant - 1 DOI  * Novel distinct PGRFA - 1 or more DOIs  * Observation - Natural - 0 DOI  * Observation \u2013 Inherited - 0 DOI")
    public List<String> getProgdoi() {
        return this.progdoi;
    }

    public void setProgdoi(List<String> progdoi) {
        this.progdoi = progdoi;
    }

    public BasePGRFA biostatus(Integer biostatus) {
        this.biostatus = biostatus;
        return this;
    }

    @ApiModelProperty(example="300", value="Biological status of the PGRFA.")
    public Integer getBiostatus() {
        return this.biostatus;
    }

    public void setBiostatus(Integer biostatus) {
        this.biostatus = biostatus;
    }

    public BasePGRFA species(String species) {
        this.species = species;
        return this;
    }

    @ApiModelProperty(example="vulgare", value="Specific epithet of the PGRFA scientific name. If not provided, \"sp.\" is assumed.")
    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public BasePGRFA spauth(String spauth) {
        this.spauth = spauth;
        return this;
    }

    @ApiModelProperty(example="L.", value="Authority for the specific epithet.")
    public String getSpauth() {
        return this.spauth;
    }

    public void setSpauth(String spauth) {
        this.spauth = spauth;
    }

    public BasePGRFA subtaxa(String subtaxa) {
        this.subtaxa = subtaxa;
        return this;
    }

    @ApiModelProperty(example="subsp. vulgare", value="Any additional infra-specific taxon such as subspecies, variety, form, Group and so on.")
    public String getSubtaxa() {
        return this.subtaxa;
    }

    public void setSubtaxa(String subtaxa) {
        this.subtaxa = subtaxa;
    }

    public BasePGRFA stauth(String stauth) {
        this.stauth = stauth;
        return this;
    }

    @ApiModelProperty(example="L.", value="Authority for the subtaxon at the most detailed level provided.")
    public String getStauth() {
        return this.stauth;
    }

    public void setStauth(String stauth) {
        this.stauth = stauth;
    }

    public BasePGRFA names(List<String> names) {
        this.names = names;
        return this;
    }

    public BasePGRFA addNamesItem(String namesItem) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        this.names.add(namesItem);
        return this;
    }

    @ApiModelProperty(example="[\"a\",\"b\"]", value="Other name of the PGRFA. Any number of names can be provided.")
    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public BasePGRFA ids(List<String> ids) {
        this.ids = ids;
        return this;
    }

    public BasePGRFA addIdsItem(String idsItem) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        this.ids.add(idsItem);
        return this;
    }

    @ApiModelProperty(example="[\"a\",\"b\"]", value="")
    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public BasePGRFA mlsstatus(Integer mlsstatus) {
        this.mlsstatus = mlsstatus;
        return this;
    }

    @ApiModelProperty(example="1", value="Code that identifies the status of the PGRFA with regard to the MLS.")
    public Integer getMlsstatus() {
        return this.mlsstatus;
    }

    public void setMlsstatus(Integer mlsstatus) {
        this.mlsstatus = mlsstatus;
    }

    public BasePGRFA historical(String historical) {
        this.historical = historical;
        return this;
    }

    @ApiModelProperty(example="n", value="Indicates whether the PGRFA currently exists. Allowed value is y/n")
    public String getHistorical() {
        return this.historical;
    }

    public void setHistorical(String historical) {
        this.historical = historical;
    }

    public BasePGRFA acquisition(Acquisition acquisition) {
        this.acquisition = acquisition;
        return this;
    }

    @ApiModelProperty(value="")
    public Acquisition getAcquisition() {
        return this.acquisition;
    }

    public void setAcquisition(Acquisition acquisition) {
        this.acquisition = acquisition;
    }

    public BasePGRFA collection(Collection collection) {
        this.collection = collection;
        return this;
    }

    @ApiModelProperty(value="")
    public Collection getCollection() {
        return this.collection;
    }

    public void setCollection(Collection collection) {
        this.collection = collection;
    }

    public BasePGRFA breeding(Breeding breeding) {
        this.breeding = breeding;
        return this;
    }

    @ApiModelProperty(value="")
    public Breeding getBreeding() {
        return this.breeding;
    }

    public void setBreeding(Breeding breeding) {
        this.breeding = breeding;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasePGRFA basePGRFA = (BasePGRFA)o;
        return Objects.equals(this.username, basePGRFA.username) && Objects.equals(this.password, basePGRFA.password) && Objects.equals(this.location, basePGRFA.location) && Objects.equals(this.sampledoi, basePGRFA.sampledoi) && Objects.equals(this.sampleid, basePGRFA.sampleid) && Objects.equals(this.date, basePGRFA.date) && Objects.equals(this.method, basePGRFA.method) && Objects.equals(this.genus, basePGRFA.genus) && Objects.equals(this.cropnames, basePGRFA.cropnames) && Objects.equals(this.targets, basePGRFA.targets) && Objects.equals(this.progdoi, basePGRFA.progdoi) && Objects.equals(this.biostatus, basePGRFA.biostatus) && Objects.equals(this.species, basePGRFA.species) && Objects.equals(this.spauth, basePGRFA.spauth) && Objects.equals(this.subtaxa, basePGRFA.subtaxa) && Objects.equals(this.stauth, basePGRFA.stauth) && Objects.equals(this.names, basePGRFA.names) && Objects.equals(this.ids, basePGRFA.ids) && Objects.equals(this.mlsstatus, basePGRFA.mlsstatus) && Objects.equals(this.historical, basePGRFA.historical) && Objects.equals(this.acquisition, basePGRFA.acquisition) && Objects.equals(this.collection, basePGRFA.collection) && Objects.equals(this.breeding, basePGRFA.breeding);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.password, this.location, this.sampledoi, this.sampleid, this.date, this.method, this.genus, this.cropnames, this.targets, this.progdoi, this.biostatus, this.species, this.spauth, this.subtaxa, this.stauth, this.names, this.ids, this.mlsstatus, this.historical, this.acquisition, this.collection, this.breeding);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BasePGRFA {\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    sampledoi: ").append(this.toIndentedString(this.sampledoi)).append("\n");
        sb.append("    sampleid: ").append(this.toIndentedString(this.sampleid)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    genus: ").append(this.toIndentedString(this.genus)).append("\n");
        sb.append("    cropnames: ").append(this.toIndentedString(this.cropnames)).append("\n");
        sb.append("    targets: ").append(this.toIndentedString(this.targets)).append("\n");
        sb.append("    progdoi: ").append(this.toIndentedString(this.progdoi)).append("\n");
        sb.append("    biostatus: ").append(this.toIndentedString(this.biostatus)).append("\n");
        sb.append("    species: ").append(this.toIndentedString(this.species)).append("\n");
        sb.append("    spauth: ").append(this.toIndentedString(this.spauth)).append("\n");
        sb.append("    subtaxa: ").append(this.toIndentedString(this.subtaxa)).append("\n");
        sb.append("    stauth: ").append(this.toIndentedString(this.stauth)).append("\n");
        sb.append("    names: ").append(this.toIndentedString(this.names)).append("\n");
        sb.append("    ids: ").append(this.toIndentedString(this.ids)).append("\n");
        sb.append("    mlsstatus: ").append(this.toIndentedString(this.mlsstatus)).append("\n");
        sb.append("    historical: ").append(this.toIndentedString(this.historical)).append("\n");
        sb.append("    acquisition: ").append(this.toIndentedString(this.acquisition)).append("\n");
        sb.append("    collection: ").append(this.toIndentedString(this.collection)).append("\n");
        sb.append("    breeding: ").append(this.toIndentedString(this.breeding)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

