/*
 * Global Information System API Client
 * Genesys API client to the Global Information System (GLIS) for PGRFA  [https://glis.planttreaty.org](https://glis.planttreaty.org).
 *
 * OpenAPI spec version: 1.1-SNAPSHOT
 * Contact: helpdesk@genesys-pgr.org
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package org.genesys.glis.v1.api;

import org.genesys.glis.v1.invoker.ApiCallback;
import org.genesys.glis.v1.invoker.ApiClient;
import org.genesys.glis.v1.invoker.ApiException;
import org.genesys.glis.v1.invoker.ApiResponse;
import org.genesys.glis.v1.invoker.Configuration;
import org.genesys.glis.v1.invoker.Pair;
import org.genesys.glis.v1.invoker.ProgressRequestBody;
import org.genesys.glis.v1.invoker.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import org.genesys.glis.v1.model.UpdateTargets;
import org.genesys.glis.v1.model.UpdatedTarget;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GenesysApi {
    private ApiClient apiClient;

    public GenesysApi() {
        this(Configuration.getDefaultApiClient());
    }

    public GenesysApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for registerGenesysAsTarget
     * @param targets Registers Genesys as a target URL for specified DOIs (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call registerGenesysAsTargetCall(UpdateTargets targets, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = targets;

        // create path and map variables
        String localVarPath = "/glis/links/addtarget";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            "application/json"
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "easySmta" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call registerGenesysAsTargetValidateBeforeCall(UpdateTargets targets, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        

        com.squareup.okhttp.Call call = registerGenesysAsTargetCall(targets, progressListener, progressRequestListener);
        return call;

    }

    /**
     * Add Genesys as target URL to specified DOIs
     * We&#39;ll have fun!
     * @param targets Registers Genesys as a target URL for specified DOIs (optional)
     * @return List&lt;UpdatedTarget&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public List<UpdatedTarget> registerGenesysAsTarget(UpdateTargets targets) throws ApiException {
        ApiResponse<List<UpdatedTarget>> resp = registerGenesysAsTargetWithHttpInfo(targets);
        return resp.getData();
    }

    /**
     * Add Genesys as target URL to specified DOIs
     * We&#39;ll have fun!
     * @param targets Registers Genesys as a target URL for specified DOIs (optional)
     * @return ApiResponse&lt;List&lt;UpdatedTarget&gt;&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<List<UpdatedTarget>> registerGenesysAsTargetWithHttpInfo(UpdateTargets targets) throws ApiException {
        com.squareup.okhttp.Call call = registerGenesysAsTargetValidateBeforeCall(targets, null, null);
        Type localVarReturnType = new TypeToken<List<UpdatedTarget>>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add Genesys as target URL to specified DOIs (asynchronously)
     * We&#39;ll have fun!
     * @param targets Registers Genesys as a target URL for specified DOIs (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call registerGenesysAsTargetAsync(UpdateTargets targets, final ApiCallback<List<UpdatedTarget>> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = registerGenesysAsTargetValidateBeforeCall(targets, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<UpdatedTarget>>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
