/*
 * Decompiled with CFR 0.152.
 */
package org.genesys.glis.v1.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.genesys.glis.v1.model.Location;
import org.genesys.glis.v1.model.Names;
import org.genesys.glis.v1.model.OtherIdentifier;
import org.genesys.glis.v1.model.Species;
import org.genesys.glis.v1.model.Target;
import org.genesys.glis.v1.model.TermValue;
import org.genesys.glis.v1.model.UpdateInformation;

public class PGRFA {
    @SerializedName(value="doi")
    private String doi = null;
    @SerializedName(value="url")
    private String url = null;
    @SerializedName(value="user")
    private Location user = null;
    @SerializedName(value="M01")
    private Location m01 = null;
    @SerializedName(value="M02")
    private String m02 = null;
    @SerializedName(value="M03")
    private String m03 = null;
    @SerializedName(value="M04")
    private TermValue m04 = null;
    @SerializedName(value="M05")
    private Names m05 = null;
    @SerializedName(value="R01")
    private List<Target> r01 = null;
    @SerializedName(value="R03")
    private TermValue r03 = null;
    @SerializedName(value="R04")
    private Species r04 = null;
    @SerializedName(value="R05")
    private List<String> r05 = null;
    @SerializedName(value="R06")
    private List<OtherIdentifier> r06 = null;
    @SerializedName(value="R07")
    private TermValue r07 = null;
    @SerializedName(value="R08")
    private String r08 = null;
    @SerializedName(value="A01")
    private Location a01 = null;
    @SerializedName(value="A02")
    private String a02 = null;
    @SerializedName(value="A03")
    private String a03 = null;
    @SerializedName(value="A04")
    private List<Location> a04 = null;
    @SerializedName(value="A05")
    private String a05 = null;
    @SerializedName(value="A06")
    private String a06 = null;
    @SerializedName(value="A07")
    private String a07 = null;
    @SerializedName(value="A08")
    private BigDecimal a08 = null;
    @SerializedName(value="A09")
    private BigDecimal a09 = null;
    @SerializedName(value="A10")
    private String a10 = null;
    @SerializedName(value="A11")
    private TermValue a11 = null;
    @SerializedName(value="A12")
    private TermValue a12 = null;
    @SerializedName(value="A13")
    private BigDecimal a13 = null;
    @SerializedName(value="A14")
    private String a14 = null;
    @SerializedName(value="A15")
    private TermValue a15 = null;
    @SerializedName(value="A16")
    private List<Location> a16 = null;
    @SerializedName(value="A17")
    private String a17 = null;
    @SerializedName(value="info")
    private UpdateInformation info = null;

    public PGRFA doi(String doi) {
        this.doi = doi;
        return this;
    }

    @ApiModelProperty(example="10.0155/1", required=true, value="Digital Object Identifier (DOI) associated to the PGRFA")
    public String getDoi() {
        return this.doi;
    }

    public void setDoi(String doi) {
        this.doi = doi;
    }

    public PGRFA url(String url) {
        this.url = url;
        return this;
    }

    @ApiModelProperty(value="GLIS landing page for the PGRFA")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public PGRFA user(Location user) {
        this.user = user;
        return this;
    }

    @ApiModelProperty(value="GLIS user account who registered the PGRFA")
    public Location getUser() {
        return this.user;
    }

    public void setUser(Location user) {
        this.user = user;
    }

    public PGRFA m01(Location m01) {
        this.m01 = m01;
        return this;
    }

    @ApiModelProperty(value="The organization, individual or legal entity conserving the PGRFA")
    public Location getM01() {
        return this.m01;
    }

    public void setM01(Location m01) {
        this.m01 = m01;
    }

    public PGRFA m02(String m02) {
        this.m02 = m02;
        return this;
    }

    @ApiModelProperty(value="The identifier that is used to identify the PGRFA material to distinguish it from other PGRFA conserved by the holder. Precisely one identifier is specified for the material.")
    public String getM02() {
        return this.m02;
    }

    public void setM02(String m02) {
        this.m02 = m02;
    }

    public PGRFA m03(String m03) {
        this.m03 = m03;
        return this;
    }

    @ApiModelProperty(value="Date on which PGRFA came into management of the holder of the PGRFA. Date fragments are also accepted, e.g. when only year or year and month are defined.")
    public String getM03() {
        return this.m03;
    }

    public void setM03(String m03) {
        this.m03 = m03;
    }

    public PGRFA m04(TermValue m04) {
        this.m04 = m04;
        return this;
    }

    @ApiModelProperty(value="Considering the date given for the previous field (Date), what event occurred on that date that resulted in the holder becoming the PGRFA holder.")
    public TermValue getM04() {
        return this.m04;
    }

    public void setM04(TermValue m04) {
        this.m04 = m04;
    }

    public PGRFA m05(Names m05) {
        this.m05 = m05;
        return this;
    }

    @ApiModelProperty(value="")
    public Names getM05() {
        return this.m05;
    }

    public void setM05(Names m05) {
        this.m05 = m05;
    }

    public PGRFA r01(List<Target> r01) {
        this.r01 = r01;
        return this;
    }

    public PGRFA addR01Item(Target r01Item) {
        if (this.r01 == null) {
            this.r01 = new ArrayList<Target>();
        }
        this.r01.add(r01Item);
        return this;
    }

    @ApiModelProperty(value="The URLs of websites where additional information on the PGRFA can be found. Each target is associated to one or more controlled vocabulary term code.")
    public List<Target> getR01() {
        return this.r01;
    }

    public void setR01(List<Target> r01) {
        this.r01 = r01;
    }

    public PGRFA r03(TermValue r03) {
        this.r03 = r03;
        return this;
    }

    @ApiModelProperty(value="Describes the conditions of provenance of the PGRFA. MCPD equivalent is Biological status of accession [SAMPSTAT].")
    public TermValue getR03() {
        return this.r03;
    }

    public void setR03(TermValue r03) {
        this.r03 = r03;
    }

    public PGRFA r04(Species r04) {
        this.r04 = r04;
        return this;
    }

    @ApiModelProperty(value="Species:                  Specific epithet of the scientific name Species authority:        Authority for the specific epithet Subtaxa: Any additional infra-specific taxon: subspecies, variety, form, Group Subtaxon authority:       Authority for the subtaxon")
    public Species getR04() {
        return this.r04;
    }

    public void setR04(Species r04) {
        this.r04 = r04;
    }

    public PGRFA r05(List<String> r05) {
        this.r05 = r05;
        return this;
    }

    public PGRFA addR05Item(String r05Item) {
        if (this.r05 == null) {
            this.r05 = new ArrayList<String>();
        }
        this.r05.add(r05Item);
        return this;
    }

    @ApiModelProperty(value="Registered names or other designations, such as the name of a landrace, traditional variety or modern cultivar, or some other name or designation used to identify a breeder\u2019s selection or elite line or variety.")
    public List<String> getR05() {
        return this.r05;
    }

    public void setR05(List<String> r05) {
        this.r05 = r05;
    }

    public PGRFA r06(List<OtherIdentifier> r06) {
        this.r06 = r06;
        return this;
    }

    public PGRFA addR06Item(OtherIdentifier r06Item) {
        if (this.r06 == null) {
            this.r06 = new ArrayList<OtherIdentifier>();
        }
        this.r06.add(r06Item);
        return this;
    }

    @ApiModelProperty(value="Any other identifiers that have been assigned to identify the PGRFA material.")
    public List<OtherIdentifier> getR06() {
        return this.r06;
    }

    public void setR06(List<OtherIdentifier> r06) {
        this.r06 = r06;
    }

    public PGRFA r07(TermValue r07) {
        this.r07 = r07;
        return this;
    }

    @ApiModelProperty(value="The status of the PGRFA with regard to the Multilateral System of Access and Benefit-Sharing (MLS) of the International Treaty on Plant Genetic Resources for Food and Agriculture. * 0 Not available under the MLS * 1 Available under the MLS * 11 The sample is of a crop listed in Annex I and is under the management and control of a Contracting Party to the Treaty and declared to be in the public domain * 12 The sample is in a collection subject to an agreement concluded under Article 15 of the Treaty * 13 The holder received the sample with SMTA * 14 The holder has voluntarily placed the sample in the MLS * 15 The sample is derived from, and distinct from, material previously received from the MLS, is still under development and not yet ready for commercialization, and may be made available at the discretion of the developer")
    public TermValue getR07() {
        return this.r07;
    }

    public void setR07(TermValue r07) {
        this.r07 = r07;
    }

    public PGRFA r08(String r08) {
        this.r08 = r08;
        return this;
    }

    @ApiModelProperty(value="Describes whether the PGRFA is still available or permanently lost after being registered. Contains \"y\" or \"n\" string value.")
    public String getR08() {
        return this.r08;
    }

    public void setR08(String r08) {
        this.r08 = r08;
    }

    public PGRFA a01(Location a01) {
        this.a01 = a01;
        return this;
    }

    @ApiModelProperty(value="Location or name of the person or organization that provided the PGRFA to the holder.")
    public Location getA01() {
        return this.a01;
    }

    public void setA01(Location a01) {
        this.a01 = a01;
    }

    public PGRFA a02(String a02) {
        this.a02 = a02;
        return this;
    }

    @ApiModelProperty(value="Unique identifier used by the provider to identify the PGRFA under the provider\u2019s management.")
    public String getA02() {
        return this.a02;
    }

    public void setA02(String a02) {
        this.a02 = a02;
    }

    public PGRFA a03(String a03) {
        this.a03 = a03;
        return this;
    }

    @ApiModelProperty(value="ISO-3166 apha-3 code of country in which the PGRFA material was either collected or bred or selected, or the first country in the known history of the PGRFA.")
    public String getA03() {
        return this.a03;
    }

    public void setA03(String a03) {
        this.a03 = a03;
    }

    public PGRFA a04(List<Location> a04) {
        this.a04 = a04;
        return this;
    }

    public PGRFA addA04Item(Location a04Item) {
        if (this.a04 == null) {
            this.a04 = new ArrayList<Location>();
        }
        this.a04.add(a04Item);
        return this;
    }

    @ApiModelProperty(value="Location of the home base of the person(s) or organization(s) that originally collected the PGRFA from in situ conditions.")
    public List<Location> getA04() {
        return this.a04;
    }

    public void setA04(List<Location> a04) {
        this.a04 = a04;
    }

    public PGRFA a05(String a05) {
        this.a05 = a05;
        return this;
    }

    @ApiModelProperty(value="Identifier assigned by the collector(s) to the PGRFA collected. MCPD equivalent is Collecting number [COLLNUMB].")
    public String getA05() {
        return this.a05;
    }

    public void setA05(String a05) {
        this.a05 = a05;
    }

    public PGRFA a06(String a06) {
        this.a06 = a06;
        return this;
    }

    @ApiModelProperty(value="The identifier, if any, of the mission during which the PGRFA was collected.")
    public String getA06() {
        return this.a06;
    }

    public void setA06(String a06) {
        this.a06 = a06;
    }

    public PGRFA a07(String a07) {
        this.a07 = a07;
        return this;
    }

    @ApiModelProperty(value="Location information below the country level that describes where the PGRFA was collected.")
    public String getA07() {
        return this.a07;
    }

    public void setA07(String a07) {
        this.a07 = a07;
    }

    public PGRFA a08(BigDecimal a08) {
        this.a08 = a08;
        return this;
    }

    @ApiModelProperty(value="Latitude of the location where the PGRFA was collected in decimal degrees.")
    public BigDecimal getA08() {
        return this.a08;
    }

    public void setA08(BigDecimal a08) {
        this.a08 = a08;
    }

    public PGRFA a09(BigDecimal a09) {
        this.a09 = a09;
        return this;
    }

    @ApiModelProperty(value="Longitude of the location where the PGRFA was collected in decimal degrees.")
    public BigDecimal getA09() {
        return this.a09;
    }

    public void setA09(BigDecimal a09) {
        this.a09 = a09;
    }

    public PGRFA a10(String a10) {
        this.a10 = a10;
        return this;
    }

    @ApiModelProperty(value="Uncertainty of the latitude/longitude coordinates of the location where the PGRFA was collected.")
    public String getA10() {
        return this.a10;
    }

    public void setA10(String a10) {
        this.a10 = a10;
    }

    public PGRFA a11(TermValue a11) {
        this.a11 = a11;
        return this;
    }

    @ApiModelProperty(value="The geodetic datum or spatial reference system upon which the latitude/longitude coordinates of the collecting location are based.")
    public TermValue getA11() {
        return this.a11;
    }

    public void setA11(TermValue a11) {
        this.a11 = a11;
    }

    public PGRFA a12(TermValue a12) {
        this.a12 = a12;
        return this;
    }

    @ApiModelProperty(value="The method used to estimate latitude/longitude coordinates of the location where the PGRFA was collected.")
    public TermValue getA12() {
        return this.a12;
    }

    public void setA12(TermValue a12) {
        this.a12 = a12;
    }

    public PGRFA a13(BigDecimal a13) {
        this.a13 = a13;
        return this;
    }

    @ApiModelProperty(value="Elevation of collecting site.")
    public BigDecimal getA13() {
        return this.a13;
    }

    public void setA13(BigDecimal a13) {
        this.a13 = a13;
    }

    public PGRFA a14(String a14) {
        this.a14 = a14;
        return this;
    }

    @ApiModelProperty(value="Date on which the PGRFA was collected. Partial dates are allowed (YYYY-MM?-DD?).")
    public String getA14() {
        return this.a14;
    }

    public void setA14(String a14) {
        this.a14 = a14;
    }

    public PGRFA a15(TermValue a15) {
        this.a15 = a15;
        return this;
    }

    @ApiModelProperty(value="A description of the nature of the location where the PGRFA was collected.")
    public TermValue getA15() {
        return this.a15;
    }

    public void setA15(TermValue a15) {
        this.a15 = a15;
    }

    public PGRFA a16(List<Location> a16) {
        this.a16 = a16;
        return this;
    }

    public PGRFA addA16Item(Location a16Item) {
        if (this.a16 == null) {
            this.a16 = new ArrayList<Location>();
        }
        this.a16.add(a16Item);
        return this;
    }

    @ApiModelProperty(value="Location where the material was bred.")
    public List<Location> getA16() {
        return this.a16;
    }

    public void setA16(List<Location> a16) {
        this.a16 = a16;
    }

    public PGRFA a17(String a17) {
        this.a17 = a17;
        return this;
    }

    @ApiModelProperty(value="The pedigree (genealogy) or other description of the ancestry of the PGRFA and how it was bred.")
    public String getA17() {
        return this.a17;
    }

    public void setA17(String a17) {
        this.a17 = a17;
    }

    public PGRFA info(UpdateInformation info) {
        this.info = info;
        return this;
    }

    @ApiModelProperty(value="")
    public UpdateInformation getInfo() {
        return this.info;
    }

    public void setInfo(UpdateInformation info) {
        this.info = info;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PGRFA PGRFA2 = (PGRFA)o;
        return Objects.equals(this.doi, PGRFA2.doi) && Objects.equals(this.url, PGRFA2.url) && Objects.equals(this.user, PGRFA2.user) && Objects.equals(this.m01, PGRFA2.m01) && Objects.equals(this.m02, PGRFA2.m02) && Objects.equals(this.m03, PGRFA2.m03) && Objects.equals(this.m04, PGRFA2.m04) && Objects.equals(this.m05, PGRFA2.m05) && Objects.equals(this.r01, PGRFA2.r01) && Objects.equals(this.r03, PGRFA2.r03) && Objects.equals(this.r04, PGRFA2.r04) && Objects.equals(this.r05, PGRFA2.r05) && Objects.equals(this.r06, PGRFA2.r06) && Objects.equals(this.r07, PGRFA2.r07) && Objects.equals(this.r08, PGRFA2.r08) && Objects.equals(this.a01, PGRFA2.a01) && Objects.equals(this.a02, PGRFA2.a02) && Objects.equals(this.a03, PGRFA2.a03) && Objects.equals(this.a04, PGRFA2.a04) && Objects.equals(this.a05, PGRFA2.a05) && Objects.equals(this.a06, PGRFA2.a06) && Objects.equals(this.a07, PGRFA2.a07) && Objects.equals(this.a08, PGRFA2.a08) && Objects.equals(this.a09, PGRFA2.a09) && Objects.equals(this.a10, PGRFA2.a10) && Objects.equals(this.a11, PGRFA2.a11) && Objects.equals(this.a12, PGRFA2.a12) && Objects.equals(this.a13, PGRFA2.a13) && Objects.equals(this.a14, PGRFA2.a14) && Objects.equals(this.a15, PGRFA2.a15) && Objects.equals(this.a16, PGRFA2.a16) && Objects.equals(this.a17, PGRFA2.a17) && Objects.equals(this.info, PGRFA2.info);
    }

    public int hashCode() {
        return Objects.hash(this.doi, this.url, this.user, this.m01, this.m02, this.m03, this.m04, this.m05, this.r01, this.r03, this.r04, this.r05, this.r06, this.r07, this.r08, this.a01, this.a02, this.a03, this.a04, this.a05, this.a06, this.a07, this.a08, this.a09, this.a10, this.a11, this.a12, this.a13, this.a14, this.a15, this.a16, this.a17, this.info);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PGRFA {\n");
        sb.append("    doi: ").append(this.toIndentedString(this.doi)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("    m01: ").append(this.toIndentedString(this.m01)).append("\n");
        sb.append("    m02: ").append(this.toIndentedString(this.m02)).append("\n");
        sb.append("    m03: ").append(this.toIndentedString(this.m03)).append("\n");
        sb.append("    m04: ").append(this.toIndentedString(this.m04)).append("\n");
        sb.append("    m05: ").append(this.toIndentedString(this.m05)).append("\n");
        sb.append("    r01: ").append(this.toIndentedString(this.r01)).append("\n");
        sb.append("    r03: ").append(this.toIndentedString(this.r03)).append("\n");
        sb.append("    r04: ").append(this.toIndentedString(this.r04)).append("\n");
        sb.append("    r05: ").append(this.toIndentedString(this.r05)).append("\n");
        sb.append("    r06: ").append(this.toIndentedString(this.r06)).append("\n");
        sb.append("    r07: ").append(this.toIndentedString(this.r07)).append("\n");
        sb.append("    r08: ").append(this.toIndentedString(this.r08)).append("\n");
        sb.append("    a01: ").append(this.toIndentedString(this.a01)).append("\n");
        sb.append("    a02: ").append(this.toIndentedString(this.a02)).append("\n");
        sb.append("    a03: ").append(this.toIndentedString(this.a03)).append("\n");
        sb.append("    a04: ").append(this.toIndentedString(this.a04)).append("\n");
        sb.append("    a05: ").append(this.toIndentedString(this.a05)).append("\n");
        sb.append("    a06: ").append(this.toIndentedString(this.a06)).append("\n");
        sb.append("    a07: ").append(this.toIndentedString(this.a07)).append("\n");
        sb.append("    a08: ").append(this.toIndentedString(this.a08)).append("\n");
        sb.append("    a09: ").append(this.toIndentedString(this.a09)).append("\n");
        sb.append("    a10: ").append(this.toIndentedString(this.a10)).append("\n");
        sb.append("    a11: ").append(this.toIndentedString(this.a11)).append("\n");
        sb.append("    a12: ").append(this.toIndentedString(this.a12)).append("\n");
        sb.append("    a13: ").append(this.toIndentedString(this.a13)).append("\n");
        sb.append("    a14: ").append(this.toIndentedString(this.a14)).append("\n");
        sb.append("    a15: ").append(this.toIndentedString(this.a15)).append("\n");
        sb.append("    a16: ").append(this.toIndentedString(this.a16)).append("\n");
        sb.append("    a17: ").append(this.toIndentedString(this.a17)).append("\n");
        sb.append("    info: ").append(this.toIndentedString(this.info)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

